<?php

/**
 * @package     Joomla.Administrator
 * @subpackage  com_easystore
 *
 * @copyright   (C) 2023 - 2025 JoomShaper. <https://www.joomshaper.com>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use JoomShaper\Component\EasyStore\Administrator\Supports\AccessControl;

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useStyle('com_easystore.admin');

$user = Factory::getApplication()->getIdentity();
$acl = AccessControl::create();
?>
<form action="<?php echo Route::_('index.php?option=com_easystore&task=review.add'); ?>" method="post" name="adminForm" id="adminForm">
<div class="easystore-container">
    <div class="easystore-card">
        <div class="easystore-empty-state">
            <div class="easystore-empty-state-icon mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="157" height="95" fill="none"><path fill="#EFF1FB" d="M15.624 7.662a1.148 1.148 0 1 0 0-2.296 1.148 1.148 0 0 0 0 2.296ZM21.918 4.164a2.082 2.082 0 1 0 0-4.164 2.082 2.082 0 0 0 0 4.164ZM6.024 25.668a4.024 4.024 0 1 0 0-8.047 4.024 4.024 0 0 0 0 8.047Z"/><path fill="#C4C9ED" d="M133.9 39.506H3.463A3.463 3.463 0 0 0 0 42.97v48.533a3.463 3.463 0 0 0 3.463 3.463H133.9a3.462 3.462 0 0 0 3.463-3.463V42.97a3.463 3.463 0 0 0-3.463-3.464Z"/><g fill="#C4C9ED" opacity=".32"><path d="M26.58 68.771c2.07-.87 3.548-3.007 3.559-5.526.015-3.3-2.482-5.985-5.578-6-3.093-.015-5.612 2.648-5.623 5.948-.011 2.541 1.474 4.704 3.57 5.578-4.714.711-6.726 3.834-7.585 6.52a12.695 12.695 0 0 0 7.77 4.188l.89.16a5.61 5.61 0 0 0 2.563-.141 12.689 12.689 0 0 0 7.893-4.223c-.845-2.696-2.819-5.8-7.456-6.5l-.004-.004Z"/><path d="M27.538 79.064a12.7 12.7 0 0 0 6.83-4.656c1.045-1.415 1.934-3.196 2.286-5.245.337-2.033.267-4.326-.57-6.504a11.6 11.6 0 0 0-1.693-3.122c-.715-.981-1.6-1.87-2.626-2.608-2.023-1.514-4.62-2.37-7.297-2.396-2.678.022-5.274.878-7.3 2.396a11.638 11.638 0 0 0-2.63 2.608c-.73.97-1.308 2.026-1.693 3.122-.833 2.178-.907 4.471-.57 6.505.352 2.048 1.24 3.83 2.285 5.244a12.709 12.709 0 0 0 6.83 4.656c1.937.511 3.078.456 3.074.548 0 .026-.277.041-.818.041-.534.007-1.334-.063-2.33-.289-1.97-.426-4.9-1.667-7.204-4.615-1.126-1.46-2.09-3.315-2.49-5.47-.388-2.142-.336-4.56.53-6.879a12.32 12.32 0 0 1 1.771-3.326 12.234 12.234 0 0 1 2.782-2.782c2.144-1.622 4.911-2.54 7.763-2.566 2.848.022 5.619.944 7.76 2.566a12.387 12.387 0 0 1 2.781 2.782 12.438 12.438 0 0 1 1.774 3.326c.864 2.319.92 4.741.53 6.878-.4 2.156-1.363 4.008-2.489 5.471-2.304 2.945-5.233 4.19-7.204 4.615-1 .226-1.796.296-2.333.289"/></g><g fill="#C4C9ED" opacity=".32"><path d="M77.341 53.914H50.84a3.06 3.06 0 0 0 0 6.119H77.34a3.06 3.06 0 0 0 0-6.119ZM50.358 72.797h60.207c2.771 0 5.556.07 8.327 0h.122c1.385 0 2.711-1.218 2.652-2.652-.063-1.433-1.163-2.652-2.652-2.652H58.807c-2.77 0-5.552-.07-8.326 0h-.123c-1.385 0-2.71 1.219-2.652 2.652.063 1.434 1.163 2.652 2.652 2.652ZM50.358 82.123h44.14c2.044 0 4.096.056 6.141 0h.089c1.385 0 2.711-1.219 2.652-2.652-.067-1.433-1.163-2.652-2.652-2.652h-44.14c-2.044 0-4.096-.055-6.14 0h-.09c-1.385 0-2.71 1.219-2.652 2.652.063 1.433 1.163 2.652 2.652 2.652Z"/></g><path fill="#EFF1FB" d="M153.123 21.86H21.868a3.463 3.463 0 0 0-3.463 3.463v48.533a3.463 3.463 0 0 0 3.463 3.463h131.255a3.463 3.463 0 0 0 3.464-3.463V25.327a3.463 3.463 0 0 0-3.464-3.463v-.004Z"/><path fill="#C4C9ED" d="M68.111 34.376a.567.567 0 0 1 1.015 0l.733 1.489 1.634.244a.563.563 0 0 1 .315.96l-1.186 1.17.278 1.64a.565.565 0 0 1-.822.594l-1.46-.77-1.459.77a.566.566 0 0 1-.822-.593l.278-1.64-1.185-1.171a.563.563 0 0 1 .314-.96l1.634-.244.733-1.49ZM77.445 34.376a.567.567 0 0 1 1.015 0l.733 1.489 1.634.244a.563.563 0 0 1 .315.96l-1.186 1.17.278 1.64a.565.565 0 0 1-.822.594l-1.46-.77-1.459.77a.566.566 0 0 1-.822-.593l.278-1.64-1.186-1.171a.563.563 0 0 1 .315-.96l1.634-.244.733-1.49ZM86.779 34.376a.567.567 0 0 1 1.015 0l.733 1.489 1.634.244a.563.563 0 0 1 .314.96l-1.185 1.17.278 1.64a.565.565 0 0 1-.822.594l-1.46-.77-1.459.77a.566.566 0 0 1-.822-.593l.278-1.64-1.186-1.171a.563.563 0 0 1 .315-.96l1.633-.244.734-1.49ZM96.117 34.376a.567.567 0 0 1 1.014 0l.734 1.489 1.633.244a.563.563 0 0 1 .315.96l-1.185 1.17.278 1.64a.565.565 0 0 1-.823.594l-1.46-.77-1.458.77a.566.566 0 0 1-.823-.593l.278-1.64-1.185-1.171a.563.563 0 0 1 .315-.96l1.633-.244.734-1.49Z"/><path fill="#C4C9ED" fill-rule="evenodd" d="M105.143 34.417a.56.56 0 0 1 1.004 0l.722 1.47 1.615.241a.556.556 0 0 1 .307.949l-1.166 1.151.27 1.623a.557.557 0 0 1-.811.585l-1.441-.76-1.441.76a.558.558 0 0 1-.811-.585l.27-1.623-1.166-1.151a.558.558 0 0 1 .307-.949l1.615-.24.722-1.47h.004Zm.5.248-.852 1.73-1.9.285 1.37 1.356-.318 1.907 1.7-.896 1.7.896-.319-1.907 1.371-1.356-1.9-.285-.852-1.73Z" clip-rule="evenodd"/><path fill="#DDE0F9" d="M63.655 50.755h67.971c.918 0 1.837.008 2.752 0h.118c1.152 0 2.256-1.015 2.204-2.204-.052-1.189-.97-2.204-2.204-2.204h-67.97c-.919 0-1.837-.007-2.752 0h-.119c-1.151 0-2.255 1.015-2.203 2.204.051 1.19.97 2.204 2.203 2.204ZM63.655 59.874h50.363c.677 0 1.359.007 2.04 0h.089c1.152 0 2.256-1.015 2.204-2.204-.052-1.189-.97-2.204-2.204-2.204H65.785c-.678 0-1.36-.007-2.04 0h-.09c-1.151 0-2.255 1.015-2.203 2.204.051 1.189.97 2.204 2.203 2.204ZM41.795 60.343c7.963 0 14.416-6.456 14.416-14.415 0-7.96-6.456-14.416-14.416-14.416s-14.416 6.456-14.416 14.416 6.456 14.416 14.416 14.416Z"/><path fill="#C4C9ED" d="M43.288 60.255c3.718-.407 7.037-2.1 9.278-4.652-.952-3.044-3.182-6.544-8.408-7.333 2.337-.982 4-3.393 4.015-6.234.015-3.723-2.804-6.752-6.293-6.77-3.489-.016-6.334 2.988-6.348 6.71-.011 2.867 1.663 5.308 4.03 6.294-5.32.8-7.553 4.218-8.527 7.244 0 0 4.178 5.408 12.253 4.741Z"/></svg>
            </div>

            <div class="easystore-empty-state-title mb-2">
                <?php echo Text::_('COM_EASYSTORE_EMPTYSTATE_REVIEW_TITLE'); ?>
            </div>
            
            <div class="easystore-empty-state-description mb-4">
                <?php echo Text::_($acl->canCreate() ? 'COM_EASYSTORE_EMPTYSTATE_REVIEW_DESCRIPTION' : 'COM_EASYSTORE_EMPTYSTATE_REVIEW_NO_PERMISSION'); ?>
            </div>

            <?php if ($acl->canCreate() || count($user->getAuthorisedCategories('com_easystore', 'core.create')) > 0) : ?>
                <div class="easystore-empty-state-actions">
                    <a href="<?php echo Route::_('index.php?option=com_easystore&task=review.add'); ?>" class="btn btn-primary"><?php echo Text::_('COM_EASYSTORE_EMPTYSTATE_REVIEW_BUTTON_TEXT'); ?></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<input type="hidden" name="task" value="">
<input type="hidden" name="boxchecked" value="0">
<?php echo HTMLHelper::_('form.token'); ?>
</form>
