SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";



-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--


DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__assets`
--


INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES 
(1, 0, 0, 371, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 16, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(8, 1, 17, 70, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(9, 1, 71, 72, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 73, 74, 1, 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 75, 76, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
(12, 1, 77, 78, 1, 'com_login', 'com_login', '{}'),
(13, 1, 79, 80, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 81, 82, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 83, 84, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 85, 92, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
(17, 1, 93, 94, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 95, 138, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
(19, 1, 139, 142, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(20, 1, 143, 144, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
(21, 1, 145, 146, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
(22, 1, 147, 148, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 149, 150, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
(24, 1, 151, 154, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
(26, 1, 155, 156, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 18, 19, 2, 'com_content.category.2', 'Uncategorised', '{}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{}'),
(30, 19, 140, 141, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
(32, 24, 152, 153, 2, 'com_users.category.7', 'Uncategorised', '{}'),
(33, 1, 157, 158, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 159, 160, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(35, 1, 161, 162, 1, 'com_tags', 'com_tags', '{}'),
(36, 1, 163, 164, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 165, 166, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 167, 168, 1, 'com_postinstall', 'com_postinstall', '{}'),
(40, 18, 96, 97, 2, 'com_modules.module.2', 'Login', '{}'),
(41, 18, 98, 99, 2, 'com_modules.module.3', 'Popular Articles', '{}'),
(42, 18, 100, 101, 2, 'com_modules.module.4', 'Recently Added Articles', '{}'),
(43, 18, 102, 103, 2, 'com_modules.module.8', 'Toolbar', '{}'),
(44, 18, 104, 105, 2, 'com_modules.module.9', 'Quick Icons', '{}'),
(45, 18, 106, 107, 2, 'com_modules.module.10', 'Logged-in Users', '{}'),
(46, 18, 108, 109, 2, 'com_modules.module.12', 'Admin Menu', '{}'),
(47, 18, 110, 111, 2, 'com_modules.module.13', 'Admin Submenu', '{}'),
(48, 18, 112, 113, 2, 'com_modules.module.14', 'User Status', '{}'),
(49, 18, 114, 115, 2, 'com_modules.module.15', 'Title', '{}'),
(51, 18, 116, 117, 2, 'com_modules.module.17', 'Breadcrumbs', '{}'),
(52, 18, 118, 119, 2, 'com_modules.module.79', 'Multilanguage status', '{}'),
(53, 18, 120, 121, 2, 'com_modules.module.86', 'Joomla Version', '{}'),
(54, 16, 86, 87, 2, 'com_menus.menu.1', 'Main Menu', '{}'),
(55, 18, 122, 123, 2, 'com_modules.module.87', 'Sample Data', '{}'),
(56, 1, 169, 238, 1, 'com_sppagebuilder', 'SP Page Builder', '{}'),
(60, 56, 170, 171, 2, 'com_sppagebuilder.page.1', 'Home - Legacy', '{}'),
(65, 1, 239, 240, 1, '#__speasyimagegallery_albums.1', '#__speasyimagegallery_albums.1', '{}'),
(66, 56, 172, 173, 2, 'com_sppagebuilder.page.2', 'About', '{}'),
(67, 56, 174, 175, 2, 'com_sppagebuilder.page.3', 'Contact', '{}'),
(68, 56, 176, 177, 2, 'com_sppagebuilder.page.4', 'Services', '{}'),
(69, 8, 20, 69, 2, 'com_content.category.8', 'Blog', '{}'),
(70, 69, 21, 22, 3, 'com_content.article.1', 'How Marching for Science Risks Politicizing It', '{}'),
(71, 69, 23, 24, 3, 'com_content.article.2', 'After Setbacks and Suits, Miami to Open Science Museum', '{}'),
(72, 69, 25, 26, 3, 'com_content.article.3', 'The New Threat to Wolves in and Around Yellowstone', '{}'),
(75, 16, 88, 89, 2, 'com_menus.menu.2', 'Company', '{}'),
(76, 16, 90, 91, 2, 'com_menus.menu.3', 'Quick Links', '{}'),
(78, 69, 27, 28, 3, 'com_content.article.4', 'Broke a Glass? Someday You Might 3-D-Print a New One', '{}'),
(79, 69, 29, 30, 3, 'com_content.article.5', 'Jimmy Kimmel Sheds Light on Health Coverage', '{}'),
(80, 69, 31, 32, 3, 'com_content.article.6', 'As Arctic Ice Vanishes, New Shipping Routes Open', '{}'),
(81, 69, 33, 34, 3, 'com_content.article.7', 'Want to Make More Baskets? Science Has the Answer', '{}'),
(82, 69, 35, 36, 3, 'com_content.article.8', 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', '{}'),
(83, 69, 37, 38, 3, 'com_content.article.9', 'The Making of a Legacy: First Steps in the Trump Era', '{}'),
(84, 18, 124, 125, 2, 'com_modules.module.96', 'Joomla Module', '{}'),
(88, 18, 126, 127, 2, 'com_modules.module.98', 'Latest Articles', '{}'),
(90, 1, 241, 242, 1, 'com_fields', 'com_fields', '{}'),
(91, 1, 243, 244, 1, 'com_associations', 'com_associations', '{}'),
(92, 1, 245, 246, 1, 'com_privacy', 'com_privacy', '{}'),
(93, 1, 247, 248, 1, 'com_actionlogs', 'com_actionlogs', '{}'),
(94, 56, 178, 179, 2, 'com_sppagebuilder.page.5', 'Home - Corporate', '{}'),
(95, 56, 180, 181, 2, 'com_sppagebuilder.page.6', 'Home - Fashion', '{}'),
(96, 56, 182, 183, 2, 'com_sppagebuilder.page.7', 'Home - Life Style', '{}'),
(97, 56, 184, 185, 2, 'com_sppagebuilder.page.8', 'Home - Sea Food', '{}'),
(98, 56, 186, 187, 2, 'com_sppagebuilder.page.9', 'Home - Old', '{}'),
(99, 69, 39, 40, 3, 'com_content.article.10', 'Inside In-Ear Excellence', '{}'),
(100, 69, 41, 42, 3, 'com_content.article.11', 'Crafting classic leather', '{}'),
(101, 69, 43, 44, 3, 'com_content.article.12', 'The All-Encompassing Realm ', '{}'),
(102, 69, 45, 46, 3, 'com_content.article.13', 'The Rise of Smart Speakers', '{}'),
(103, 69, 47, 48, 3, 'com_content.article.14', 'Your MW08 Sport Earphones', '{}'),
(104, 69, 49, 50, 3, 'com_content.article.15', 'Immersive Gaming Experience', '{}'),
(105, 69, 51, 52, 3, 'com_content.article.16', 'How to Choose the Right Laptop for Your Needs', '{}'),
(106, 69, 53, 54, 3, 'com_content.article.17', 'Get to Know Your MW08 Sport Earphones', '{}'),
(107, 69, 55, 56, 3, 'com_content.article.18', 'Know Your Sound Tool: MW08 Sport Earphones', '{}'),
(108, 1, 249, 250, 1, 'com_qsbuilder', 'com_qsbuilder', '{}'),
(109, 1, 251, 252, 1, 'com_guidedtours', 'com_guidedtours', '{}'),
(110, 1, 253, 254, 1, 'com_mails', 'com_mails', '{}'),
(111, 1, 255, 262, 1, 'com_scheduler', 'com_scheduler', '{}'),
(112, 1, 263, 264, 1, 'com_workflow', 'com_workflow', '{}'),
(113, 56, 188, 189, 2, 'com_sppagebuilder.page.10', 'Elements', '{}'),
(114, 111, 256, 257, 2, 'com_scheduler.task.1', 'Rotate Logs', '{}'),
(115, 111, 258, 259, 2, 'com_scheduler.task.2', 'Session GC', '{}'),
(116, 111, 260, 261, 2, 'com_scheduler.task.3', 'Update Notification', '{}'),
(117, 18, 128, 129, 2, 'com_modules.module.121', 'Bottom Section', '{}'),
(118, 56, 190, 191, 2, 'com_sppagebuilder.page.11', 'Bottom Information ', '{}'),
(119, 18, 130, 131, 2, 'com_modules.module.122', 'Footer Section', '{}'),
(120, 56, 192, 193, 2, 'com_sppagebuilder.page.12', 'Bottom Copyright', '{}'),
(121, 1, 265, 370, 1, 'com_easystore', 'com_easystore', '{}'),
(122, 18, 132, 133, 2, 'com_modules.module.123', 'MOD_EASYSTORE_CART_ICON', '{}'),
(123, 121, 266, 267, 2, 'com_easystore.category.2', 'Computer & Laptop', '{}'),
(124, 121, 268, 269, 2, 'com_easystore.product.1', 'Canon EOS R5 Mark', '{}'),
(126, 56, 194, 195, 2, 'com_sppagebuilder.page.13', 'Menu Search', '{}'),
(127, 56, 196, 197, 2, 'com_sppagebuilder.page.14', 'Storefront', '{}'),
(128, 56, 198, 199, 2, 'com_sppagebuilder.page.15', 'Single', '{}'),
(129, 121, 270, 271, 2, 'com_easystore.category.3', 'Mobile & Gadget', '{}'),
(130, 121, 272, 273, 2, 'com_easystore.category.4', 'Watches', '{}'),
(131, 121, 274, 275, 2, 'com_easystore.category.5', 'Electronics', '{}'),
(132, 121, 276, 277, 2, 'com_easystore.category.6', 'Accessories', '{}'),
(133, 121, 278, 279, 2, 'com_easystore.category.7', 'Camera & Lens kit', '{}'),
(134, 121, 280, 281, 2, 'com_easystore.product.2', 'Macbook Pro M2', '{}'),
(135, 121, 282, 283, 2, 'com_easystore.product.3', 'FlexiTab Convertible Laptop', '{}'),
(136, 121, 284, 285, 2, 'com_easystore.product.4', 'VisionX Ultra Laptop', '{}'),
(137, 121, 286, 287, 2, 'com_easystore.product.5', 'Samsung S24', '{}'),
(138, 121, 288, 289, 2, 'com_easystore.product.6', 'Oppo F3', '{}'),
(139, 121, 290, 291, 2, 'com_easystore.product.7', 'EchoBeam Speaker', '{}'),
(140, 121, 292, 293, 2, 'com_easystore.product.8', 'Canon EOS R5', '{}'),
(141, 121, 294, 295, 2, 'com_easystore.product.9', 'Canon EOS R1', '{}'),
(142, 121, 296, 297, 2, 'com_easystore.product.10', 'Omega Seamaster Diver', '{}'),
(143, 121, 298, 299, 2, 'com_easystore.product.11', 'Omega Seamaster', '{}'),
(144, 121, 300, 301, 2, 'com_easystore.product.12', 'Rolex Oyster Submariner', '{}'),
(145, 121, 302, 303, 2, 'com_easystore.product.13', 'Rolex Oyster Perpetual', '{}'),
(146, 121, 304, 305, 2, 'com_easystore.product.14', 'Apple Watch Series 4', '{}'),
(147, 121, 306, 307, 2, 'com_easystore.product.15', 'Fossil Leather Watch', '{}'),
(150, 56, 200, 201, 2, 'com_sppagebuilder.page.16', 'Sidebar Categories', '{}'),
(151, 121, 308, 309, 2, 'com_easystore.product.16', 'CANON RF 35', '{}'),
(152, 121, 310, 311, 2, 'com_easystore.product.17', 'Rokinon Lense', '{}'),
(153, 121, 312, 313, 2, 'com_easystore.product.18', 'Canon EF-S 18', '{}'),
(154, 121, 314, 315, 2, 'com_easystore.product.19', 'PlayStation 5', '{}'),
(156, 121, 316, 317, 2, 'com_easystore.product.21', 'PlayStation', '{}'),
(157, 121, 318, 319, 2, 'com_easystore.product.22', 'Nintendo', '{}'),
(158, 121, 320, 321, 2, 'com_easystore.product.23', 'SoundSphere Earbuds', '{}'),
(159, 121, 322, 323, 2, 'com_easystore.tag.1', 'Camera Lens', '{}'),
(160, 121, 324, 325, 2, 'com_easystore.tag.2', 'Electronics', '{}'),
(161, 121, 326, 327, 2, 'com_easystore.tag.3', 'Gadget', '{}'),
(162, 121, 328, 329, 2, 'com_easystore.tag.4', 'Mobile', '{}'),
(163, 121, 330, 331, 2, 'com_easystore.tag.5', 'Watch', '{}'),
(164, 121, 332, 333, 2, 'com_easystore.tag.6', 'Accessories', '{}'),
(165, 121, 334, 335, 2, 'com_easystore.tag.7', 'New', '{}'),
(166, 121, 336, 337, 2, 'com_easystore.product.24', 'ProTower G500 Desktop PC', '{}'),
(167, 121, 338, 339, 2, 'com_easystore.product.25', 'M4 Portable Mini PC', '{}'),
(168, 121, 340, 341, 2, 'com_easystore.product.26', 'ThunderCore Gaming Laptop', '{}'),
(169, 121, 342, 343, 2, 'com_easystore.product.27', 'Ipad Pro M2', '{}'),
(170, 121, 344, 345, 2, 'com_easystore.product.28', 'Iphone 16 PRO', '{}'),
(171, 121, 346, 347, 2, 'com_easystore.product.29', 'Sony New gen Mini', '{}'),
(172, 121, 348, 349, 2, 'com_easystore.product.30', 'Dji Drone Remote', '{}'),
(173, 121, 350, 351, 2, 'com_easystore.product.31', 'Xbox 360 v2', '{}'),
(174, 121, 352, 353, 2, 'com_easystore.product.32', 'Canon PixelPro X100', '{}'),
(175, 121, 354, 355, 2, 'com_easystore.product.33', 'Fujifilm SnapFlex Z7', '{}'),
(176, 121, 356, 357, 2, 'com_easystore.product.34', 'PrimeVision 50mm f/1.4', '{}'),
(177, 121, 358, 359, 2, 'com_easystore.product.35', 'Acer Chromebook', '{}'),
(178, 56, 202, 203, 2, 'com_sppagebuilder.page.17', 'Shop Categories', '{}'),
(179, 121, 360, 361, 2, 'com_easystore.product.36', 'Xbox Controller', '{}'),
(180, 121, 362, 363, 2, 'com_easystore.product.37', 'Chromebook', '{}'),
(181, 121, 364, 365, 2, 'com_easystore.product.38', 'VisionEdge 8K', '{}'),
(183, 18, 134, 135, 2, 'com_modules.module.128', 'Easystore Searach', '{}'),
(184, 56, 204, 205, 2, 'com_sppagebuilder.page.18', 'Everything coming to Netflix and Amazon Prime in February.', '{}'),
(185, 56, 206, 207, 2, 'com_sppagebuilder.page.19', 'Get to Know Your MW08 Sport Earphones', '{}'),
(186, 56, 208, 209, 2, 'com_sppagebuilder.page.20', 'How to Choose the Right Laptop for Your Needs', '{}'),
(187, 56, 210, 211, 2, 'com_sppagebuilder.page.22', 'Immersive Gaming Experience', '{}'),
(188, 56, 212, 213, 2, 'com_sppagebuilder.page.21', 'Your MW08 Sport Earphones', '{}'),
(189, 56, 214, 215, 2, 'com_sppagebuilder.page.23', 'The Rise of Smart Speakers', '{}'),
(190, 56, 216, 217, 2, 'com_sppagebuilder.page.24', 'The All-Encompassing Realm ', '{}'),
(191, 56, 218, 219, 2, 'com_sppagebuilder.page.26', 'Inside In-Ear Excellence', '{}'),
(192, 56, 220, 221, 2, 'com_sppagebuilder.page.25', 'Crafting classic leather', '{}'),
(193, 18, 136, 137, 2, 'com_modules.module.129', 'Copyright', '{}'),
(194, 69, 57, 58, 3, 'com_content.article.19', 'The Everlasting Digital Domain', '{}'),
(195, 69, 59, 60, 3, 'com_content.article.20', 'The Surge of Virtual Reality', '{}'),
(196, 69, 61, 62, 3, 'com_content.article.21', 'Your ZX12 Studio Headphones', '{}'),
(197, 69, 63, 64, 3, 'com_content.article.22', 'The Digital Horizon', '{}'),
(198, 69, 65, 66, 3, 'com_content.article.23', 'The Evolution of Gaming Consoles', '{}'),
(199, 69, 67, 68, 3, 'com_content.article.24', 'Your AR05 Wireless Earbuds', '{}'),
(200, 56, 222, 223, 2, 'com_sppagebuilder.page.33', 'test', '{}'),
(201, 56, 224, 225, 2, 'com_sppagebuilder.page.34', 'Home - Default', '{}'),
(202, 56, 226, 227, 2, 'com_sppagebuilder.page.32', 'Your AR05 Wireless Earbuds', '{}'),
(203, 56, 228, 229, 2, 'com_sppagebuilder.page.31', 'The Evolution of Gaming Consoles', '{}'),
(204, 56, 230, 231, 2, 'com_sppagebuilder.page.29', 'Your ZX12 Studio Headphones', '{}'),
(205, 56, 232, 233, 2, 'com_sppagebuilder.page.28', 'The Surge of Virtual Reality', '{}'),
(206, 56, 234, 235, 2, 'com_sppagebuilder.page.27', 'The Everlasting Digital Domain', '{}'),
(208, 56, 236, 237, 2, 'com_sppagebuilder.page.30', 'The Digital Horizon', '{}'),
(210, 121, 366, 367, 2, 'com_easystore.product.40', 'Wireless earbuds', '{}'),
(211, 121, 368, 369, 2, 'com_easystore.product.41', 'DJI Mini 4 Pro', '{}');


-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--


DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL,
  `enabled` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '1',
  `protected` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int DEFAULT '0',
  `state` int DEFAULT '0',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__extensions`
--


INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES 
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', '', 1, 1, 1, 0, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(3, 0, 'com_admin', 'component', 'com_admin', '', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(4, 0, 'com_banners', 'component', 'com_banners', '', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, 0, 0, NULL, 1),
(5, 0, 'com_cache', 'component', 'com_cache', '', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(6, 0, 'com_categories', 'component', 'com_categories', '', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(8, 0, 'com_contact', 'component', 'com_contact', '', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"0\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10, 0, 'com_installer', 'component', 'com_installer', '', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}', '{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, 0, 0, NULL, 1),
(11, 0, 'com_languages', 'component', 'com_languages', '', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, 0, 0, NULL, 1),
(12, 0, 'com_login', 'component', 'com_login', '', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(13, 0, 'com_media', 'component', 'com_media', '', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}', '{\"upload_maxsize\":\"30\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"restrict_uploads_extensions\":\"bmp,gif,jpg,jpeg,png,webp,ico,mp3,mp4,odg,odp,ods,odt,pdf,png,ppt,txt,xcf,xls,csv,webp\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png,webp\",\"audio_extensions\":\"mp3,m4a,mp4a,ogg\",\"video_extensions\":\"mp4,mp4v,mpeg,mov,webm\",\"doc_extensions\":\"doc,odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/webp,image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\"}', '', NULL, NULL, 0, 0, NULL, 1),
(14, 0, 'com_menus', 'component', 'com_menus', '', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(15, 0, 'com_messages', 'component', 'com_messages', '', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(16, 0, 'com_modules', 'component', 'com_modules', '', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(19, 10067, 'com_search', 'component', 'com_search', '', '', 1, 0, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"17.06.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"search_phrases\":\"1\",\"search_areas\":\"1\",\"show_date\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\"}', '', NULL, NULL, 0, 0, NULL, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}', '', NULL, NULL, 0, 0, NULL, 1),
(22, 0, 'com_content', 'component', 'com_content', '', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"1\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"record_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_advanced\":1,\"sef_ids\":1,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(23, 0, 'com_config', 'component', 'com_config', '', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, 0, 0, NULL, 1),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', '', 1, 1, 0, 0, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(25, 0, 'com_users', 'component', 'com_users', '', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"enforce_2fa_options\":0,\"domains\":[],\"reset_count\":10,\"reset_time\":1,\"minimum_length\":12,\"minimum_integers\":0,\"minimum_symbols\":0,\"minimum_uppercase\":0,\"minimum_lowercase\":0,\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(27, 0, 'com_finder', 'component', 'com_finder', '', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}', '{\"updatesource\":\"default\",\"minimum_stability\":\"4\",\"customurl\":\"\",\"versioncheck\":\"1\",\"backupcheck\":\"1\",\"autoupdate\":\"0\",\"autoupdate_status\":\"\",\"update_token\":\"\",\"update_last_check\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(29, 0, 'com_tags', 'component', 'com_tags', '', '', 1, 1, 1, 0, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(33, 0, 'com_fields', 'component', 'com_fields', '', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(34, 0, 'com_associations', 'component', 'com_associations', '', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(35, 0, 'com_privacy', 'component', 'com_privacy', '', '', 1, 1, 1, 0, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', '', '', 1, 1, 1, 0, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, 0, 0, NULL, 1),
(103, 0, 'lib_joomla', 'library', 'joomla', '', '', 0, 1, 1, 1, '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"5b48938d5512868fb4ba7a6f12811b7a\"}', '', NULL, NULL, 0, 0, NULL, 1),
(106, 0, 'lib_phpass', 'library', 'phpass', '', '', 0, 1, 1, 1, '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.5.1\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '', 0, 1, 1, 0, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', '', 0, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(208, 0, 'mod_login', 'module', 'mod_login', '', '', 0, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', '', 0, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(213, 10067, 'mod_search', 'module', 'mod_search', '', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_search\"}', '', '', NULL, NULL, 0, 0, NULL, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', '', 0, 1, 1, 0, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', '', 0, 1, 1, 0, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(227, 0, 'files_joomla', 'file', 'joomla', '', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', '', 1, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(304, 0, 'mod_login', 'module', 'mod_login', '', '', 1, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', '', 1, 1, 1, 0, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(311, 0, 'mod_title', 'module', 'mod_title', '', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Title\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', '', 1, 1, 1, 0, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Toolbar\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\MultilangStatus\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(314, 0, 'mod_version', 'module', 'mod_version', '', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 1),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', '', '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, '1970-01-01 00:00:00', 0, 0, NULL, 1),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, '1970-01-01 00:00:00', 0, 0, NULL, 1),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', '', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', '', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, 3, 0, NULL, 1),
(403, 0, 'plg_content_contact', 'plugin', 'contact', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, 1, 0, NULL, 1),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\LoadModule\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, '2011-09-18 15:22:50', 0, 0, NULL, 1),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, 4, 0, NULL, 1),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageNavigation\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, 5, 0, NULL, 1),
(409, 0, 'plg_content_vote', 'plugin', 'vote', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Vote\",\"filename\":\"vote\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', '', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"6.0.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, 1, 0, NULL, 1),
(411, 0, 'plg_editors_none', 'plugin', 'none', '', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', '', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"8.1.2\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"blocks\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styles\",\"|\",\"blocks\",\"fontfamily\",\"fontsize\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"jtemplate\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, 3, 0, NULL, 1),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\PageBreak\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(417, 10067, 'plg_search_categories', 'plugin', 'categories', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(418, 10067, 'plg_search_contacts', 'plugin', 'contacts', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(419, 10067, 'plg_search_content', 'plugin', 'content', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(420, 10067, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageFilter\",\"filename\":\"languagefilter\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(424, 0, 'plg_system_cache', 'plugin', 'cache', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, 9, 0, NULL, 1),
(425, 0, 'plg_system_debug', 'plugin', 'debug', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, 4, 0, NULL, 1),
(426, 0, 'plg_system_log', 'plugin', 'log', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Log\",\"filename\":\"log\"}', '', '', NULL, NULL, 5, 0, NULL, 1),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Redirect\",\"filename\":\"redirect\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(428, 0, 'plg_system_remember', 'plugin', 'remember', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Remember\",\"filename\":\"remember\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(429, 0, 'plg_system_sef', 'plugin', 'sef', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Sef\",\"filename\":\"sef\"}', '', '', NULL, NULL, 8, 0, NULL, 1),
(430, 0, 'plg_system_logout', 'plugin', 'logout', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Logout\",\"filename\":\"logout\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', '', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\ContactCreator\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', NULL, NULL, 1, 0, NULL, 1),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', '', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Joomla\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, 2, 0, NULL, 1),
(433, 0, 'plg_user_profile', 'plugin', 'profile', '', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', '', 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageCode\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, 10, 0, NULL, 1),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Highlight\",\"filename\":\"highlight\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(441, 0, 'plg_content_finder', 'plugin', 'finder', '', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', '', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', '', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(444, 0, 'plg_finder_content', 'plugin', 'content', '', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', '', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', '', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', '', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(451, 10067, 'plg_search_tags', 'plugin', 'tags', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(454, 0, 'plg_system_stats', 'plugin', 'stats', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}', '{\"mode\":1,\"lastrun\":1761305297,\"unique_id\":\"0530094a15022fe01329ac8dc213bd2f7034c441\",\"interval\":12}', '', NULL, NULL, 0, 0, NULL, 1),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', '', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Package\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(456, 0, 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', '', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Folder\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(457, 0, 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', '', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Url\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(461, 0, 'plg_system_fields', 'plugin', 'fields', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(464, 0, 'plg_fields_color', 'plugin', 'color', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(468, 0, 'plg_fields_list', 'plugin', 'list', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(469, 0, 'plg_fields_media', 'plugin', 'media', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(472, 0, 'plg_fields_text', 'plugin', 'text', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(474, 0, 'plg_fields_url', 'plugin', 'url', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(475, 0, 'plg_fields_user', 'plugin', 'user', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(477, 0, 'plg_content_fields', 'plugin', 'fields', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', '', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', '', 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\Blog\",\"filename\":\"blog\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', '', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(483, 0, 'plg_system_actionlogs', 'plugin', 'actionlogs', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ActionLogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(484, 0, 'plg_actionlog_joomla', 'plugin', 'joomla', '', 'actionlog', 0, 1, 1, 0, '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Actionlog\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(487, 0, 'plg_privacy_user', 'plugin', 'user', '', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\User\",\"filename\":\"user\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(489, 0, 'plg_user_terms', 'plugin', 'terms', '', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', '', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(491, 0, 'plg_privacy_content', 'plugin', 'content', '', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(492, 0, 'plg_privacy_message', 'plugin', 'message', '', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Message\",\"filename\":\"message\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', '', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Actionlogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', '', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"2017-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\InvisibleReCaptcha\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, 0, 0, NULL, 0),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', '', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Consents\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"en-GB site language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"en-GB administrator language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10000, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{\"production_mode\":0,\"addcontainer\":\"1\",\"gmap_api\":\"\",\"fontawesome\":1,\"disableanimatecss\":0,\"disablecss\":0,\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\",\"ig_token\":\"{\\\"appId\\\":\\\"\\\",\\\"appSecret\\\":\\\"\\\",\\\"accessToken\\\":\\\"\\\",\\\"igId\\\":\\\"\\\"}\",\"disable_google_fonts\":0,\"lazyloadimg\":0,\"lazyplaceholder\":\"\\/components\\/com_sppagebuilder\\/assets\\/images\\/lazyloading-placeholder.svg\",\"disable_og\":0,\"fb_app_id\":\"\",\"disable_tc\":0,\"google_font_api_key\":\"\",\"enable_ai\":0,\"openai_api_key\":\"\",\"openai_model\":\"gpt-3.5-turbo\",\"enable_frontend_editing\":1,\"container_max_width\":1320,\"sppb_color_variables\":[]}', '', NULL, NULL, 0, 0, NULL, 0),
(10001, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2024 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10004, 0, 'System - Helix Ultimate Framework', 'plugin', 'helixultimate', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix Ultimate Framework\",\"type\":\"plugin\",\"creationDate\":\"Feb 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.2.1\",\"description\":\"Helix Ultimate Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"helixultimate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10006, 0, 'Helix Ultimate based template installer', 'plugin', 'TmplHelixUltimate', '', 'system', 0, 0, 1, 0, '{\"name\":\"Helix Ultimate based template installer\",\"type\":\"plugin\",\"creationDate\":\"JLIB_UNKNOWN\",\"author\":\"JLIB_UNKNOWN\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"\",\"description\":\"Shaper Helix Ultimate - Blank template of Helix Ultimate framework\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"TmplHelixUltimate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10015, 0, 'plg_behaviour_taggable', 'plugin', 'taggable', '', 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10016, 0, 'plg_behaviour_versionable', 'plugin', 'versionable', '', 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10017, 0, 'atum', 'template', 'atum', '', '', 1, 1, 1, 0, '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10018, 0, 'cassiopeia', 'template', 'cassiopeia', '', '', 0, 1, 1, 0, '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10019, 0, 'plg_filesystem_local', 'plugin', 'local', '', 'filesystem', 0, 1, 1, 0, '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10020, 0, 'plg_media-action_crop', 'plugin', 'crop', '', 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Crop\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10021, 0, 'plg_media-action_resize', 'plugin', 'resize', '', 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Resize\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10022, 0, 'plg_media-action_rotate', 'plugin', 'rotate', '', 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Rotate\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10023, 0, 'plg_system_httpheaders', 'plugin', 'httpheaders', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Httpheaders\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10024, 0, 'com_workflow', 'component', 'com_workflow', '', '', 1, 1, 0, 1, '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10025, 0, 'plg_workflow_publishing', 'plugin', 'publishing', '', 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Publishing\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10026, 0, 'plg_workflow_featuring', 'plugin', 'featuring', '', 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Featuring\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10027, 0, 'plg_workflow_notification', 'plugin', 'notification', '', 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Notification\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10028, 0, 'plg_extension_namespacemap', 'plugin', 'namespacemap', '', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10029, 0, 'plg_installer_override', 'plugin', 'override', '', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Override\",\"filename\":\"override\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(10030, 0, 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10031, 0, 'plg_extension_finder', 'plugin', 'finder', '', 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10032, 0, 'plg_api-authentication_basic', 'plugin', 'basic', '', 'api-authentication', 0, 0, 1, 0, '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10033, 0, 'plg_webservices_content', 'plugin', 'content', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10034, 0, 'com_mails', 'component', 'com_mails', '', '', 1, 1, 1, 1, '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10035, 0, 'plg_system_skipto', 'plugin', 'skipto', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Skipto\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10036, 0, 'plg_sampledata_multilang', 'plugin', 'multilang', '', 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\MultiLanguage\",\"filename\":\"multilang\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10037, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', '', 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Web\",\"filename\":\"webinstaller\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10038, 0, 'plg_fields_subform', 'plugin', 'subform', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10039, 0, 'plg_system_webauthn', 'plugin', 'webauthn', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10040, 0, 'mod_loginsupport', 'module', 'mod_loginsupport', '', '', 1, 1, 1, 0, '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10041, 0, 'mod_frontend', 'module', 'mod_frontend', '', '', 1, 1, 1, 0, '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Frontend\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10042, 0, 'mod_messages', 'module', 'mod_messages', '', '', 1, 1, 1, 0, '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Messages\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10043, 0, 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', '', '', 1, 1, 1, 0, '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PostInstallationMessages\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10044, 0, 'mod_user', 'module', 'mod_user', '', '', 1, 1, 1, 0, '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\User\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10045, 0, 'mod_submenu', 'module', 'mod_submenu', '', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10046, 0, 'mod_privacy_status', 'module', 'mod_privacy_status', '', '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10047, 0, 'plg_webservices_banners', 'plugin', 'banners', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Banners\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10048, 0, 'plg_webservices_config', 'plugin', 'config', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Config\",\"filename\":\"config\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10049, 0, 'plg_webservices_contact', 'plugin', 'contact', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10050, 0, 'plg_webservices_languages', 'plugin', 'languages', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Languages\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10051, 0, 'plg_webservices_menus', 'plugin', 'menus', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10052, 0, 'plg_webservices_messages', 'plugin', 'messages', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Messages\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10053, 0, 'plg_webservices_modules', 'plugin', 'modules', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10054, 0, 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10055, 0, 'plg_webservices_plugins', 'plugin', 'plugins', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Plugins\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10056, 0, 'plg_webservices_privacy', 'plugin', 'privacy', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Privacy\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10057, 0, 'plg_webservices_redirect', 'plugin', 'redirect', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10058, 0, 'plg_webservices_tags', 'plugin', 'tags', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10059, 0, 'plg_webservices_templates', 'plugin', 'templates', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Templates\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10060, 0, 'plg_webservices_users', 'plugin', 'users', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Users\",\"filename\":\"users\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10061, 0, 'plg_webservices_installer', 'plugin', 'installer', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Installer\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10062, 0, 'plg_user_token', 'plugin', 'token', '', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10063, 0, 'plg_api-authentication_token', 'plugin', 'token', '', 'api-authentication', 0, 1, 1, 0, '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10064, 0, 'plg_system_accessibility', 'plugin', 'accessibility', '', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Accessibility\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10065, 802, 'English (en-GB)', 'language', 'en-GB', '', '', 3, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"en-GB api language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10066, 0, 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10067, 0, 'pkg_search', 'package', 'pkg_search', '', '', 0, 1, 1, 0, '{\"name\":\"pkg_search\",\"type\":\"package\",\"creationDate\":\"2021-08-17\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_search\"}', '', '', NULL, NULL, 0, 0, NULL, 0),
(10079, 0, 'com_scheduler', 'component', 'com_scheduler', '', '', 1, 1, 1, 0, '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10080, 0, 'plg_system_schedulerunner', 'plugin', 'schedulerunner', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ScheduleRunner\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10081, 0, 'plg_system_task_notification', 'plugin', 'tasknotification', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\TaskNotification\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, 22, 0, NULL, 1),
(10082, 0, 'plg_task_check_files', 'plugin', 'checkfiles', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10084, 0, 'plg_task_requests', 'plugin', 'requests', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10085, 0, 'plg_task_site_status', 'plugin', 'sitestatus', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, 15, 0, NULL, 1),
(10086, 0, 'plg_system_jooa11y', 'plugin', 'jooa11y', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jooa11y\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10087, 0, 'plg_webservices_media', 'plugin', 'media', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Media\",\"filename\":\"media\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10092, 0, 'plg_multifactorauth_totp', 'plugin', 'totp', '', 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Totp\",\"filename\":\"totp\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(10093, 0, 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', '', 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Yubikey\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(10094, 0, 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', '', 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Webauthn\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(10095, 0, 'plg_multifactorauth_email', 'plugin', 'email', '', 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Email\",\"filename\":\"email\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(10096, 0, 'plg_multifactorauth_fixed', 'plugin', 'fixed', '', 'multifactorauth', 0, 0, 1, 0, '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Fixed\",\"filename\":\"fixed\"}', '', '', NULL, NULL, 5, 0, NULL, 1),
(10097, 0, 'plg_system_shortcut', 'plugin', 'shortcut', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Shortcut\",\"filename\":\"shortcut\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10099, 0, 'System - SP Page Builder Lite Updater', 'plugin', 'sppagebuilderliteupdater', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Lite Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2022\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.10\",\"description\":\"SP Page Builder Lite Updater Plugin\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilderliteupdater\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10101, 0, 'com_guidedtours', 'component', 'com_guidedtours', '', '', 1, 1, 0, 0, '{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10102, 0, 'mod_guidedtours', 'module', 'mod_guidedtours', '', '', 1, 1, 1, 0, '{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10103, 0, 'plg_system_guidedtours', 'plugin', 'guidedtours', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10106, 0, 'plg_quickicon_eos', 'plugin', 'eos', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_eos\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_QUICKICON_EOS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Eos\",\"filename\":\"eos\"}', '{\"last_snoozed_id\":2}', '', NULL, NULL, 7, 0, NULL, 1),
(10120, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10121, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10122, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', '', 'search', 0, 0, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10123, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', '', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10124, 0, 'Content - SP Page Builder', 'plugin', 'sppagebuilder', '', 'content', 0, 1, 1, 0, '{\"name\":\"Content - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10127, 0, 'plg_sppagebuilder_loadmodule', 'plugin', 'sppagebuilderloadmodule', '', 'content', 0, 1, 1, 0, '{\"name\":\"plg_sppagebuilder_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2024-10\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 joomshaper.com.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"PLG_SPPAGEBUILDER_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\Content\\\\Sppagebuilderloadmodule\",\"filename\":\"sppagebuilderloadmodule\"}', '{\"style\":\"none\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10128, 0, 'plg_schemaorg_blogposting', 'plugin', 'blogposting', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_blogposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BLOGPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\BlogPosting\",\"filename\":\"blogposting\"}', '{}', '', NULL, NULL, 1, 0, NULL, 1),
(10129, 0, 'plg_schemaorg_book', 'plugin', 'book', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_book\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BOOK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Book\",\"filename\":\"book\"}', '{}', '', NULL, NULL, 2, 0, NULL, 1),
(10130, 0, 'plg_schemaorg_event', 'plugin', 'event', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_event\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_EVENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Event\",\"filename\":\"event\"}', '{}', '', NULL, NULL, 3, 0, NULL, 1),
(10131, 0, 'plg_schemaorg_organization', 'plugin', 'organization', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_organization\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_ORGANIZATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Organization\",\"filename\":\"organization\"}', '{}', '', NULL, NULL, 4, 0, NULL, 1),
(10132, 0, 'plg_schemaorg_person', 'plugin', 'person', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_person\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_PERSON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Person\",\"filename\":\"person\"}', '{}', '', NULL, NULL, 5, 0, NULL, 1),
(10133, 0, 'plg_schemaorg_recipe', 'plugin', 'recipe', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_recipe\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_RECIPE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Recipe\",\"filename\":\"recipe\"}', '{}', '', NULL, NULL, 6, 0, NULL, 1),
(10134, 0, 'plg_schemaorg_jobposting', 'plugin', 'jobposting', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_jobposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_JOBPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\JobPosting\",\"filename\":\"jobposting\"}', '{}', '', NULL, NULL, 7, 0, NULL, 1),
(10135, 0, 'plg_system_schemaorg', 'plugin', 'schemaorg', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_schemaorg\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SYSTEM_SCHEMAORG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Schemaorg\",\"filename\":\"schemaorg\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10136, 0, 'plg_task_globalcheckin', 'plugin', 'globalcheckin', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_globalcheckin\",\"type\":\"plugin\",\"creationDate\":\"2023-06-22\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_GLOBALCHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Globalcheckin\",\"filename\":\"globalcheckin\"}', '{}', '', NULL, NULL, 5, 0, NULL, 1),
(10137, 0, 'plg_task_deleteactionlogs', 'plugin', 'deleteactionlogs', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_deleteactionlogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_DELETEACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DeleteActionLogs\",\"filename\":\"deleteactionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10138, 0, 'plg_task_privacyconsent', 'plugin', 'privacyconsent', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10139, 0, 'plg_task_rotatelogs', 'plugin', 'rotatelogs', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_rotatelogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_ROTATELOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\RotateLogs\",\"filename\":\"rotatelogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10140, 0, 'plg_task_sessiongc', 'plugin', 'sessiongc', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2023-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SessionGC\",\"filename\":\"sessiongc\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10141, 0, 'plg_task_updatenotification', 'plugin', 'updatenotification', '', 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\UpdateNotification\",\"filename\":\"updatenotification\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10142, 0, 'plg_schemaorg_article', 'plugin', 'article', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_article\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Article\",\"filename\":\"article\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10143, 0, 'plg_schemaorg_custom', 'plugin', 'custom', '', 'schemaorg', 0, 1, 1, 0, '{\"name\":\"plg_schemaorg_custom\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Custom\",\"filename\":\"custom\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10144, 0, 'MOD_ARTICLES', 'module', 'mod_articles', '', '', 0, 1, 0, 0, '{\"name\":\"MOD_ARTICLES\",\"type\":\"module\",\"creationDate\":\"2024-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.2.0\",\"description\":\"MOD_ARTICLES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Articles\",\"filename\":\"mod_articles\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10145, 0, 'com_easystore', 'component', 'com_easystore', '', '', 1, 1, 0, 0, '{\"name\":\"com_easystore\",\"type\":\"component\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2025 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.7.2\",\"description\":\"EasyStore - The Ultimate eCommerce Extension for Joomla 4, Joomla 5 and Joomla 6\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Component\\\\EasyStore\",\"filename\":\"easystore\"}', '{\"joomshaper_email\":\"sreema1392@gmail.com\",\"joomshaper_license_key\":\"f5e995e4b3137e713fd6e3d31ec661e0\",\"installed_on\":\"2025-02-19 09:42:08\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10146, 0, 'MOD_EASYSTORE_CART_ICON', 'module', 'mod_easystore_cart_icon', '', '', 0, 1, 0, 0, '{\"name\":\"MOD_EASYSTORE_CART_ICON\",\"type\":\"module\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2025 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.7\",\"description\":\"MOD_EASYSTORE_CART_ICON_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_easystore_cart_icon\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10147, 0, 'PLG_EASYSTORE_PAYPAL', 'plugin', 'paypal', '', 'easystore', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_PAYPAL\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2025 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.0.2\",\"description\":\"PLG_EASYSTORE_PAYPAL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\EasyStore\\\\Paypal\",\"filename\":\"paypal\"}', '{\"title\":\"PayPal\",\"shop_environment\":\"sandbox\",\"payment_instruction\":\"You will be redirected to the secure PayPal payment portal to complete your purchase. After the payment is processed, you will be redirected back to this website\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10148, 0, 'PLG_EASYSTORE_COD', 'plugin', 'cod', '', 'easystore', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_COD\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.1\",\"description\":\"PLG_EASYSTORE_COD_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\EasyStore\\\\CashOnDelivery\",\"filename\":\"cod\"}', '{\"title\":\"Cash On Delivery\",\"payment_type\":\"manual\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10149, 0, 'PLG_EASYSTORE_UPDATER', 'plugin', 'easystoreupdater', '', 'system', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_UPDATER\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2025 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.3\",\"description\":\"PLG_EASYSTORE_UPDATER_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"easystoreupdater\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10150, 0, 'PLG_EASYSTORE_MAIL', 'plugin', 'easystoremail', '', 'system', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_MAIL\",\"type\":\"plugin\",\"creationDate\":\"2023-12\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_EASYSTORE_MAIL_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\System\\\\EasyStoreMail\",\"filename\":\"easystoremail\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10151, 0, 'EasyStore Core Plugin', 'plugin', 'easystorecore', '', 'system', 0, 1, 1, 0, '{\"name\":\"EasyStore Core Plugin\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"EasyStore System Core Plugin\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\System\\\\EasyStoreCore\",\"filename\":\"easystorecore\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10152, 0, 'EasyStore Customer Profile Plugin', 'plugin', 'easystoreprofile', '', 'user', 0, 1, 1, 0, '{\"name\":\"EasyStore Customer Profile Plugin\",\"type\":\"plugin\",\"creationDate\":\"2024-07\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"EasyStore Cutomer Profile Plugin\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\User\\\\EasyStoreProfile\",\"filename\":\"easystoreprofile\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10153, 0, 'plg_system_easystoretoj2storemigration', 'plugin', 'easystoretoj2storemigration', '', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_easystoretoj2storemigration\",\"type\":\"plugin\",\"creationDate\":\"2024-3\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"EasyStore Migration Plugin from J2Store\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\System\\\\EasyStoreToJ2storeMigration\",\"filename\":\"easystoretoj2storemigration\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10154, 0, 'plg_finder_easystore', 'plugin', 'easystore', '', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_easystore\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2025 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_FINDER_EASYSTORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\Finder\\\\Easystore\",\"filename\":\"easystore\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10155, 0, 'EasyStore Quick Icon Plugin', 'plugin', 'easystorequickicon', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"EasyStore Quick Icon Plugin\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2023 - 2025 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_QUICKICON_EASYSTORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\Quickicon\\\\Easystorequickicon\",\"filename\":\"easystorequickicon\"}', '{\"context\":\"site_quickicon\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10156, 0, 'PLG_EASYSTORE_LOADMODULE', 'plugin', 'easystoreloadmodule', '', 'content', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_LOADMODULE\",\"type\":\"plugin\",\"creationDate\":\"2024-10\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 joomshaper.com.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_EASYSTORE_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\Content\\\\EasyStoreLoadModule\",\"filename\":\"easystoreloadmodule\"}', '{\"style\":\"none\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10157, 0, 'PLG_EASYSTORE_BANK_TRANSFER', 'plugin', 'banktransfer', '', 'easystore', 0, 1, 1, 0, '{\"name\":\"PLG_EASYSTORE_BANK_TRANSFER\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"PLG_EASYSTORE_BANK_TRANSFER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\EasyStore\\\\BankTransfer\",\"filename\":\"banktransfer\"}', '{\"title\":\"Bank Transfer\",\"additional_information\":\"Mastercard\",\"payment_instruction\":\"\",\"payment_type\":\"manual\"}', '', NULL, NULL, 0, 0, '', 0),
(10158, 0, 'SP Simple Portfolio - SP Page Builder', 'plugin', 'sppagebuilder', '', 'spsimpleportfolio', 0, 0, 1, 0, '{\"name\":\"SP Simple Portfolio - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Mar 2019\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"6.1.0\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10159, 0, 'MOD_EASYSTORE_SEARCH', 'module', 'mod_easystore_search', '', '', 0, 1, 0, 0, '{\"name\":\"MOD_EASYSTORE_SEARCH\",\"type\":\"module\",\"creationDate\":\"2025-01\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2025 JoomShaper.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"MOD_EASYSTORE_SEARCH_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Module\\\\EasyStore\",\"filename\":\"mod_easystore_search\"}', '{\"show_category\":\"1\",\"show_search_button\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10160, 0, 'megadeal_ii', 'template', 'megadeal_ii', '', '', 0, 1, 1, 0, '{\"name\":\"megadeal_ii\",\"type\":\"template\",\"creationDate\":\"Feb 2025\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.0.1\",\"description\":\"Megadeal_ii - The Best Responsive Deals\\/eCommerce Template for Joomla\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10161, 0, 'Helix Ultimate Preset Option', 'module', 'mod_helixultimate_options', '', '', 0, 1, 0, 0, '{\"name\":\"Helix Ultimate Preset Option\",\"type\":\"module\",\"creationDate\":\"October 22, 2024\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 JoomShaper\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"1.0.0\",\"description\":\"Preset manager for Helix Ultimate based template.\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Module\\\\HelixUltimateOptions\",\"filename\":\"mod_helixultimate_options\"}', '{\"presets\":\"4\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10163, 0, 'plg_user_profileimage', 'plugin', 'profileimage', '', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profileimage\",\"type\":\"plugin\",\"creationDate\":\"2024-01-01\",\"author\":\"Custom Developer\",\"copyright\":\"(C) 2024 Custom Developer\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"6.1.0\",\"description\":\"PLG_USER_PROFILEIMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profileimage\",\"filename\":\"profileimage\"}', '{\"upload_path\":\"images\\/profiles\",\"max_file_size\":\"2097152\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10164, 0, 'plg_extension_joomlaupdate', 'plugin', 'joomlaupdate', '', 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"PLG_EXTENSION_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10165, 0, 'plg_behaviour_compat6', 'plugin', 'compat6', '', 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_compat6\",\"type\":\"plugin\",\"creationDate\":\"2025-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"PLG_COMPAT6_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Compat6\",\"filename\":\"compat6\"}', '{\"classes_aliases\":\"1\",\"legacy_classes\":\"1\"}', '', NULL, NULL, -1, 0, NULL, 1),
(10166, 0, 'plg_quickicon_autoupdate', 'plugin', 'autoupdate', '', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_autoupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"PLG_QUICKICON_AUTOUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Autoupdate\",\"filename\":\"autoupdate\"}', '', '', NULL, NULL, -1, 0, NULL, 1),
(10167, 0, 'plg_webservices_joomlaupdate', 'plugin', 'joomlaupdate', '', 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"PLG_WEBSERVICES_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, -1, 0, NULL, 1),
(10168, 0, 'plg_fields_note', 'plugin', 'note', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_note\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"PLG_FIELDS_NOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Note\",\"filename\":\"note\"}', '{\"class\":\"alert alert-info\",\"heading\":\"h4\"}', '', NULL, NULL, -1, 0, NULL, 1),
(10169, 0, 'plg_fields_number', 'plugin', 'number', '', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_number\",\"type\":\"plugin\",\"creationDate\":\"2025-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"6.0.0\",\"description\":\"PLG_FIELDS_NUMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Number\",\"filename\":\"number\"}', '{\"min\":\"1.0\",\"max\":\"100.0\",\"step\":\"0.1\",\"currency\":\"0\",\"position\":\"0\",\"decimals\":\"2\"}', '', NULL, NULL, -1, 0, NULL, 1),
(10170, 0, 'cassiopeia_extended', 'template', 'cassiopeia_extended', '', '', 0, 1, 1, 0, '{\"name\":\"cassiopeia_extended\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_EXTENDED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":false,\"parent\":\"cassiopeia\",\"filename\":\"templateDetails\"}', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"systemFontBody\":\"\",\"systemFontHeading\":\"\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":\"0\",\"backTop\":\"0\",\"colorSettings\":\"0\",\"headerbg\":\"rgb(193, 205, 207)\",\"headercolor\":\"rgb(23, 23, 23)\",\"bodybg\":\"rgb(254, 254, 254)\",\"bodycolor\":\"rgb(23, 23, 23)\",\"linkcolor\":\"rgb(29, 121, 137)\",\"linkcolorh\":\"rgb(14, 59, 67)\",\"btnbg\":\"rgb(206, 60, 55)\",\"btnbgh\":\"rgb(131, 35, 32)\",\"btncolor\":\"rgb(254, 254, 254)\",\"btncolorh\":\"rgb(254, 254, 254)\",\"footerbg\":\"rgb(29, 121, 137)\",\"footercolor\":\"rgb(254, 254, 254)\",\"fontSettings\":\"0\",\"bodysize\":\"1\",\"h1size\":\"2\",\"h2size\":\"1.7\",\"h3size\":\"1.5\"}', '', NULL, NULL, 0, 0, NULL, 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__languages`
--


DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE `#__languages` (
  `lang_id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__languages`
--


INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES 
(1, 0, 'en-GB', 'English (en-GB)', 'English (United Kingdom)', 'en', 'en_gb', '', '', '', '', 1, 1, 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__menu`
--


DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE `#__menu` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `browserNav` tinyint NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=480 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__menu`
--


INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`, `publish_up`, `publish_down`) VALUES 
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, NULL, NULL, 0, 0, '', 0, '', 0, 121, 0, '*', 0, NULL, NULL),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, NULL, NULL, 0, 0, 'class:bookmark', 0, '', 1, 10, 0, '*', 1, NULL, NULL),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners&view=banners', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1, NULL, NULL),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&view=categories&extension=com_banners', 'component', 1, 2, 2, 6, NULL, NULL, 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1, NULL, NULL),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1, NULL, NULL),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, NULL, NULL, 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1, NULL, NULL),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, NULL, NULL, 0, 0, 'class:address-book', 0, '', 31, 42, 0, '*', 1, NULL, NULL),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact&view=contacts', 'component', 1, 7, 2, 8, NULL, NULL, 0, 0, 'class:contact', 0, '', 32, 33, 0, '*', 1, NULL, NULL),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&view=categories&extension=com_contact', 'component', 1, 7, 2, 6, NULL, NULL, 0, 0, 'class:contact-cat', 0, '', 34, 35, 0, '*', 1, NULL, NULL),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, NULL, NULL, 0, 0, 'class:rss', 0, '', 43, 48, 0, '*', 1, NULL, NULL),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds&view=newsfeeds', 'component', 1, 13, 2, 17, NULL, NULL, 0, 0, 'class:newsfeeds', 0, '', 44, 45, 0, '*', 1, NULL, NULL),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&view=categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, NULL, NULL, 0, 0, 'class:newsfeeds-cat', 0, '', 46, 47, 0, '*', 1, NULL, NULL),
(18, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, NULL, NULL, 0, 0, 'class:search-plus', 0, '', 49, 60, 0, '*', 1, NULL, NULL),
(20, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags&view=tags', 'component', 1, 1, 1, 29, NULL, NULL, 0, 1, 'class:tags', 0, '', 61, 62, 0, '', 1, NULL, NULL),
(22, 'main', 'com_associations', 'Multilingual Associations', '', 'Multilingual Associations', 'index.php?option=com_associations&view=associations', 'component', 1, 1, 1, 34, NULL, NULL, 0, 0, 'class:language', 0, '', 63, 64, 0, '*', 1, NULL, NULL),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_sppagebuilder&view=page&id=34', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 11, 12, 1, '*', 0, NULL, NULL),
(107, 'mainmenu', 'About', 'about', '', 'about', 'index.php?option=com_sppagebuilder&view=page&id=2', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Your Trusted Electronics Destination\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/header-img7.png#joomlaImage:\\/\\/local-images\\/header-img7.png?width=1022&height=784\"}', 13, 14, 0, '*', 0, NULL, NULL),
(108, 'mainmenu', 'Pages', 'pages', '', 'pages', '#', 'url', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"badge\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_position\\\":\\\"right\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"faicon\\\":\\\"\\\",\\\"megamenu\\\":\\\"0\\\",\\\"menualign\\\":\\\"right\\\",\\\"showtitle\\\":\\\"1\\\",\\\"width\\\":\\\"600\\\"}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 17, 28, 0, '*', 0, NULL, NULL),
(109, 'mainmenu', 'Login', 'login', '', 'pages/login', 'index.php?option=com_users&view=login', 'component', 1, 108, 2, 25, NULL, NULL, 0, 1, ' ', 0, '{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"login_image_alt\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"logout_image_alt\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/cotact-header-bg-2.png#joomlaImage:\\/\\/local-images\\/demo\\/cotact-header-bg-2.png?width=607&height=392\"}', 20, 21, 0, '*', 0, NULL, NULL),
(110, 'mainmenu', 'Registration', 'registration', '', 'pages/registration', 'index.php?option=com_users&view=registration', 'component', 1, 108, 2, 25, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/cotact-header-bg-2.png#joomlaImage:\\/\\/local-images\\/demo\\/cotact-header-bg-2.png?width=607&height=392\"}', 22, 23, 0, '*', 0, NULL, NULL),
(111, 'mainmenu', '404', '404', '', 'pages/404', 'index.php?Itemid=404', 'url', 1, 108, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 24, 25, 0, '*', 0, NULL, NULL),
(112, 'mainmenu', 'Coming Soon', 'coming-soon', '', 'pages/coming-soon', '?tmpl=comingsoon', 'url', 1, 108, 2, 0, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 26, 27, 0, '*', 0, NULL, NULL),
(113, 'mainmenu', 'Contact', 'contact', '', 'pages/contact', 'index.php?option=com_sppagebuilder&view=page&id=3', 'component', 1, 108, 2, 10000, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"We Are Here to Help\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/cotact-header-bg-2.png#joomlaImage:\\/\\/local-images\\/demo\\/cotact-header-bg-2.png?width=607&height=392\"}', 18, 19, 0, '*', 0, NULL, NULL),
(115, 'mainmenu', 'Blog', 'blog', '', 'blog', 'index.php?option=com_content&view=category&layout=blog&id=8', 'component', 1, 1, 1, 22, NULL, NULL, 0, 1, ' ', 0, '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title_text\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"num_leading_articles\":3,\"blog_class_leading\":\"megadeal-leading-layout\",\"num_intro_articles\":6,\"blog_class\":\"\",\"num_columns\":3,\"multi_column_order\":\"1\",\"num_links\":0,\"show_featured\":\"\",\"link_intro_image\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"none\",\"orderby_sec\":\"rdate\",\"order_date\":\"created\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"1\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"0\",\"show_hits\":\"0\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"Latest Our Blog News\",\"helixultimate_page_subtitle\":\"Read the last updates and news about our brand and line of products.\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/blog-page-title-bg.png#joomlaImage:\\/\\/local-images\\/demo\\/blog-page-title-bg.png?width=562&height=383\"}', 29, 30, 0, '*', 0, NULL, NULL),
(116, 'company', 'About', 'about-us', '', 'about-us', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"107\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 65, 66, 0, '*', 0, NULL, NULL),
(117, 'company', 'Services', 'our-services', '', 'our-services', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"114\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 67, 68, 0, '*', 0, NULL, NULL),
(118, 'company', 'Portfolio', 'our-portfolio', '', 'our-portfolio', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"105\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 69, 70, 0, '*', 0, NULL, NULL),
(119, 'company', 'Gallery', 'photo-gallery', '', 'photo-gallery', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"106\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 71, 72, 0, '*', 0, NULL, NULL),
(120, 'company', 'Blog', 'blogs', '', 'blogs', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, NULL, NULL, 0, 1, ' ', 0, '{\"aliasoptions\":\"115\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"helixultimatemenulayout\":\"{\\\"width\\\":600,\\\"menualign\\\":\\\"right\\\",\\\"megamenu\\\":0,\\\"showtitle\\\":1,\\\"faicon\\\":\\\"\\\",\\\"customclass\\\":\\\"\\\",\\\"dropdown\\\":\\\"right\\\",\\\"badge\\\":\\\"\\\",\\\"badge_position\\\":\\\"\\\",\\\"badge_bg_color\\\":\\\"\\\",\\\"badge_text_color\\\":\\\"\\\",\\\"layout\\\":[]}\",\"helixultimate_enable_page_title\":\"0\",\"helixultimate_page_title_alt\":\"\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"\"}', 73, 74, 0, '*', 0, NULL, NULL),
(179, 'main', '-', '1629471804-0575', '', 'Contacts/1629471804-0575', '#', 'separator', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 36, 37, 0, '*', 1, NULL, NULL),
(180, 'main', 'mod_menu_fields', 'contact-custom-fields', '', 'Contacts/contact-custom-fields', 'index.php?option=com_fields&context=com_contact.contact', 'component', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 38, 39, 0, '*', 1, NULL, NULL),
(181, 'main', 'mod_menu_fields_group', 'contact-custom-fields-group', '', 'Contacts/contact-custom-fields-group', 'index.php?option=com_fields&view=groups&context=com_contact.contact', 'component', 1, 7, 2, 33, NULL, NULL, 0, 0, ' ', 0, '{}', 40, 41, 0, '*', 1, NULL, NULL),
(182, 'main', '-', '1629471804-0617', '', 'Smart Search/1629471804-0617', '#', 'separator', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 50, 51, 0, '*', 1, NULL, NULL),
(183, 'main', 'com_finder_index', 'smart-search-index', '', 'Smart Search/smart-search-index', 'index.php?option=com_finder&view=index', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 52, 53, 0, '*', 1, NULL, NULL),
(184, 'main', 'com_finder_maps', 'smart-search-maps', '', 'Smart Search/smart-search-maps', 'index.php?option=com_finder&view=maps', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 54, 55, 0, '*', 1, NULL, NULL),
(185, 'main', 'com_finder_filters', 'smart-search-filters', '', 'Smart Search/smart-search-filters', 'index.php?option=com_finder&view=filters', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 56, 57, 0, '*', 1, NULL, NULL),
(186, 'main', 'com_finder_searches', 'smart-search-searches', '', 'Smart Search/smart-search-searches', 'index.php?option=com_finder&view=searches', 'component', 1, 18, 2, 27, NULL, NULL, 0, 0, ' ', 0, '{}', 58, 59, 0, '*', 1, NULL, NULL),
(246, 'main', 'Search', 'search', '', 'search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, NULL, NULL, 0, 1, 'class:search', 0, '{}', 75, 76, 0, '', 1, NULL, NULL),
(358, 'mainmenu', 'Shop', 'shop', '', 'shop', 'index.php?option=com_easystore&view=products&catid=0', 'component', 1, 1, 1, 10145, NULL, NULL, 0, 1, ' ', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"helixultimatemenulayout\":\"\",\"helixultimate_enable_page_title\":\"1\",\"helixultimate_page_title_alt\":\"All Products\",\"helixultimate_page_subtitle\":\"\",\"helixultimate_page_title_heading\":\"h2\",\"helixultimate_page_title_bg_color\":\"\",\"helixultimate_page_title_bg_image\":\"images\\/demo\\/product-head-bg.png#joomlaImage:\\/\\/local-images\\/demo\\/product-head-bg.png?width=1208&height=392\"}', 15, 16, 0, '*', 0, NULL, NULL),
(458, 'main', 'COM_EASYSTORE', 'com-easystore', '', 'com-easystore', 'index.php?option=com_easystore', 'component', 1, 1, 1, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 77, 102, 0, '', 1, NULL, NULL),
(459, 'main', 'COM_EASYSTORE_DASHBOARD', 'com-easystore-dashboard', '', 'com-easystore/com-easystore-dashboard', 'index.php?option=com_easystore&view=dashboard', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 78, 79, 0, '', 1, NULL, NULL),
(460, 'main', 'COM_EASYSTORE_PRODUCTS', 'com-easystore-products', '', 'com-easystore/com-easystore-products', 'index.php?option=com_easystore&view=products', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 80, 81, 0, '', 1, NULL, NULL),
(461, 'main', 'COM_EASYSTORE_COLLECTIONS', 'com-easystore-collections', '', 'com-easystore/com-easystore-collections', 'index.php?option=com_easystore&view=collections', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 82, 83, 0, '', 1, NULL, NULL),
(462, 'main', 'COM_EASYSTORE_CATEGORIES', 'com-easystore-categories', '', 'com-easystore/com-easystore-categories', 'index.php?option=com_easystore&view=categories', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 84, 85, 0, '', 1, NULL, NULL),
(463, 'main', 'COM_EASYSTORE_BRANDS', 'com-easystore-brands', '', 'com-easystore/com-easystore-brands', 'index.php?option=com_easystore&view=brands', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 86, 87, 0, '', 1, NULL, NULL),
(464, 'main', 'COM_EASYSTORE_TAGS', 'com-easystore-tags', '', 'com-easystore/com-easystore-tags', 'index.php?option=com_easystore&view=tags', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 88, 89, 0, '', 1, NULL, NULL),
(465, 'main', 'COM_EASYSTORE_ORDERS', 'com-easystore-orders', '', 'com-easystore/com-easystore-orders', 'index.php?option=com_easystore&view=orders', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 90, 91, 0, '', 1, NULL, NULL),
(466, 'main', 'COM_EASYSTORE_COUPONS', 'com-easystore-coupons', '', 'com-easystore/com-easystore-coupons', 'index.php?option=com_easystore&view=coupons', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 92, 93, 0, '', 1, NULL, NULL),
(467, 'main', 'COM_EASYSTORE_REVIEWS', 'com-easystore-reviews', '', 'com-easystore/com-easystore-reviews', 'index.php?option=com_easystore&view=reviews', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 94, 95, 0, '', 1, NULL, NULL),
(468, 'main', 'COM_EASYSTORE_ANALYTICS', 'com-easystore-analytics', '', 'com-easystore/com-easystore-analytics', 'index.php?option=com_easystore&view=analytics', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 96, 97, 0, '', 1, NULL, NULL),
(469, 'main', 'COM_EASYSTORE_CUSTOMERS', 'com-easystore-customers', '', 'com-easystore/com-easystore-customers', 'index.php?option=com_easystore&view=customers', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 98, 99, 0, '', 1, NULL, NULL),
(470, 'main', 'COM_EASYSTORE_SETTINGS', 'com-easystore-settings', '', 'com-easystore/com-easystore-settings', 'index.php?option=com_easystore&view=settings', 'component', 1, 458, 2, 10145, NULL, NULL, 0, 1, 'class:component', 0, '{}', 100, 101, 0, '', 1, NULL, NULL),
(471, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder&view=editor', 'component', 1, 1, 1, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 103, 116, 0, '', 1, NULL, NULL),
(472, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_PAGES', 'com-sppagebuilder-admin-menu-pages', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-pages', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component', 'component', 1, 471, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 104, 105, 0, '', 1, NULL, NULL),
(473, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_DYNAMIC_CONTENT', 'com-sppagebuilder-admin-menu-dynamic-content', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-dynamic-content', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component#/dynamic-content', 'component', 1, 471, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 106, 107, 0, '', 1, NULL, NULL),
(474, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_MEDIA', 'com-sppagebuilder-admin-menu-media', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-media', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component#/media-manager', 'component', 1, 471, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 108, 109, 0, '', 1, NULL, NULL),
(475, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_CATEGORIES', 'com-sppagebuilder-admin-menu-categories', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-categories', 'index.php?option=com_categories&extension=com_sppagebuilder', 'component', 1, 471, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 110, 111, 0, '', 1, NULL, NULL),
(476, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_EASYSTOE', 'com-sppagebuilder-admin-menu-easystoe', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-easystoe', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component#/editor/storefront', 'component', 1, 471, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 112, 113, 0, '', 1, NULL, NULL),
(477, 'main', 'COM_SPPAGEBUILDER_ADMIN_MENU_SETTINGS', 'com-sppagebuilder-admin-menu-settings', '', 'com-sppagebuilder/com-sppagebuilder-admin-menu-settings', 'index.php?option=com_sppagebuilder&view=editor&tmpl=component#/settings', 'component', 1, 471, 2, 10000, NULL, NULL, 0, 1, 'class:component', 0, '{}', 114, 115, 0, '', 1, NULL, NULL),
(478, 'main', 'COM_QSBUILDER', 'com-qsbuilder', '', 'com-qsbuilder', 'index.php?option=com_qsbuilder', 'component', 1, 1, 1, 10171, NULL, NULL, 0, 1, 'class:component', 0, '{}', 117, 120, 0, '', 1, NULL, NULL),
(479, 'main', 'Build Quick Start Pack', 'build-quick-start-pack', '', 'com-qsbuilder/build-quick-start-pack', 'index.php?option=com_qsbuilder&tmpl=component', 'component', 1, 478, 2, 10171, NULL, NULL, 0, 1, 'class:code', 0, '{}', 118, 119, 0, '', 1, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__menu_types`
--


DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE `#__menu_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__menu_types`
--


INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`, `ordering`) VALUES 
(1, 0, 'mainmenu', 'Main Menu', 'The main menu for the site', 0, 1),
(2, 75, 'company', 'Company', '', 0, 2),
(3, 76, 'quick-links', 'Quick Links', '', 0, 3);


-- --------------------------------------------------------

--
-- Table structure for table `#__modules`
--


DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE `#__modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ordering` int NOT NULL DEFAULT '0',
  `position` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint unsigned NOT NULL DEFAULT '1',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__modules`
--


INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES 
(2, 40, 'Login', '', '', 1, 'login', NULL, NULL, NULL, NULL, 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 41, 'Popular Articles', '', '', 3, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(4, 42, 'Recently Added Articles', '', '', 4, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(8, 43, 'Toolbar', '', '', 1, 'toolbar', NULL, NULL, NULL, NULL, 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 44, 'Notifications', '', '', 3, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 3, 1, '{\"context\":\"update_quickicon\",\"header_icon\":\"fas fa-sync\",\"show_global\":\"0\",\"show_checkin\":\"0\",\"show_cache\":\"0\",\"show_users\":\"0\",\"show_articles\":\"0\",\"show_categories\":\"0\",\"show_media\":\"0\",\"show_menuItems\":\"0\",\"show_modules\":\"0\",\"show_plugins\":\"0\",\"show_templates\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(10, 45, 'Logged-in Users', '', '', 2, 'cpanel', NULL, NULL, NULL, NULL, 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(12, 46, 'Admin Menu', '', '', 1, 'menu', NULL, NULL, NULL, NULL, 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 47, 'Admin Submenu', '', '', 1, 'submenu', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 48, 'User Status', '', '', 2, 'status', NULL, NULL, NULL, NULL, 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 49, 'Title', '', '', 1, 'title', NULL, NULL, NULL, NULL, 1, 'mod_title', 3, 1, '', 1, '*'),
(17, 51, 'Breadcrumbs', '', '', 1, 'breadcrumb', NULL, NULL, NULL, NULL, 1, 'mod_breadcrumbs', 1, 1, '{\"showHere\":0,\"showHome\":1,\"homeText\":\"\",\"showLast\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":0,\"cache_time\":0,\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(79, 52, 'Multilanguage status', '', '', 2, 'status', NULL, NULL, NULL, NULL, 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 53, 'Joomla Version', '', '', 1, 'status', NULL, NULL, NULL, NULL, 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(87, 55, 'Sample Data', '', '', 0, 'cpanel', NULL, NULL, NULL, NULL, 0, 'mod_sampledata', 6, 1, '{}', 1, '*'),
(96, 84, 'Joomla Module', 'Mega Menu', '<div><img src=\"images/gallery1-small.jpg\" alt=\"image\" /></div>', 1, '', NULL, NULL, NULL, NULL, 1, 'mod_custom', 1, 1, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(98, 88, 'Latest Articles', 'Mega Menu', '', 1, '', NULL, NULL, NULL, NULL, 1, 'mod_articles_latest', 1, 1, '{\"catid\":[\"8\"],\"count\":\"2\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(100, 0, 'Login Support', '', '', 1, 'sidebar', NULL, NULL, NULL, NULL, 1, 'mod_loginsupport', 1, 1, '{\"forum_url\":\"https://forum.joomla.org/\",\"documentation_url\":\"https://docs.joomla.org/\",\"news_url\":\"https://www.joomla.org/announcements.html\",\"automatic_title\":1,\"prepare_content\":1,\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 1, '*'),
(101, 0, 'System Dashboard', '', '', 1, 'cpanel-system', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"system\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(102, 0, 'Content Dashboard', '', '', 1, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"content\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"3\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(103, 0, 'Menus Dashboard', '', '', 1, 'cpanel-menus', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"menus\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(104, 0, 'Components Dashboard', '', '', 1, 'cpanel-components', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"components\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(105, 0, 'Users Dashboard', '', '', 1, 'cpanel-users', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"users\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\",\"style\":\"System-none\"}', 1, '*'),
(106, 0, 'Popular Articles', '', '', 3, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(107, 0, 'Recently Added Articles', '', '', 4, 'cpanel-content', NULL, NULL, NULL, NULL, 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(108, 0, 'Logged-in Users', '', '', 2, 'cpanel-users', NULL, NULL, NULL, NULL, 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\", \"bootstrap_size\":\"12\"}', 1, '*'),
(109, 0, 'Frontend Link', '', '', 5, 'status', NULL, NULL, NULL, NULL, 1, 'mod_frontend', 1, 1, '', 1, '*'),
(110, 0, 'Messages', '', '', 4, 'status', NULL, NULL, NULL, NULL, 1, 'mod_messages', 3, 1, '', 1, '*'),
(111, 0, 'Post Install Messages', '', '', 3, 'status', NULL, NULL, NULL, NULL, 1, 'mod_post_installation_messages', 3, 1, '', 1, '*'),
(112, 0, 'User Status', '', '', 6, 'status', NULL, NULL, NULL, NULL, 1, 'mod_user', 3, 1, '', 1, '*'),
(113, 0, 'Site', '', '', 1, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"site_quickicon\",\"header_icon\":\"fas fa-desktop\",\"show_users\":\"1\",\"show_articles\":\"1\",\"show_categories\":\"1\",\"show_media\":\"1\",\"show_menuItems\":\"1\",\"show_modules\":\"1\",\"show_plugins\":\"1\",\"show_templates\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(114, 0, 'System', '', '', 2, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"system_quickicon\",\"header_icon\":\"fas fa-wrench\",\"show_global\":\"1\",\"show_checkin\":\"1\",\"show_cache\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(115, 0, '3rd Party', '', '', 4, 'icon', NULL, NULL, NULL, NULL, 1, 'mod_quickicon', 1, 1, '{\"context\":\"mod_quickicon\",\"header_icon\":\"fas fa-boxes\",\"load_plugins\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"12\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(116, 0, 'Help Dashboard', '', '', 1, 'cpanel-help', NULL, NULL, NULL, NULL, 1, 'mod_submenu', 1, 0, '{\"menutype\":\"*\",\"preset\":\"help\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"style\":\"System-none\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(117, 0, 'Privacy Requests', '', '', 1, 'cpanel-privacy', NULL, NULL, NULL, NULL, 1, 'mod_privacy_dashboard', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(118, 0, 'Privacy Status', '', '', 1, 'cpanel-privacy', NULL, NULL, NULL, NULL, 1, 'mod_privacy_status', 1, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"style\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h2\",\"header_class\":\"\"}', 1, '*'),
(120, 0, 'Guided Tours', '', '', 1, 'status', NULL, NULL, NULL, NULL, 1, 'mod_guidedtours', 1, 1, '', 1, '*'),
(121, 117, 'Bottom Section', '', '', 1, 'bottom1', NULL, NULL, '2025-02-10 09:24:46', NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(122, 119, 'Footer Section', '', '', 1, 'footer', NULL, NULL, '2025-01-13 08:10:39', NULL, 1, 'mod_sppagebuilder', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(123, 122, 'MOD_EASYSTORE_CART_ICON', '', '', 2, 'header-right', NULL, NULL, '2025-01-13 09:35:08', NULL, 1, 'mod_easystore_cart_icon', 1, 0, '{\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(128, 183, 'Easystore Searach', '', NULL, 1, 'header-right', NULL, NULL, NULL, NULL, 1, 'mod_easystore_search', 1, 0, '{\"show_category\":1,\"show_search_button\":1,\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(129, 193, 'Copyright', '', NULL, 1, '', NULL, NULL, NULL, NULL, 1, 'mod_footer', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":1,\"cache_time\":900,\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*');


-- --------------------------------------------------------

--
-- Table structure for table `#__modules_menu`
--


DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE `#__modules_menu` (
  `moduleid` int NOT NULL DEFAULT '0',
  `menuid` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__modules_menu`
--


INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES 
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(17, 0),
(79, 0),
(86, 0),
(87, 0),
(96, 0),
(98, 0),
(100, 0),
(101, 0),
(102, 0),
(103, 0),
(104, 0),
(105, 0),
(106, 0),
(107, 0),
(108, 0),
(109, 0),
(110, 0),
(111, 0),
(112, 0),
(113, 0),
(114, 0),
(115, 0),
(116, 0),
(117, 0),
(118, 0),
(120, 0),
(121, 0),
(122, 0),
(123, 0),
(128, 0),
(129, 0);


-- --------------------------------------------------------

--
-- Table structure for table `#__schemas`
--


DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE `#__schemas` (
  `extension_id` int NOT NULL,
  `version_id` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__schemas`
--


INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES 
(10000, '6.1.0'),
(10145, '1.7.1');


-- --------------------------------------------------------

--
-- Table structure for table `#__tags`
--


DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE `#__tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__tags`
--


INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES 
(1, 0, 0, 29, 0, '', 'ROOT', 'root', '', '', 1, NULL, NULL, 1, '', '', '', '', 962, '2021-08-19 09:54:33', '', 962, '2021-08-19 09:54:33', '', '', 0, '*', 1, NULL, NULL),
(8, 1, 13, 14, 1, 'features', 'Features', 'features', '', '', 1, NULL, '2018-02-26 06:51:56', 1, '{}', '', '', '{}', 962, '2021-08-19 09:54:33', '', 0, '2021-08-19 09:54:33', '{}', '{}', 1, '*', 1, '2021-08-19 09:54:33', '2021-08-19 09:54:33'),
(9, 1, 15, 16, 1, 'speakers', 'Speakers', 'speakers', '', '', 1, NULL, NULL, 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2025-02-11 09:38:03', '', 962, '2025-02-11 09:38:03', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', 1, '*', 1, NULL, NULL),
(10, 1, 17, 18, 1, 'smartphone', 'Smartphone', 'smartphone', '', '', 1, NULL, NULL, 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2025-02-11 09:38:17', '', 962, '2025-02-11 09:38:17', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', 0, '*', 1, NULL, NULL),
(11, 1, 19, 20, 1, 'macbook', 'Macbook', 'macbook', '', '', 1, NULL, NULL, 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2025-02-11 09:38:34', '', 962, '2025-02-11 09:38:34', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', 0, '*', 1, NULL, NULL),
(12, 1, 21, 22, 1, 'gaming', 'Gaming', 'gaming', '', '', 1, NULL, NULL, 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2025-02-11 09:38:45', '', 962, '2025-02-11 09:38:45', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', 0, '*', 1, NULL, NULL),
(13, 1, 23, 24, 1, 'laptop', 'Laptop', 'laptop', '', '', 1, NULL, NULL, 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2025-02-11 09:39:00', '', 962, '2025-02-11 09:39:00', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', 0, '*', 1, NULL, NULL),
(14, 1, 25, 26, 1, 'tablet', 'Tablet', 'tablet', '', '', 1, NULL, NULL, 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2025-02-11 09:39:11', '', 962, '2025-02-11 09:39:11', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', 0, '*', 1, NULL, NULL),
(15, 1, 27, 28, 1, 'headphone', 'Headphone', 'headphone', '', '', 1, NULL, NULL, 1, '{\"tag_layout\":\"\",\"tag_link_class\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2025-02-11 09:39:23', '', 962, '2025-02-11 09:39:23', '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{}', 0, '*', 1, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__template_overrides`
--


DROP TABLE IF EXISTS `#__template_overrides`;
CREATE TABLE `#__template_overrides` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hash_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension_id` int DEFAULT '0',
  `state` tinyint NOT NULL DEFAULT '0',
  `action` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__template_overrides`
--


INSERT INTO `#__template_overrides` (`id`, `template`, `hash_id`, `extension_id`, `state`, `action`, `client_id`, `created_date`, `modified_date`) VALUES 
(143, 'megadeal_ii', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF91cmwucGhw', 10160, 1, 'Joomla Update', 0, '2025-02-19 10:18:04', '2025-10-24 11:28:15'),
(144, 'megadeal_ii', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9jb21wb25lbnQucGhw', 10160, 1, 'Joomla Update', 0, '2025-02-19 10:18:04', '2025-10-24 11:28:15'),
(145, 'megadeal_ii', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9oZWFkaW5nLnBocA==', 10160, 1, 'Joomla Update', 0, '2025-02-19 10:18:04', '2025-10-24 11:28:15'),
(146, 'megadeal_ii', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdF9zZXBhcmF0b3IucGhw', 10160, 1, 'Joomla Update', 0, '2025-02-19 10:18:04', '2025-10-24 11:28:15'),
(147, 'megadeal_ii', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0LnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(148, 'megadeal_ii', 'L2h0bWwvY29tX2NvbnRhY3QvY29udGFjdC9kZWZhdWx0X2FkZHJlc3MucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(149, 'megadeal_ii', 'L2h0bWwvY29tX2NvbnRlbnQvY2F0ZWdvcnkvZGVmYXVsdF9hcnRpY2xlcy5waHA=', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(150, 'megadeal_ii', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0LnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(151, 'megadeal_ii', 'L2h0bWwvY29tX2NvbnRlbnQvYXJjaGl2ZS9kZWZhdWx0X2l0ZW1zLnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(152, 'megadeal_ii', 'L2h0bWwvY29tX2NvbnRlbnQvZm9ybS9lZGl0LnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 11:28:15'),
(153, 'megadeal_ii', 'L2h0bWwvY29tX2ZpbmRlci9zZWFyY2gvZGVmYXVsdF9mb3JtLnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(154, 'megadeal_ii', 'L2h0bWwvY29tX3RhZ3MvdGFncy9kZWZhdWx0X2l0ZW1zLnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(155, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHQucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(156, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9naW4ucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 11:28:15'),
(157, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL2xvZ2luL2RlZmF1bHRfbG9nb3V0LnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(158, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL3Byb2ZpbGUvZWRpdC5waHA=', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 11:28:15'),
(159, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL3JlZ2lzdHJhdGlvbi9kZWZhdWx0LnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 11:28:15'),
(160, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL3JlbWluZC9kZWZhdWx0LnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 11:28:15'),
(161, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL3Jlc2V0L2NvbXBsZXRlLnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(162, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL3Jlc2V0L2NvbmZpcm0ucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 11:28:15'),
(163, 'megadeal_ii', 'L2h0bWwvY29tX3VzZXJzL3Jlc2V0L2RlZmF1bHQucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 11:28:15'),
(164, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvY29udGVudC9pbmZvX2Jsb2NrL2F1dGhvci5waHA=', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(165, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdC9nbG9iYWwucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(166, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZWRpdC9wYXJhbXMucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(167, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC90ZXh0LnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(168, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC91cmwucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(169, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9jYWxlbmRhci5waHA=', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(170, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9tZWRpYS5waHA=', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(171, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9tZXRlci5waHA=', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(172, 'megadeal_ii', 'L2h0bWwvbW9kX2JyZWFkY3J1bWJzL2RlZmF1bHQucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(173, 'megadeal_ii', 'L2h0bWwvbW9kX2xvZ2luL2RlZmF1bHQucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(174, 'megadeal_ii', 'L2h0bWwvcGxnX2NvbnRlbnRfdm90ZS92b3RlLnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(175, 'megadeal_ii', 'L2h0bWwvcGxnX2NvbnRlbnRfdm90ZS9yYXRpbmcucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 10:03:38', '2025-10-24 10:03:38'),
(176, 'megadeal_ii', 'L2h0bWwvY29tX2NvbnRlbnQvYXJ0aWNsZS9kZWZhdWx0X2xpbmtzLnBocA==', 10160, 1, 'Joomla Update', 0, '2025-10-24 11:28:15', '2025-10-24 11:28:15'),
(177, 'megadeal_ii', 'L2h0bWwvbGF5b3V0cy9qb29tbGEvZm9ybS9maWVsZC9jb2xvci9zaW1wbGUucGhw', 10160, 1, 'Joomla Update', 0, '2025-10-24 11:28:15', '2025-10-24 11:28:15'),
(178, 'megadeal_ii', 'L2h0bWwvbW9kX21lbnUvZGVmYXVsdC5waHA=', 10160, 1, 'Joomla Update', 0, '2025-10-24 11:28:15', '2025-10-24 11:28:15');


-- --------------------------------------------------------

--
-- Table structure for table `#__template_styles`
--


DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE `#__template_styles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint unsigned NOT NULL DEFAULT '0',
  `home` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `inheritable` tinyint NOT NULL DEFAULT '0',
  `parent` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__template_styles`
--


INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`, `inheritable`, `parent`) VALUES 
(10, 'atum', 1, '1', 'Atum - Default', '{\"hue\": \"hsl(214, 63%, 20%)\", \"bg-light\": \"#f0f4fb\", \"loginLogo\": \"\", \"text-dark\": \"#495057\", \"link-color\": \"#2a69b8\", \"monochrome\": \"0\", \"text-light\": \"#ffffff\", \"colorScheme\": \"os\", \"loginLogoAlt\": \"\", \"special-color\": \"#001b4c\", \"logoBrandLarge\": \"\", \"logoBrandSmall\": \"\", \"logoBrandLargeAlt\": \"\", \"logoBrandSmallAlt\": \"\"}', 1, ''),
(11, 'cassiopeia', 0, '0', 'Cassiopeia - Default', '{}', 1, ''),
(12, 'megadeal_ii', 0, '1', 'Megadeal_ii - Default', '{\"logo_type\":\"image\",\"logo_image\":\"\",\"retina_logo\":\"images\\/gallery1.jpg\",\"mobile_logo\":\"\",\"logo_alt\":\"\",\"logo_custom_link\":\"\",\"logo_height\":\"36px\",\"logo_height_sm\":\"\",\"logo_height_xs\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"favicon\":\"\",\"predefined_header\":\"1\",\"header_style\":\"style-1\",\"header_height\":\"100px\",\"header_height_sm\":\"80px\",\"header_height_xs\":\"180px\",\"enable_login\":\"1\",\"sticky_header\":\"1\",\"sticky_offset\":\"\",\"loader_type\":\"circle\",\"container_max_width\":\"\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_position\":\"0 0\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"\\u00a9 {year} Your Company. Designed By JoomShaper\",\"goto_top\":\"1\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"after\",\"facebook\":\"#\",\"twitter\":\"#\",\"pinterest\":\"\",\"linkedin\":\"#\",\"dribbble\":\"\",\"instagram\":\"\",\"behance\":\"\",\"youtube\":\"\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contactinfo\":\"1\",\"contact_position\":\"top2\",\"contact_load_pos\":\"default\",\"contact_phone\":\"+228 872 4444\",\"contact_mobile\":\"+88 00 111 222 33\",\"contact_email\":\"info@joomshaper.com\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"2025-01-16 00:00:00\",\"comingsoon_social_icons\":\"1\",\"comingsoon_title_status\":\"1\",\"comingsoon_content_status\":\"1\",\"comingsoon_countdown\":\"1\",\"comingsoon_logo\":\"images\\/easystore\\/store-logo\\/logo.png\",\"comingsoon_bg_image\":\"\",\"error_logo\":\"\",\"error_bg\":\"\",\"presets-data\":\"{\\\"preset1\\\":{\\\"label\\\":\\\"Preset 1\\\",\\\"default\\\":\\\"#f54f0c\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#333333\\\",\\\"bg_color\\\":\\\"#e9eaed\\\",\\\"link_color\\\":\\\"#f54f0c\\\",\\\"link_hover_color\\\":\\\"#dc470a\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#f2f2f4\\\",\\\"topbar_text_color\\\":\\\"#6e6e6e\\\",\\\"logo_text_color\\\":\\\"#f54f0c\\\",\\\"menu_text_color\\\":\\\"#6e6e6e\\\",\\\"menu_text_hover_color\\\":\\\"#f54f0c\\\",\\\"menu_text_active_color\\\":\\\"#f54f0c\\\",\\\"menu_dropdown_bg_color\\\":\\\"#ffffff\\\",\\\"menu_dropdown_text_color\\\":\\\"#777777\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f54f0c\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f54f0c\\\",\\\"footer_bg_color\\\":\\\"#121B23\\\",\\\"footer_text_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_hover_color\\\":\\\"#ffffff\\\"}},\\\"preset2\\\":{\\\"label\\\":\\\"Preset 2\\\",\\\"default\\\":\\\"#0C1FF5\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#333333\\\",\\\"bg_color\\\":\\\"#e9eaed\\\",\\\"link_color\\\":\\\"#0C1FF5\\\",\\\"link_hover_color\\\":\\\"#0a1bdc\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#f2f2f4\\\",\\\"topbar_text_color\\\":\\\"#6e6e6e\\\",\\\"logo_text_color\\\":\\\"#0C1FF5\\\",\\\"menu_text_color\\\":\\\"#6e6e6e\\\",\\\"menu_text_hover_color\\\":\\\"#0C1FF5\\\",\\\"menu_text_active_color\\\":\\\"#0C1FF5\\\",\\\"menu_dropdown_bg_color\\\":\\\"#ffffff\\\",\\\"menu_dropdown_text_color\\\":\\\"#777777\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#0C1FF5\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#0C1FF5\\\",\\\"footer_bg_color\\\":\\\"#121B23\\\",\\\"footer_text_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_hover_color\\\":\\\"#ffffff\\\"}},\\\"preset3\\\":{\\\"label\\\":\\\"Preset 3\\\",\\\"default\\\":\\\"#840CF5\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#333333\\\",\\\"bg_color\\\":\\\"#e9eaed\\\",\\\"link_color\\\":\\\"#840CF5\\\",\\\"link_hover_color\\\":\\\"#760adc\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#f2f2f4\\\",\\\"topbar_text_color\\\":\\\"#6e6e6e\\\",\\\"logo_text_color\\\":\\\"#840CF5\\\",\\\"menu_text_color\\\":\\\"#6e6e6e\\\",\\\"menu_text_hover_color\\\":\\\"#840CF5\\\",\\\"menu_text_active_color\\\":\\\"#840CF5\\\",\\\"menu_dropdown_bg_color\\\":\\\"#ffffff\\\",\\\"menu_dropdown_text_color\\\":\\\"#777777\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#840CF5\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#840CF5\\\",\\\"footer_bg_color\\\":\\\"#121B23\\\",\\\"footer_text_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_hover_color\\\":\\\"#ffffff\\\"}},\\\"preset4\\\":{\\\"label\\\":\\\"Preset 4\\\",\\\"default\\\":\\\"#368854\\\",\\\"description\\\":\\\"\\\",\\\"data\\\":{\\\"text_color\\\":\\\"#333333\\\",\\\"bg_color\\\":\\\"#e9eaed\\\",\\\"link_color\\\":\\\"#368854\\\",\\\"link_hover_color\\\":\\\"#307a4b\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"topbar_bg_color\\\":\\\"#f2f2f4\\\",\\\"topbar_text_color\\\":\\\"#6e6e6e\\\",\\\"logo_text_color\\\":\\\"#368854\\\",\\\"menu_text_color\\\":\\\"#6e6e6e\\\",\\\"menu_text_hover_color\\\":\\\"#368854\\\",\\\"menu_text_active_color\\\":\\\"#368854\\\",\\\"menu_dropdown_bg_color\\\":\\\"#ffffff\\\",\\\"menu_dropdown_text_color\\\":\\\"#777777\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#368854\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#368854\\\",\\\"footer_bg_color\\\":\\\"#121B23\\\",\\\"footer_text_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_color\\\":\\\"#b3b3b3\\\",\\\"footer_link_hover_color\\\":\\\"#ffffff\\\"}}}\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#ffffff\\\",\\\"footer_link_color\\\":\\\"#b3b3b3\\\",\\\"footer_text_color\\\":\\\"#b3b3b3\\\",\\\"footer_bg_color\\\":\\\"#121B23\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#f54f0c\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#f54f0c\\\",\\\"menu_dropdown_text_color\\\":\\\"#777777\\\",\\\"menu_dropdown_bg_color\\\":\\\"#ffffff\\\",\\\"menu_text_active_color\\\":\\\"#f54f0c\\\",\\\"menu_text_hover_color\\\":\\\"#f54f0c\\\",\\\"menu_text_color\\\":\\\"#6e6e6e\\\",\\\"logo_text_color\\\":\\\"#f54f0c\\\",\\\"topbar_text_color\\\":\\\"#6e6e6e\\\",\\\"topbar_bg_color\\\":\\\"#f2f2f4\\\",\\\"header_bg_color\\\":\\\"#ffffff\\\",\\\"link_hover_color\\\":\\\"#dc470a\\\",\\\"link_color\\\":\\\"#f54f0c\\\",\\\"bg_color\\\":\\\"#e9eaed\\\",\\\"text_color\\\":\\\"#333333\\\",\\\"preset\\\":\\\"preset1\\\"}\",\"topbar_bg_color\":\"#333333\",\"topbar_text_color\":\"#aaaaaa\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#0345bf\",\"menu_text_color\":\"#252525\",\"menu_text_hover_color\":\"#0345bf\",\"menu_text_active_color\":\"#0345bf\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#252525\",\"menu_dropdown_text_hover_color\":\"#0345bf\",\"menu_dropdown_text_active_color\":\"#0345bf\",\"offcanvas_menu_icon_color\":\"#000000\",\"offcanvas_menu_bg_color\":\"#ffffff\",\"offcanvas_menu_items_and_items_color\":\"#252525\",\"offcanvas_menu_active_menu_item_color\":\"#0345bf\",\"text_color\":\"#252525\",\"bg_color\":\"#ffffff\",\"link_color\":\"#0345bf\",\"link_hover_color\":\"#044cd0\",\"footer_bg_color\":\"#171717\",\"footer_text_color\":\"#ffffff\",\"footer_link_color\":\"#a2a2a2\",\"footer_link_hover_color\":\"#ffffff\",\"name\":\"\",\"custom_class\":\"\",\"padding\":\"\",\"margin\":\"\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+8\\\",\\\"settings\\\":{\\\"name\\\":\\\"topbar\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"name\\\":\\\"none\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":8,\\\"column_type\\\":0,\\\"name\\\":\\\"none\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"Page Title\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":12,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"title\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"Main Body\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"left\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"column_type\\\":1}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":4,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"right\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"Bottom\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"bottom1\\\",\\\"custom_class\\\":\\\"\\\",\\\"sm_col\\\":\\\"col-sm-6\\\",\\\"xs_col\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"grid_size\\\":12,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"name\\\":\\\"Footer\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"footer\\\",\\\"sticky_position\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"xxl_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"lg_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_ex_large_desktop\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":12,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"240px\",\"menu_animation\":\"menu-animation-fade-down\",\"offcanvas_position\":\"right\",\"offcanvas_style\":\"2-LeftBordered\",\"offcanvas_menu\":\"mainmenu\",\"offcanvas_max_level\":\"0\",\"offcanvas_enable_search\":\"1\",\"offcanvas_enable_login\":\"1\",\"offcanvas_enable_social\":\"1\",\"offcanvas_enable_contact\":\"1\",\"enable_body_font\":\"1\",\"hu-webfont-size-field\":\"\",\"hu-webfont-size-field-sm\":\"\",\"hu-webfont-size-field-xs\":\"\",\"hu-font-letter-spacing-input\":\"\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"16px\\\",\\\"fontSize_sm\\\":\\\"14px\\\",\\\"fontSize_xs\\\":\\\"13px\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.56\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"65px\\\",\\\"fontSize_sm\\\":\\\"52px\\\",\\\"fontSize_xs\\\":\\\"42px\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontSubset\\\":\\\"devanagari\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.2\\\",\\\"fontLetterSpacing\\\":\\\"0px\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"43px\\\",\\\"fontSize_sm\\\":\\\"30px\\\",\\\"fontSize_xs\\\":\\\"28px\\\",\\\"fontWeight\\\":\\\"500\\\",\\\"fontSubset\\\":\\\"devanagari\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.2\\\",\\\"fontLetterSpacing\\\":\\\"0px\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"28px\\\",\\\"fontSize_sm\\\":\\\"24px\\\",\\\"fontSize_xs\\\":\\\"20px\\\",\\\"fontWeight\\\":\\\"500\\\",\\\"fontSubset\\\":\\\"devanagari\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.2\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"18px\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"16px\\\",\\\"fontWeight\\\":\\\"400\\\",\\\"fontSubset\\\":\\\"devanagari\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"1.2\\\",\\\"fontLetterSpacing\\\":\\\"-1px\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"latin\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"enable_custom_font\":\"1\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Arial\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontSubset\\\":\\\"\\\",\\\"fontColor\\\":\\\"\\\",\\\"fontLineHeight\\\":\\\"\\\",\\\"fontLetterSpacing\\\":\\\"\\\",\\\"textDecoration\\\":\\\"none\\\",\\\"textAlign\\\":\\\"\\\"}\",\"custom_font_selectors\":\"\",\"image_thumbnail_size\":\"515x290\",\"image_small_size\":\"180x200\",\"image_medium_size\":\"180x200\",\"image_large_size\":\"1100x620\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"large\",\"leading_blog_list_image\":\"large\",\"blog_list_type\":\"default\",\"blog_details_image\":\"large\",\"social_share\":\"1\",\"social_share_lists\":[\"facebook\",\"twitter\",\"linkedin\"],\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"reading_timeline_bg\":\"#0345bf\",\"reading_timeline_height\":\"5px\",\"reading_timeline_position\":\"top\",\"related_article_title\":\"Related Articles\",\"related_article_column\":\"3\",\"related_article_limit\":\"3\",\"related_article_view_type\":\"thumb\",\"comment\":\"disabled\",\"comment_disqus_subdomain\":\"\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\",\"before_head\":\"\",\"after_body\":\"\",\"before_body\":\"\",\"custom_css\":\"\",\"custom_js\":\"\",\"exclude_js\":\"\",\"scssoption\":\"1\",\"enable_fontawesome\":\"1\",\"gfont_api\":\"\",\"ga_code\":\"\",\"ga_tracking_method\":\"gst\",\"id\":\"12\",\"template\":\"megadeal_ii\",\"client_id\":\"0\",\"home\":\"1\",\"title\":\"Megadeal_ii - Default\"}', 0, ''),
(13, 'cassiopeia_extended', 0, '0', 'Cassiopeia Extended - Default', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"systemFontBody\":\"\",\"systemFontHeading\":\"\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":\"0\",\"backTop\":\"0\",\"colorSettings\":\"0\",\"headerbg\":\"rgb(193, 205, 207)\",\"headercolor\":\"rgb(23, 23, 23)\",\"bodybg\":\"rgb(254, 254, 254)\",\"bodycolor\":\"rgb(23, 23, 23)\",\"linkcolor\":\"rgb(29, 121, 137)\",\"linkcolorh\":\"rgb(14, 59, 67)\",\"btnbg\":\"rgb(206, 60, 55)\",\"btnbgh\":\"rgb(131, 35, 32)\",\"btncolor\":\"rgb(254, 254, 254)\",\"btncolorh\":\"rgb(254, 254, 254)\",\"footerbg\":\"rgb(29, 121, 137)\",\"footercolor\":\"rgb(254, 254, 254)\",\"fontSettings\":\"0\",\"bodysize\":\"1\",\"h1size\":\"2\",\"h2size\":\"1.7\",\"h3size\":\"1.5\"}', 0, 'cassiopeia');


-- --------------------------------------------------------

--
-- Table structure for table `#__updates`
--


DROP TABLE IF EXISTS `#__updates`;
CREATE TABLE `#__updates` (
  `update_id` int NOT NULL AUTO_INCREMENT,
  `update_site_id` int DEFAULT '0',
  `extension_id` int DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint DEFAULT '0',
  `version` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `extra_query` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';


--
-- Dumping data for table `#__updates`
--


INSERT INTO `#__updates` (`update_id`, `update_site_id`, `extension_id`, `name`, `description`, `element`, `type`, `folder`, `client_id`, `version`, `data`, `detailsurl`, `infourl`, `changelogurl`, `extra_query`) VALUES 
(1, 2, 0, 'Catalan', '', 'pkg_ca-ES', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/ca-ES_details.xml', '', '', ''),
(2, 2, 0, 'Danish', '', 'pkg_da-DK', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/da-DK_details.xml', '', '', ''),
(3, 2, 0, 'Dutch', '', 'pkg_nl-NL', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/nl-NL_details.xml', '', '', ''),
(4, 2, 0, 'Finnish', '', 'pkg_fi-FI', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/fi-FI_details.xml', '', '', ''),
(5, 2, 0, 'Flemish', '', 'pkg_nl-BE', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/nl-BE_details.xml', '', '', ''),
(6, 2, 0, 'French', '', 'pkg_fr-FR', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/fr-FR_details.xml', '', '', ''),
(7, 2, 0, 'Georgian', '', 'pkg_ka-GE', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/ka-GE_details.xml', '', '', ''),
(8, 2, 0, 'German', '', 'pkg_de-DE', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/de-DE_details.xml', '', '', ''),
(9, 2, 0, 'German, Austria', '', 'pkg_de-AT', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/de-AT_details.xml', '', '', ''),
(10, 2, 0, 'German, Liechtenstein', '', 'pkg_de-LI', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/de-LI_details.xml', '', '', ''),
(11, 2, 0, 'German, Luxembourg', '', 'pkg_de-LU', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/de-LU_details.xml', '', '', ''),
(12, 2, 0, 'German, Switzerland', '', 'pkg_de-CH', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/de-CH_details.xml', '', '', ''),
(13, 2, 0, 'Greek', '', 'pkg_el-GR', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/el-GR_details.xml', '', '', ''),
(14, 2, 0, 'Italian', '', 'pkg_it-IT', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/it-IT_details.xml', '', '', ''),
(15, 2, 0, 'Japanese', '', 'pkg_ja-JP', 'package', '', 0, '6.0.0.2', '', 'https://update.joomla.org/language/details6/ja-JP_details.xml', '', '', ''),
(16, 2, 0, 'Persian Farsi', '', 'pkg_fa-IR', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/fa-IR_details.xml', '', '', ''),
(17, 2, 0, 'Polish', '', 'pkg_pl-PL', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/pl-PL_details.xml', '', '', ''),
(18, 2, 0, 'Slovenian', '', 'pkg_sl-SI', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/sl-SI_details.xml', '', '', ''),
(19, 2, 0, 'Spanish', '', 'pkg_es-ES', 'package', '', 0, '6.0.0.2', '', 'https://update.joomla.org/language/details6/es-ES_details.xml', '', '', ''),
(20, 2, 0, 'Swedish', '', 'pkg_sv-SE', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/sv-SE_details.xml', '', '', ''),
(21, 2, 0, 'Tamil, India', '', 'pkg_ta-IN', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/ta-IN_details.xml', '', '', ''),
(22, 2, 0, 'Thai', '', 'pkg_th-TH', 'package', '', 0, '6.0.0.2', '', 'https://update.joomla.org/language/details6/th-TH_details.xml', '', '', ''),
(23, 2, 0, 'Turkish', '', 'pkg_tr-TR', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/tr-TR_details.xml', '', '', ''),
(24, 2, 0, 'Ukrainian', '', 'pkg_uk-UA', 'package', '', 0, '6.0.0.1', '', 'https://update.joomla.org/language/details6/uk-UA_details.xml', '', '', '');


-- --------------------------------------------------------

--
-- Table structure for table `#__update_sites`
--


DROP TABLE IF EXISTS `#__update_sites`;
CREATE TABLE `#__update_sites` (
  `update_site_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int DEFAULT '0',
  `last_check_timestamp` bigint DEFAULT '0',
  `extra_query` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';


--
-- Dumping data for table `#__update_sites`
--


INSERT INTO `#__update_sites` (`update_site_id`, `name`, `type`, `location`, `enabled`, `last_check_timestamp`, `extra_query`, `checked_out`, `checked_out_time`) VALUES 
(2, 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_6.xml', 1, 1761309260, '', NULL, NULL),
(3, 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', 1, 1761309260, '', NULL, NULL),
(51, 'Joomla! Core', 'tuf', 'https://update.joomla.org/cms/', 1, 1761309260, '', NULL, NULL),
(199, 'System - Helix Ultimate Framework', 'extension', 'https://www.joomshaper.com/updates/plg-system-helixultimate.xml', 1, 1761309261, '', NULL, NULL),
(200, 'Paypal - EasyStore Payment Plugin', 'extension', 'https://www.joomshaper.com/updates/easystore-paypal.xml', 1, 1761309261, '', NULL, NULL),
(201, 'Bank Transfer - EasyStore Manual Payment Plugin', 'extension', 'https://www.joomshaper.com/updates/easystore-banktransfer.xml', 1, 1761309262, '', NULL, NULL),
(202, 'megadeal_ii', 'extension', 'https://www.joomshaper.com/updates/megadeal_ii.xml', 1, 1761309262, '', NULL, NULL),
(203, 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro-next.xml', 1, 1761309263, '', NULL, NULL),
(204, 'EasyStore', 'extension', 'https://www.joomshaper.com/updates/easystore.xml', 1, 1761309263, 'joomshaper_email=sreema1392%40gmail.com&amp;joomshaper_license_key=f5e995e4b3137e713fd6e3d31ec661e0&amp;product=easystore', NULL, NULL),
(205, 'Search Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/search/main/manifest.xml', 1, 1761309263, '', NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__update_sites_extensions`
--


DROP TABLE IF EXISTS `#__update_sites_extensions`;
CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int NOT NULL DEFAULT '0',
  `extension_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';


--
-- Dumping data for table `#__update_sites_extensions`
--


INSERT INTO `#__update_sites_extensions` (`update_site_id`, `extension_id`) VALUES 
(2, 802),
(3, 28),
(51, 227),
(199, 10004),
(200, 10147),
(201, 10157),
(202, 10160),
(203, 10000),
(204, 10145),
(205, 10067);


-- --------------------------------------------------------

--
-- Table structure for table `#__viewlevels`
--


DROP TABLE IF EXISTS `#__viewlevels`;
CREATE TABLE `#__viewlevels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__viewlevels`
--


INSERT INTO `#__viewlevels` (`id`, `title`, `ordering`, `rules`) VALUES 
(1, 'Public', 0, '[1]'),
(2, 'Registered', 2, '[6,2,8]'),
(3, 'Special', 3, '[6,3,8]'),
(5, 'Guest', 1, '[9]'),
(6, 'Super Users', 4, '[8]');


-- --------------------------------------------------------

--
-- Table structure for table `#__workflows`
--


DROP TABLE IF EXISTS `#__workflows`;
CREATE TABLE `#__workflows` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_extension` (`extension`),
  KEY `idx_default` (`default`),
  KEY `idx_created` (`created`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_modified` (`modified`),
  KEY `idx_modified_by` (`modified_by`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflows`
--


INSERT INTO `#__workflows` (`id`, `asset_id`, `published`, `title`, `description`, `extension`, `default`, `ordering`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`) VALUES 
(1, 56, 1, 'COM_WORKFLOW_BASIC_WORKFLOW', '', 'com_content.article', 1, 1, '2021-08-27 11:24:00', 962, '2021-08-27 11:24:00', 962, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__workflow_associations`
--


DROP TABLE IF EXISTS `#__workflow_associations`;
CREATE TABLE `#__workflow_associations` (
  `item_id` int NOT NULL DEFAULT '0' COMMENT 'Extension table id value',
  `stage_id` int NOT NULL COMMENT 'Foreign Key to #__workflow_stages.id',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`item_id`,`extension`),
  KEY `idx_item_stage_extension` (`item_id`,`stage_id`,`extension`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_stage_id` (`stage_id`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflow_associations`
--


INSERT INTO `#__workflow_associations` (`item_id`, `stage_id`, `extension`) VALUES 
(10, 1, 'com_content.article'),
(11, 1, 'com_content.article'),
(12, 1, 'com_content.article'),
(13, 1, 'com_content.article'),
(14, 1, 'com_content.article'),
(15, 1, 'com_content.article'),
(16, 1, 'com_content.article'),
(17, 1, 'com_content.article'),
(18, 1, 'com_content.article'),
(19, 1, 'com_content.article'),
(20, 1, 'com_content.article'),
(21, 1, 'com_content.article'),
(22, 1, 'com_content.article'),
(23, 1, 'com_content.article'),
(24, 1, 'com_content.article');


-- --------------------------------------------------------

--
-- Table structure for table `#__workflow_stages`
--


DROP TABLE IF EXISTS `#__workflow_stages`;
CREATE TABLE `#__workflow_stages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `default` tinyint NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflow_stages`
--


INSERT INTO `#__workflow_stages` (`id`, `asset_id`, `ordering`, `workflow_id`, `published`, `title`, `description`, `default`, `checked_out_time`, `checked_out`) VALUES 
(1, 57, 1, 1, 1, 'COM_WORKFLOW_BASIC_STAGE', '', 1, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__workflow_transitions`
--


DROP TABLE IF EXISTS `#__workflow_transitions`;
CREATE TABLE `#__workflow_transitions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `workflow_id` int NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_stage_id` int NOT NULL,
  `to_stage_id` int NOT NULL,
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__workflow_transitions`
--


INSERT INTO `#__workflow_transitions` (`id`, `asset_id`, `ordering`, `workflow_id`, `published`, `title`, `description`, `from_stage_id`, `to_stage_id`, `options`, `checked_out_time`, `checked_out`) VALUES 
(1, 58, 1, 1, 1, 'UNPUBLISH', '', -1, 1, '{\"publishing\":\"0\"}', NULL, NULL),
(2, 59, 2, 1, 1, 'PUBLISH', '', -1, 1, '{\"publishing\":\"1\"}', NULL, NULL),
(3, 60, 3, 1, 1, 'TRASH', '', -1, 1, '{\"publishing\":\"-2\"}', NULL, NULL),
(4, 61, 4, 1, 1, 'ARCHIVE', '', -1, 1, '{\"publishing\":\"2\"}', NULL, NULL),
(5, 62, 5, 1, 1, 'FEATURE', '', -1, 1, '{\"featuring\":\"1\"}', NULL, NULL),
(6, 63, 6, 1, 1, 'UNFEATURE', '', -1, 1, '{\"featuring\":\"0\"}', NULL, NULL),
(7, 64, 7, 1, 1, 'PUBLISH_AND_FEATURE', '', -1, 1, '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--


DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` int NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--


DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__categories`
--


INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES 
(1, 0, 0, 0, 13, 0, '', 'system', 'ROOT', 'root', '', '', 1, NULL, NULL, 1, '{}', '', '', '{}', 962, '2021-08-19 09:54:33', 962, '2021-08-19 09:54:33', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2021-08-19 09:54:33', 962, '2021-08-19 09:54:33', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2021-08-19 09:54:33', 962, '2021-08-19 09:54:33', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2021-08-19 09:54:33', 962, '2021-08-19 09:54:33', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2021-08-19 09:54:33', 962, '2021-08-19 09:54:33', 0, '*', 1),
(7, 32, 1, 9, 10, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2021-08-19 09:54:33', 962, '2021-08-19 09:54:33', 0, '*', 1),
(8, 69, 1, 11, 12, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 962, '2021-08-19 09:54:33', 0, '2021-08-19 09:54:33', 0, '*', 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--


DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE `#__content_types` (
  `type_id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__content_types`
--


INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES 
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\": {\"note\": \"note\", \"asset_id\": \"asset_id\", \"core_body\": \"introtext\", \"core_hits\": \"hits\", \"core_urls\": \"urls\", \"core_alias\": \"alias\", \"core_catid\": \"catid\", \"core_state\": \"state\", \"core_title\": \"title\", \"core_access\": \"access\", \"core_images\": \"images\", \"core_params\": \"attribs\", \"core_metakey\": \"metakey\", \"core_version\": \"version\", \"core_featured\": \"featured\", \"core_language\": \"language\", \"core_metadata\": \"metadata\", \"core_metadesc\": \"metadesc\", \"core_ordering\": \"ordering\", \"core_publish_up\": \"publish_up\", \"core_xreference\": \"xreference\", \"core_created_time\": \"created\", \"core_publish_down\": \"publish_down\", \"core_modified_time\": \"modified\", \"core_content_item_id\": \"id\", \"core_created_user_id\": \"created_by\", \"core_created_by_alias\": \"created_by_alias\"}, \"special\": {\"fulltext\": \"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\": \"administrator/components/com_content/models/forms/article.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\"], \"convertToInt\": [\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\": [{\"targetTable\": \"#__categories\", \"sourceColumn\": \"catid\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"created_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"]}'),
(2, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\": \"administrator/components/com_contact/models/forms/contact.xml\", \"hideFields\": [\"default_con\", \"checked_out\", \"checked_out_time\", \"version\", \"xreference\"], \"convertToInt\": [\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"catid\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"]}'),
(3, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\": \"administrator/components/com_newsfeeds/models/forms/newsfeed.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\"], \"convertToInt\": [\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\": [{\"targetTable\": \"#__categories\", \"sourceColumn\": \"catid\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"created_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_by\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"]}'),
(4, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
(5, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
(6, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
(7, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
(8, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(9, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(10, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"asset_id\", \"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
(11, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(12, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(13, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\": \"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\": [\"checked_out\", \"checked_out_time\", \"version\", \"lft\", \"rgt\", \"level\", \"path\", \"extension\"], \"convertToInt\": [\"publish_up\", \"publish_down\"], \"displayLookup\": [{\"targetTable\": \"#__users\", \"sourceColumn\": \"created_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__viewlevels\", \"sourceColumn\": \"access\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__users\", \"sourceColumn\": \"modified_user_id\", \"targetColumn\": \"id\", \"displayColumn\": \"name\"}, {\"targetTable\": \"#__categories\", \"sourceColumn\": \"parent_id\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}, {\"targetTable\": \"#__tags\", \"sourceColumn\": \"tags\", \"targetColumn\": \"id\", \"displayColumn\": \"title\"}], \"ignoreChanges\": [\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"]}'),
(14, 'SP Easy Image Gallery Category', 'com_speasyimagegallery.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');


-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--


DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';


--
-- Dumping data for table `#__contentitem_tag_map`
--


INSERT INTO `#__contentitem_tag_map` (`type_alias`, `core_content_id`, `content_item_id`, `tag_id`, `tag_date`, `type_id`) VALUES 
('com_content.article', 8, 10, 13, '2025-02-17 23:59:36', 1),
('com_content.article', 9, 11, 12, '2025-02-17 23:59:26', 1),
('com_content.article', 7, 12, 14, '2025-02-17 23:59:19', 1),
('com_content.article', 6, 13, 13, '2025-02-17 23:59:11', 1),
('com_content.article', 5, 14, 12, '2025-02-17 23:59:04', 1),
('com_content.article', 4, 15, 11, '2025-02-17 23:58:56', 1),
('com_content.article', 3, 16, 10, '2025-02-17 23:58:51', 1),
('com_content.article', 2, 17, 9, '2025-02-17 23:58:22', 1),
('com_content.article', 1, 18, 8, '2025-02-17 23:56:44', 1),
('com_content.article', 10, 19, 14, '2025-02-17 23:58:06', 1),
('com_content.article', 11, 20, 12, '2025-02-17 23:57:50', 1),
('com_content.article', 12, 21, 13, '2025-02-17 23:57:36', 1),
('com_content.article', 13, 22, 9, '2025-02-18 00:58:42', 1),
('com_content.article', 14, 23, 10, '2025-02-17 23:57:14', 1),
('com_content.article', 15, 24, 11, '2025-02-17 23:57:00', 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__fields`
--


DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE `#__fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  `only_use_in_subform` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__fields_categories`
--


DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE `#__fields_categories` (
  `field_id` int NOT NULL DEFAULT '0',
  `category_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__fields_groups`
--


DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE `#__fields_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__fields_values`
--


DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE `#__fields_values` (
  `field_id` int unsigned NOT NULL,
  `item_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_base`
--


DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE `#__ucm_base` (
  `ucm_id` int unsigned NOT NULL,
  `ucm_item_id` int NOT NULL,
  `ucm_type_id` int NOT NULL,
  `ucm_language_id` int NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__ucm_base`
--


INSERT INTO `#__ucm_base` (`ucm_id`, `ucm_item_id`, `ucm_type_id`, `ucm_language_id`) VALUES 
(1, 18, 1, 0),
(2, 17, 1, 0),
(3, 16, 1, 0),
(4, 15, 1, 0),
(5, 14, 1, 0),
(6, 13, 1, 0),
(7, 12, 1, 0),
(8, 10, 1, 0),
(9, 11, 1, 0),
(10, 19, 1, 0),
(11, 20, 1, 0),
(12, 21, 1, 0),
(13, 22, 1, 0),
(14, 23, 1, 0),
(15, 24, 1, 0);


-- --------------------------------------------------------

--
-- Table structure for table `#__ucm_content`
--


DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE `#__ucm_content` (
  `core_content_id` int unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int unsigned DEFAULT NULL,
  `core_access` int unsigned NOT NULL DEFAULT '0',
  `core_params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_hits` int unsigned NOT NULL DEFAULT '0',
  `core_version` int unsigned NOT NULL DEFAULT '1',
  `core_ordering` int NOT NULL DEFAULT '0',
  `core_metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `core_catid` int unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';


--
-- Dumping data for table `#__ucm_content`
--


INSERT INTO `#__ucm_content` (`core_content_id`, `core_type_alias`, `core_title`, `core_alias`, `core_body`, `core_state`, `core_checked_out_time`, `core_checked_out_user_id`, `core_access`, `core_params`, `core_featured`, `core_metadata`, `core_created_user_id`, `core_created_by_alias`, `core_created_time`, `core_modified_user_id`, `core_modified_time`, `core_language`, `core_publish_up`, `core_publish_down`, `core_content_item_id`, `asset_id`, `core_images`, `core_urls`, `core_hits`, `core_version`, `core_ordering`, `core_metakey`, `core_metadesc`, `core_catid`, `core_xreference`, `core_type_id`) VALUES 
(1, 'com_content.article', 'Know Your Sound Tool: MW08 Sport Earphones', 'know-your-sound-tool-mw08-sport-earphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-29.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:50:29', 752, '2025-02-17 11:56:44', '*', '2021-08-27 11:50:29', NULL, 18, 107, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 183, 15, 0, '', '', 8, '', 1),
(2, 'com_content.article', 'Get to Know Your MW08 Sport Earphones', 'get-to-know-your-mw08-sport-earphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-21.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:49:32', 752, '2025-02-17 11:58:22', '*', '2021-08-27 11:49:32', NULL, 17, 106, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 134, 9, 1, '', '', 8, '', 1),
(3, 'com_content.article', 'How to Choose the Right Laptop for Your Needs', 'how-to-choose-the-right-laptop-for-your-needs', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-22.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2021\\/08\\/27\\/blog6.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog9.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog10.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog11.jpeg\\\"]}\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:48:43', 752, '2025-02-17 11:58:51', '*', '2021-08-27 11:48:43', NULL, 16, 105, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 15, 14, 2, '', '', 8, '', 1),
(4, 'com_content.article', 'Immersive Gaming Experience', 'immersive-gaming-experience', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-23.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:47:19', 752, '2025-02-17 11:58:56', '*', '2021-08-27 11:47:19', NULL, 15, 104, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 3, 12, 3, '', '', 8, '', 1),
(5, 'com_content.article', 'Your MW08 Sport Earphones', 'your-mw08-sport-earphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-24.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:46:12', 752, '2025-02-17 11:59:04', '*', '2021-08-27 11:46:12', NULL, 14, 103, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 3, 10, 4, '', '', 8, '', 1),
(6, 'com_content.article', 'The Rise of Smart Speakers', 'the-rise-of-smart-speakers', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-25.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:45:19', 752, '2025-02-17 11:59:11', '*', '2021-08-27 11:45:19', NULL, 13, 102, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 5, 10, 5, '', '', 8, '', 1),
(7, 'com_content.article', 'The All-Encompassing Realm ', 'a-deep-dive-into-generative-ai-whats-new-in-text-to-image-models', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-41.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:44:20', 752, '2025-02-17 11:59:19', '*', '2021-08-27 11:44:20', NULL, 12, 101, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 11, 10, 6, '', '', 8, '', 1),
(8, 'com_content.article', 'Inside In-Ear Excellence', 'green-tech-advancements-how-ai-is-driving-sustainability', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-46.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:42:12', 752, '2025-02-17 11:59:36', '*', '2021-08-27 11:42:12', NULL, 10, 99, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 1, 11, 8, '', '', 8, '', 1),
(9, 'com_content.article', 'Crafting classic leather', 'crafting-classic-leather', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-44.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:43:39', 752, '2025-02-17 11:59:26', '*', '2021-08-27 11:43:39', NULL, 11, 100, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 9, 11, 7, '', '', 8, '', 1),
(10, 'com_content.article', 'The Everlasting Digital Domain', 'the-everlasting-digital-domain', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-26.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:44:20', 752, '2025-02-17 11:58:06', '*', '2021-08-27 11:44:20', NULL, 19, 194, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 0, 11, 6, '', '', 8, '', 1),
(11, 'com_content.article', 'The Surge of Virtual Reality', 'the-surge-of-virtual-reality', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-45.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:43:39', 752, '2025-02-17 11:57:50', '*', '2021-08-27 11:43:39', NULL, 20, 195, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 1, 14, 7, '', '', 8, '', 1),
(12, 'com_content.article', 'Your ZX12 Studio Headphones', 'your-zx12-studio-headphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-28.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:42:12', 752, '2025-02-17 11:57:36', '*', '2021-08-27 11:42:12', NULL, 21, 196, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 0, 12, 8, '', '', 8, '', 1),
(13, 'com_content.article', 'The Digital Horizon', 'the-digital-horizon', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-251.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:49:32', 752, '2025-02-17 12:58:42', '*', '2021-08-27 11:49:32', NULL, 22, 197, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 2, 12, 1, '', '', 8, '', 1),
(14, 'com_content.article', 'The Evolution of Gaming Consoles', 'the-evolution-of-gaming-consoles', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-42.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2021\\/08\\/27\\/blog6.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog9.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog10.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog11.jpeg\\\"]}\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:48:43', 752, '2025-02-17 11:57:14', '*', '2021-08-27 11:48:43', NULL, 23, 198, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 2, 18, 2, '', '', 8, '', 1),
(15, 'com_content.article', 'Your AR05 Wireless Earbuds', 'your-ar05-wireless-earbuds', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 1, NULL, NULL, 1, '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-43.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 752, '', '2021-08-27 11:47:19', 752, '2025-02-17 11:57:00', '*', '2021-08-27 11:47:19', NULL, 24, 199, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', 1, 15, 3, '', '', 8, '', 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__webauthn_credentials`
--


DROP TABLE IF EXISTS `#__webauthn_credentials`;
CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'User handle',
  `label` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__mail_templates`
--


DROP TABLE IF EXISTS `#__mail_templates`;
CREATE TABLE `#__mail_templates` (
  `template_id` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(127) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `htmlbody` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachments` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__mail_templates`
--


INSERT INTO `#__mail_templates` (`template_id`, `extension`, `language`, `subject`, `body`, `htmlbody`, `attachments`, `params`) VALUES 
('com_actionlogs.notification', 'com_actionlogs', '', 'COM_ACTIONLOGS_EMAIL_SUBJECT', 'COM_ACTIONLOGS_EMAIL_BODY', 'COM_ACTIONLOGS_EMAIL_HTMLBODY', '', '{\"tags\":[\"messages\",\"message\",\"date\",\"extension\",\"username\"]}'),
('com_config.test_mail', 'com_config', '', 'COM_CONFIG_SENDMAIL_SUBJECT', 'COM_CONFIG_SENDMAIL_BODY', '', '', '{\"tags\":[\"sitename\",\"method\"]}'),
('com_contact.mail', 'com_contact', '', 'COM_CONTACT_ENQUIRY_SUBJECT', 'COM_CONTACT_ENQUIRY_TEXT', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\"]}'),
('com_contact.mail.copy', 'com_contact', '', 'COM_CONTACT_COPYSUBJECT_OF', 'COM_CONTACT_COPYTEXT_OF', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"subject\",\"body\",\"url\",\"customfields\",\"contactname\"]}'),
('com_joomlaupdate.update.failed', 'com_joomlaupdate', '', 'COM_JOOMLAUPDATE_UPDATE_FAILED_MAIL_SUBJECT', 'COM_JOOMLAUPDATE_UPDATE_FAILED_MAIL_BODY', '', '', '{\"tags\":[\"newversion\",\"oldversion\",\"sitename\",\"url\"]}'),
('com_joomlaupdate.update.success', 'com_joomlaupdate', '', 'COM_JOOMLAUPDATE_UPDATE_SUCCESS_MAIL_SUBJECT', 'COM_JOOMLAUPDATE_UPDATE_SUCCESS_MAIL_BODY', '', '', '{\"tags\":[\"newversion\",\"oldversion\",\"sitename\",\"url\"]}'),
('com_messages.new_message', 'com_messages', '', 'COM_MESSAGES_NEW_MESSAGE', 'COM_MESSAGES_NEW_MESSAGE_BODY', '', '', '{\"tags\":[\"subject\",\"message\",\"fromname\",\"sitename\",\"siteurl\",\"fromemail\",\"toname\",\"toemail\"]}'),
('com_privacy.notification.admin.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.admin.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_ADMIN_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.export', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_EXPORT_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_EXPORT_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.notification.remove', 'com_privacy', '', 'COM_PRIVACY_EMAIL_REQUEST_SUBJECT_REMOVE_REQUEST', 'COM_PRIVACY_EMAIL_REQUEST_BODY_REMOVE_REQUEST', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('com_privacy.userdataexport', 'com_privacy', '', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_SUBJECT', 'COM_PRIVACY_EMAIL_DATA_EXPORT_COMPLETED_BODY', '', '', '{\"tags\":[\"sitename\",\"url\"]}'),
('com_users.massmail.mail', 'com_users', '', 'COM_USERS_MASSMAIL_MAIL_SUBJECT', 'COM_USERS_MASSMAIL_MAIL_BODY', '', '', '{\"tags\":[\"subject\",\"body\",\"subjectprefix\",\"bodysuffix\"]}'),
('com_users.password_reset', 'com_users', '', 'COM_USERS_EMAIL_PASSWORD_RESET_SUBJECT', 'COM_USERS_EMAIL_PASSWORD_RESET_BODY', '', '', '{\"tags\":[\"name\",\"email\",\"sitename\",\"link_text\",\"link_html\",\"token\"]}'),
('com_users.registration.admin.new_notification', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.admin.verification_request', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATE_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"email\",\"username\",\"activate\"]}'),
('com_users.registration.user.admin_activated', 'com_users', '', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_SUBJECT', 'COM_USERS_EMAIL_ACTIVATED_BY_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.admin_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ADMIN_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.registration_mail', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.registration_mail_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.registration.user.self_activation', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY_NOPW', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\"]}'),
('com_users.registration.user.self_activation_w_pw', 'com_users', '', 'COM_USERS_EMAIL_ACCOUNT_DETAILS', 'COM_USERS_EMAIL_REGISTERED_WITH_ACTIVATION_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"activate\",\"siteurl\",\"username\",\"password_clear\"]}'),
('com_users.reminder', 'com_users', '', 'COM_USERS_EMAIL_USERNAME_REMINDER_SUBJECT', 'COM_USERS_EMAIL_USERNAME_REMINDER_BODY', '', '', '{\"tags\":[\"name\",\"username\",\"sitename\",\"email\",\"link_text\",\"link_html\"]}'),
('plg_content_joomla.newarticle', 'plg_content_joomla', '', 'PLG_CONTENT_JOOMLA_NEW_ARTICLE_SUBJECT', 'PLG_CONTENT_JOOMLA_NEW_ARTICLE_BODY', '', '', '{\"tags\":[\"sitename\",\"name\",\"email\",\"title\",\"url\"]}'),
('plg_multifactorauth_email.mail', 'plg_multifactorauth_email', '', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_SUBJECT', 'PLG_MULTIFACTORAUTH_EMAIL_EMAIL_BODY', '', '', '{\"tags\":[\"code\",\"sitename\",\"siteurl\",\"username\",\"email\",\"fullname\"]}'),
('plg_system_tasknotification.failure_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FAILURE_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\", \"exit_code\", \"exec_data_time\", \"task_output\"]}'),
('plg_system_tasknotification.fatal_recovery_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_FATAL_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.orphan_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_ORPHAN_MAIL_BODY', '', '', '{\"tags\": [\"task_id\", \"task_title\"]}'),
('plg_system_tasknotification.success_mail', 'plg_system_tasknotification', '', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_SUBJECT', 'PLG_SYSTEM_TASK_NOTIFICATION_SUCCESS_MAIL_BODY', '', '', '{\"tags\":[\"task_id\", \"task_title\", \"exec_data_time\", \"task_output\"]}'),
('plg_task_privacyconsent.request.reminder', 'plg_task_privacyconsent', '', 'PLG_TASK_PRIVACYCONSENT_EMAIL_REMIND_SUBJECT', 'PLG_TASK_PRIVACYCONSENT_EMAIL_REMIND_BODY', '', '', '{\"tags\":[\"sitename\",\"url\",\"tokenurl\",\"formurl\",\"token\"]}'),
('plg_task_updatenotification.mail', 'plg_task_updatenotification', '', 'PLG_TASK_UPDATENOTIFICATION_EMAIL_SUBJECT', 'PLG_TASK_UPDATENOTIFICATION_EMAIL_BODY', '', '', '{\"tags\":[\"newversion\",\"curversion\",\"sitename\",\"url\",\"link\",\"releasenews\"]}'),
('plg_user_joomla.mail', 'plg_user_joomla', '', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_SUBJECT', 'PLG_USER_JOOMLA_NEW_USER_EMAIL_BODY', '', '', '{\"tags\":[\"name\",\"sitename\",\"url\",\"username\",\"password\",\"email\"]}');


-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--


DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cid` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int NOT NULL DEFAULT '0',
  `impmade` int NOT NULL DEFAULT '0',
  `clicks` int NOT NULL DEFAULT '0',
  `clickurl` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100)),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--


DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--


DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int unsigned NOT NULL,
  `banner_id` int unsigned NOT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--


DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `catid` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__contact_details`
--


INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `publish_up`, `publish_down`, `version`, `hits`) VALUES 
(1, 'Contact', 'contact', '', '', '', '', '', '', '', '', '', '', '', 0, 1, NULL, NULL, 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 228, 4, 1, '', '', '', '', '', '*', '2021-08-19 09:54:33', 874, '', '2021-08-20 09:31:56', 874, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, NULL, NULL, 11, 90);


-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--


DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__content`
--


INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES 
(10, 99, 'Inside In-Ear Excellence', 'green-tech-advancements-how-ai-is-driving-sustainability', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:42:12', 752, '', '2025-02-17 11:59:36', 752, NULL, NULL, '2021-08-27 11:42:12', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-46.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 11, 8, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(11, 100, 'Crafting classic leather', 'crafting-classic-leather', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:43:39', 752, '', '2025-02-17 11:59:26', 752, NULL, NULL, '2021-08-27 11:43:39', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-44.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 11, 7, '', '', 1, 9, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(12, 101, 'The All-Encompassing Realm ', 'a-deep-dive-into-generative-ai-whats-new-in-text-to-image-models', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:44:20', 752, '', '2025-02-17 11:59:19', 752, NULL, NULL, '2021-08-27 11:44:20', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-41.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 10, 6, '', '', 1, 13, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(13, 102, 'The Rise of Smart Speakers', 'the-rise-of-smart-speakers', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:45:19', 752, '', '2025-02-17 11:59:11', 752, NULL, NULL, '2021-08-27 11:45:19', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-25.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 10, 5, '', '', 1, 10, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(14, 103, 'Your MW08 Sport Earphones', 'your-mw08-sport-earphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:46:12', 752, '', '2025-02-17 11:59:04', 752, NULL, NULL, '2021-08-27 11:46:12', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-24.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 10, 4, '', '', 1, 12, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(15, 104, 'Immersive Gaming Experience', 'immersive-gaming-experience', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:47:19', 752, '', '2025-02-17 11:58:56', 752, NULL, NULL, '2021-08-27 11:47:19', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-23.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 12, 3, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(16, 105, 'How to Choose the Right Laptop for Your Needs', 'how-to-choose-the-right-laptop-for-your-needs', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:48:43', 752, '', '2025-02-17 11:58:51', 752, NULL, NULL, '2021-08-27 11:48:43', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-22.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2021\\/08\\/27\\/blog6.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog9.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog10.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog11.jpeg\\\"]}\",\"helix_ultimate_video\":\"\"}', 14, 2, '', '', 1, 15, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(17, 106, 'Get to Know Your MW08 Sport Earphones', 'get-to-know-your-mw08-sport-earphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:49:32', 752, '', '2025-02-17 11:58:22', 752, NULL, NULL, '2021-08-27 11:49:32', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-21.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 9, 1, '', '', 1, 140, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(18, 107, 'Know Your Sound Tool: MW08 Sport Earphones', 'know-your-sound-tool-mw08-sport-earphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:50:29', 752, '', '2025-02-17 11:56:44', 752, NULL, NULL, '2021-08-27 11:50:29', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-29.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 15, 0, '', '', 1, 202, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(19, 194, 'The Everlasting Digital Domain', 'the-everlasting-digital-domain', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:44:20', 752, '', '2025-02-17 11:58:06', 752, NULL, NULL, '2021-08-27 11:44:20', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-26.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 11, 6, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(20, 195, 'The Surge of Virtual Reality', 'the-surge-of-virtual-reality', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:43:39', 752, '', '2025-02-17 11:57:50', 752, NULL, NULL, '2021-08-27 11:43:39', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-45.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 14, 7, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(21, 196, 'Your ZX12 Studio Headphones', 'your-zx12-studio-headphones', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:42:12', 752, '', '2025-02-17 11:57:36', 752, NULL, NULL, '2021-08-27 11:42:12', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-28.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 12, 8, '', '', 1, 0, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(22, 197, 'The Digital Horizon', 'the-digital-horizon', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:49:32', 752, '', '2025-02-17 12:58:42', 752, NULL, NULL, '2021-08-27 11:49:32', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/13\\/blog-image-251.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 12, 1, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(23, 198, 'The Evolution of Gaming Consoles', 'the-evolution-of-gaming-consoles', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:48:43', 752, '', '2025-02-17 11:57:14', 752, NULL, NULL, '2021-08-27 11:48:43', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-42.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2021\\/08\\/27\\/blog6.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog9.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog10.jpg\\\",\\\"images\\/2021\\/08\\/27\\/blog11.jpeg\\\"]}\",\"helix_ultimate_video\":\"\"}', 18, 2, '', '', 1, 4, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', ''),
(24, 199, 'Your AR05 Wireless Earbuds', 'your-ar05-wireless-earbuds', '<p>After moving around 6 different cities in 3 continents on a quest for global experience</p>\r\n', 'The realm of audio has witnessed incredible advancements over the past decade. As we venture further into this era of technological marvels, the way we experience and interact with sound continues to evolve.       At MegaDeal ii, we’re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we’ve got you covered.       The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth & Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we’re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.       The Future Sounds Good:         Voice integration: The rise of smart assistants has made voice-controlled speakers the new norm.\nMulti-room setups: Seamless sound across different rooms ensures a cohesive audio experience.\nSustainable designs: The focus is shifting towards eco-friendly materials and energy-efficient models.\nImmersive experiences: Expect more 360-degree sound systems and spatial audio setups.\nPersonalization: Customizable sound profiles tailored to individual preferences.\n                   The Technology Behind the Tunes         Delving into the heart of these devices, one discovers a world of intricate circuits, advanced materials, and innovative designs. The quest for the perfect sound has driven engineers and designers to push boundaries and challenge conventions. But beyond the technical jargon and specs lies a simple goal: to recreate the emotion and depth of live sound.\nAdvanced bass technologies, for instance, ensure deep and resonant lows. These innovations bring forth the heartbeat of songs, allowing listeners to feel the rhythm as much as they hear it. On the other hand, treble delivery technologies ensure that the subtleties of instruments and vocals are never lost, preserving the artist\'s intent.', 1, 8, '2021-08-27 11:47:19', 752, '', '2025-02-17 11:57:00', 752, NULL, NULL, '2021-08-27 11:47:19', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Read more\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/02\\/14\\/blog-image-43.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 15, 3, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', 0, '*', '');


-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--


DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--


DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int NOT NULL DEFAULT '0',
  `rating_sum` int unsigned NOT NULL DEFAULT '0',
  `rating_count` int unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__content_rating`
--


INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES 
(1, 5, 1, '::1'),
(3, 5, 1, '::1'),
(9, 5, 1, '10.0.1.2'),
(17, 5, 1, '127.0.0.1'),
(18, 5, 1, '127.0.0.1');


-- --------------------------------------------------------

--
-- Table structure for table `#__scheduler_tasks`
--


DROP TABLE IF EXISTS `#__scheduler_tasks`;
CREATE TABLE `#__scheduler_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint NOT NULL DEFAULT '0',
  `last_exit_code` int NOT NULL DEFAULT '0' COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int DEFAULT '0' COMMENT 'Count of successful triggers',
  `times_failed` int DEFAULT '0' COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0' COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint NOT NULL DEFAULT '0' COMMENT 'If 1, the task is only accessible via CLI',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__scheduler_tasks`
--


INSERT INTO `#__scheduler_tasks` (`id`, `asset_id`, `title`, `type`, `execution_rules`, `cron_rules`, `state`, `last_exit_code`, `last_execution`, `next_execution`, `times_executed`, `times_failed`, `locked`, `priority`, `ordering`, `cli_exclusive`, `params`, `note`, `created`, `created_by`, `checked_out`, `checked_out_time`) VALUES 
(1, 114, 'Rotate Logs', 'rotation.logs', '{\"rule-type\":\"interval-days\",\"interval-days\":30,\"exec-time\":\"10:08\",\"exec-day\":\"10\"}', '{\"type\":\"interval\",\"exp\":\"P30D\"}', 1, 0, NULL, '2025-02-09 10:08:00', 0, 0, NULL, 0, 0, 0, '{\"logstokeep\":1}', NULL, '2025-01-10 10:22:12', 962, NULL, NULL),
(2, 115, 'Session GC', 'session.gc', '{\"rule-type\":\"interval-hours\",\"interval-hours\":24,\"exec-time\":\"10:22\",\"exec-day\":\"10\"}', '{\"type\":\"interval\",\"exp\":\"PT24H\"}', 1, 0, '2025-01-14 04:33:15', '2025-01-15 04:33:15', 2, 0, NULL, 0, 0, 0, '{\"enable_session_gc\":1,\"enable_session_metadata_gc\":1}', NULL, '2025-01-10 10:22:12', 962, NULL, NULL),
(3, 116, 'Update Notification', 'update.notification', '{\"rule-type\":\"interval-hours\",\"interval-hours\":6,\"exec-time\":\"10:08\",\"exec-day\":\"10\"}', '{\"type\":\"interval\",\"exp\":\"PT6H\"}', 1, 0, '2025-01-14 11:02:55', '2025-01-14 17:02:56', 4, 0, '2025-01-15 04:46:59', 0, 0, 0, '{\"email\":\"\",\"language_override\":\"\"}', NULL, '2025-01-10 10:22:12', 962, NULL, NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__guidedtours`
--


DROP TABLE IF EXISTS `#__guidedtours`;
CREATE TABLE `#__guidedtours` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `extensions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `access` int unsigned NOT NULL DEFAULT '0',
  `autostart` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`),
  KEY `idx_uid` (`uid`(191))
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__guidedtours`
--


INSERT INTO `#__guidedtours` (`id`, `title`, `uid`, `description`, `ordering`, `extensions`, `url`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`, `published`, `language`, `note`, `access`, `autostart`) VALUES 
(1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_TITLE', 'joomla-guidedtours', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_DESCRIPTION', 1, '[\"com_guidedtours\"]', 'administrator/index.php?option=com_guidedtours&view=tours', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_TITLE', 'joomla-guidedtoursteps', 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_DESCRIPTION', 2, '[\"com_guidedtours\"]', 'administrator/index.php?option=com_guidedtours&view=tours', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_TITLE', 'joomla-articles', 'COM_GUIDEDTOURS_TOUR_ARTICLES_DESCRIPTION', 3, '[\"com_content\",\"com_categories\"]', 'administrator/index.php?option=com_content&view=articles', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_TITLE', 'joomla-categories', 'COM_GUIDEDTOURS_TOUR_CATEGORIES_DESCRIPTION', 4, '[\"com_content\",\"com_categories\"]', 'administrator/index.php?option=com_categories&view=categories&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(5, 'COM_GUIDEDTOURS_TOUR_MENUS_TITLE', 'joomla-menus', 'COM_GUIDEDTOURS_TOUR_MENUS_DESCRIPTION', 5, '[\"com_menus\"]', 'administrator/index.php?option=com_menus&view=menus', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(6, 'COM_GUIDEDTOURS_TOUR_TAGS_TITLE', 'joomla-tags', 'COM_GUIDEDTOURS_TOUR_TAGS_DESCRIPTION', 6, '[\"com_tags\"]', 'administrator/index.php?option=com_tags&view=tags', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(7, 'COM_GUIDEDTOURS_TOUR_BANNERS_TITLE', 'joomla-banners', 'COM_GUIDEDTOURS_TOUR_BANNERS_DESCRIPTION', 7, '[\"com_banners\"]', 'administrator/index.php?option=com_banners&view=banners', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_TITLE', 'joomla-contacts', 'COM_GUIDEDTOURS_TOUR_CONTACTS_DESCRIPTION', 8, '[\"com_contact\"]', 'administrator/index.php?option=com_contact&view=contacts', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_TITLE', 'joomla-newsfeeds', 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_DESCRIPTION', 9, '[\"com_newsfeeds\"]', 'administrator/index.php?option=com_newsfeeds&view=newsfeeds', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_TITLE', 'joomla-smartsearch', 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_DESCRIPTION', 10, '[\"com_finder\"]', 'administrator/index.php?option=com_finder&view=filters', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(11, 'COM_GUIDEDTOURS_TOUR_USERS_TITLE', 'joomla-users', 'COM_GUIDEDTOURS_TOUR_USERS_DESCRIPTION', 11, '[\"com_users\"]', 'administrator/index.php?option=com_users&view=users', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, 1, '*', '', 1, 0),
(12, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_TITLE', 'joomla-welcome', 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_DESCRIPTION', 1, '[\"com_cpanel\"]', 'administrator/index.php', '2025-01-10 16:22:12', 0, '2025-01-10 16:22:12', 0, NULL, NULL, 1, '*', '', 1, 0),
(16, 'COM_GUIDEDTOURS_TOUR_WHATSNEW_6_0_TITLE', 'joomla-whatsnew-6-0', 'COM_GUIDEDTOURS_TOUR_WHATSNEW_6_0_DESCRIPTION', 0, '[\"com_cpanel\"]', 'administrator/index.php', '2025-10-24 17:28:14', 0, '2025-10-24 17:28:14', 0, NULL, NULL, 1, '*', '', 1, 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__guidedtour_steps`
--


DROP TABLE IF EXISTS `#__guidedtour_steps`;
CREATE TABLE `#__guidedtour_steps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `tour_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `target` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` int NOT NULL,
  `interactive_type` int NOT NULL DEFAULT '1',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_tour` (`tour_id`),
  KEY `idx_state` (`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__guidedtour_steps`
--


INSERT INTO `#__guidedtour_steps` (`id`, `tour_id`, `title`, `published`, `description`, `ordering`, `position`, `target`, `type`, `interactive_type`, `url`, `created`, `created_by`, `modified`, `modified_by`, `checked_out_time`, `checked_out`, `language`, `note`, `params`) VALUES 
(1, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_NEW_DESCRIPTION', 1, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_guidedtours&view=tours', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(2, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_TITLE_DESCRIPTION', 2, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(3, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_URL_DESCRIPTION', 3, 'top', '#jform_url', 2, 2, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(4, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONTENT_DESCRIPTION', 4, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(5, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_COMPONENT_DESCRIPTION', 5, 'top', 'joomla-field-fancy-select .choices', 2, 3, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(6, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_SAVECLOSE_DESCRIPTION', 7, 'top', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(7, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_CONGRATULATIONS_DESCRIPTION', 8, 'bottom', '', 0, 1, 'administrator/index.php?option=com_guidedtours&view=tour&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(8, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_COUNTER_DESCRIPTION', 8, 'top', '#toursList tbody tr:nth-last-of-type(1) td:nth-of-type(5) .btn', 2, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(9, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_NEW_DESCRIPTION', 9, 'bottom', '.button-new', 2, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(10, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TITLE_DESCRIPTION', 10, 'bottom', '#jform_title', 2, 2, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(11, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_DESCRIPTION_DESCRIPTION', 11, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(12, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_STATUS_DESCRIPTION', 12, 'bottom', '#jform_published', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(13, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_POSITION_DESCRIPTION', 13, 'top', '#jform_position', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(14, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TARGET_DESCRIPTION', 14, 'top', '#jform_target', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(15, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_TYPE_DESCRIPTION', 15, 'top', '#jform_type', 2, 3, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(16, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_SAVECLOSE_DESCRIPTION', 16, 'bottom', '#save-group-children-save .button-save', 2, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(17, 2, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURSTEPS_STEP_CONGRATULATIONS_DESCRIPTION', 17, 'bottom', '', 0, 1, '', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(18, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NEW_DESCRIPTION', 18, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_content&view=articles', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(19, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TITLE_DESCRIPTION', 19, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(20, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ALIAS_DESCRIPTION', 20, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(21, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONTENT_DESCRIPTION', 21, 'bottom', '#jform_articletext,#jform_articletext_ifr', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(22, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_STATUS_DESCRIPTION', 22, 'bottom', '#jform_state', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(23, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CATEGORY_DESCRIPTION', 23, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(24, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_FEATURED_DESCRIPTION', 24, 'bottom', '#jform_featured0', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(25, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_ACCESS_DESCRIPTION', 25, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(26, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_TAGS_DESCRIPTION', 26, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(27, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_NOTE_DESCRIPTION', 27, 'top', '#jform_note', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(28, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_VERSIONNOTE_DESCRIPTION', 28, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(29, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_SAVECLOSE_DESCRIPTION', 29, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(30, 3, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_ARTICLES_STEP_CONGRATULATIONS_DESCRIPTION', 30, 'bottom', '', 0, 1, 'administrator/index.php?option=com_content&view=article&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(31, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NEW_DESCRIPTION', 31, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_categories&view=categories&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(32, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TITLE_DESCRIPTION', 32, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(33, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ALIAS_DESCRIPTION', 33, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(34, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONTENT_DESCRIPTION', 34, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(35, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_PARENT_DESCRIPTION', 35, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(36, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_STATUS_DESCRIPTION', 36, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(37, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_ACCESS_DESCRIPTION', 37, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(38, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_TAGS_DESCRIPTION', 38, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(39, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_NOTE_DESCRIPTION', 39, 'top', '#jform_note', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(40, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_VERSIONNOTE_DESCRIPTION', 40, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(41, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_SAVECLOSE_DESCRIPTION', 41, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(42, 4, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CATEGORIES_STEP_CONGRATULATIONS_DESCRIPTION', 42, 'bottom', '', 0, 1, 'administrator/index.php?option=com_categories&view=category&layout=edit&extension=com_content', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(43, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_NEW_DESCRIPTION', 43, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_menus&view=menus', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(44, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_TITLE_DESCRIPTION', 44, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(45, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_UNIQUENAME_DESCRIPTION', 45, 'top', '#jform_menutype', 2, 2, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(46, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_DESCRIPTION_DESCRIPTION', 46, 'top', '#jform_menudescription', 2, 2, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(47, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_SAVECLOSE_DESCRIPTION', 47, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(48, 5, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_MENUS_STEP_CONGRATULATIONS_DESCRIPTION', 48, 'bottom', '', 0, 1, 'administrator/index.php?option=com_menus&view=menu&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(49, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NEW_DESCRIPTION', 49, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_tags&view=tags', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(50, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_TITLE_DESCRIPTION', 50, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(51, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ALIAS_DESCRIPTION', 51, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(52, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONTENT_DESCRIPTION', 52, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(53, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_PARENT_DESCRIPTION', 53, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(54, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_STATUS_DESCRIPTION', 54, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(55, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_ACCESS_DESCRIPTION', 55, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(56, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_NOTE_DESCRIPTION', 56, 'top', '#jform_note', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(57, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_VERSIONNOTE_DESCRIPTION', 57, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(58, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_SAVECLOSE_DESCRIPTION', 58, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(59, 6, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_TAGS_STEP_CONGRATULATIONS_DESCRIPTION', 59, 'bottom', '', 0, 1, 'administrator/index.php?option=com_tags&view=tag&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(60, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_NEW_DESCRIPTION', 60, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_banners&view=banners', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(61, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_TITLE_DESCRIPTION', 61, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(62, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_ALIAS_DESCRIPTION', 62, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(63, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_DETAILS_DESCRIPTION', 63, 'bottom', '.col-lg-9', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(64, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_STATUS_DESCRIPTION', 64, 'bottom', '#jform_state', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(65, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CATEGORY_DESCRIPTION', 65, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(66, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_PINNED_DESCRIPTION', 66, 'bottom', '#jform_sticky1', 2, 3, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(67, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_VERSIONNOTE_DESCRIPTION', 67, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(68, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_SAVECLOSE_DESCRIPTION', 68, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(69, 7, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_BANNERS_STEP_CONGRATULATIONS_DESCRIPTION', 69, 'bottom', '', 0, 1, 'administrator/index.php?option=com_banners&view=banner&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(70, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_NEW_DESCRIPTION', 70, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_contact&view=contacts', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(71, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TITLE_DESCRIPTION', 71, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(72, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ALIAS_DESCRIPTION', 72, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(73, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_DETAILS_DESCRIPTION', 73, 'bottom', '.col-lg-9', 0, 1, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(74, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_STATUS_DESCRIPTION', 74, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(75, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CATEGORY_DESCRIPTION', 75, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(76, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_FEATURED_DESCRIPTION', 76, 'bottom', '#jform_featured0', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(77, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_ACCESS_DESCRIPTION', 77, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(78, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_TAGS_DESCRIPTION', 78, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(79, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_VERSIONNOTE_DESCRIPTION', 79, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(80, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_SAVECLOSE_DESCRIPTION', 80, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(81, 8, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_CONTACTS_STEP_CONGRATULATIONS_DESCRIPTION', 81, 'bottom', '', 0, 1, 'administrator/index.php?option=com_contact&view=contact&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(82, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_NEW_DESCRIPTION', 82, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_newsfeeds&view=newsfeeds', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(83, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TITLE_DESCRIPTION', 83, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(84, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ALIAS_DESCRIPTION', 84, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(85, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_LINK_DESCRIPTION', 85, 'bottom', '#jform_link', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(86, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_DESCRIPTION_DESCRIPTION', 86, 'bottom', '#jform_description,#jform_description_ifr', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(87, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_STATUS_DESCRIPTION', 87, 'bottom', '#jform_published', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(88, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CATEGORY_DESCRIPTION', 88, 'top', 'joomla-field-fancy-select .choices[data-type=select-one]', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(89, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_ACCESS_DESCRIPTION', 89, 'bottom', '#jform_access', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(90, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_TAGS_DESCRIPTION', 90, 'top', 'joomla-field-fancy-select .choices[data-type=select-multiple]', 2, 3, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(91, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_VERSIONNOTE_DESCRIPTION', 91, 'top', '#jform_version_note', 2, 2, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(92, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_SAVECLOSE_DESCRIPTION', 92, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(93, 9, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_NEWSFEEDS_STEP_CONGRATULATIONS_DESCRIPTION', 93, 'bottom', '', 0, 1, 'administrator/index.php?option=com_newsfeeds&view=newsfeed&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(94, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_NEW_DESCRIPTION', 94, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_finder&view=filters', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(95, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_TITLE_DESCRIPTION', 95, 'bottom', '#jform_title', 2, 2, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(96, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_ALIAS_DESCRIPTION', 96, 'bottom', '#jform_alias', 2, 2, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(97, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONTENT_DESCRIPTION', 97, 'bottom', '.col-lg-9', 0, 1, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(98, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_STATUS_DESCRIPTION', 98, 'bottom', '#jform_state', 2, 3, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(99, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_SAVECLOSE_DESCRIPTION', 99, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(100, 10, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_SMARTSEARCH_STEP_CONGRATULATIONS_DESCRIPTION', 100, 'bottom', '', 0, 1, 'administrator/index.php?option=com_finder&view=filter&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(101, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NEW_DESCRIPTION', 101, 'bottom', '.button-new', 2, 1, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(102, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_NAME_DESCRIPTION', 102, 'bottom', '#jform_name', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(103, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_LOGINNAME_DESCRIPTION', 103, 'bottom', '#jform_username', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(104, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD_DESCRIPTION', 104, 'bottom', '#jform_password', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(105, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORD2_DESCRIPTION', 105, 'bottom', '#jform_password2', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(106, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_EMAIL_DESCRIPTION', 106, 'bottom', '#jform_email', 2, 2, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(107, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SYSTEMEMAIL_DESCRIPTION', 107, 'top', '#jform_sendEmail0', 2, 3, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(108, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_STATUS_DESCRIPTION', 108, 'top', '#jform_block0', 2, 3, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(109, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_PASSWORDRESET_DESCRIPTION', 109, 'top', '#jform_requireReset0', 2, 3, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(110, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_SAVECLOSE_DESCRIPTION', 110, 'bottom', '#save-group-children-save .button-save', 2, 1, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(111, 11, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_USERS_STEP_CONGRATULATIONS_DESCRIPTION', 111, 'bottom', '', 0, 1, 'administrator/index.php?option=com_users&view=user&layout=edit', '2023-05-26 19:22:45', 0, '2023-05-26 19:22:45', 0, NULL, NULL, '*', '', NULL),
(112, 12, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_MENUS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_MENUS_DESCRIPTION', 1, 'right', '#sidebarmenu', 0, 1, '', '2025-01-10 16:22:12', 0, '2025-01-10 16:22:12', 0, NULL, NULL, '*', '', NULL),
(113, 12, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_QUICKACCESS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_QUICKACCESS_DESCRIPTION', 2, 'center', '', 0, 1, '', '2025-01-10 16:22:12', 0, '2025-01-10 16:22:12', 0, NULL, NULL, '*', '', NULL),
(114, 12, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_NOTIFICATIONS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_NOTIFICATIONS_DESCRIPTION', 3, 'left', '.quickicons-for-update_quickicon .card', 0, 1, '', '2025-01-10 16:22:12', 0, '2025-01-10 16:22:12', 0, NULL, NULL, '*', '', NULL),
(115, 12, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_TOPBAR_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_TOPBAR_DESCRIPTION', 4, 'bottom', '#header', 0, 1, '', '2025-01-10 16:22:12', 0, '2025-01-10 16:22:12', 0, NULL, NULL, '*', '', NULL),
(116, 12, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_FINALWORDS_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_WELCOMETOJOOMLA_STEP_FINALWORDS_DESCRIPTION', 5, 'right', '#sidebarmenu nav > ul:first-of-type > li:last-child', 0, 1, '', '2025-01-10 16:22:12', 0, '2025-01-10 16:22:12', 0, NULL, NULL, '*', '', NULL),
(118, 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_AUTOSTART_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_GUIDEDTOURS_STEP_AUTOSTART_DESCRIPTION', 6, 'bottom', '#jform_autostart0', 2, 3, '', '2025-01-10 16:22:12', 0, '2025-01-10 16:22:12', 0, NULL, NULL, '*', '', NULL),
(121, 16, 'COM_GUIDEDTOURS_TOUR_WHATSNEW_6_0_STEP_0_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_WHATSNEW_6_0_STEP_0_DESCRIPTION', 0, 'center', '', 0, 1, '', '2025-10-24 17:28:14', 0, '2025-10-24 17:28:14', 0, NULL, NULL, '*', '', '{\"required\":1,\"requiredvalue\":\"\"}'),
(122, 16, 'COM_GUIDEDTOURS_TOUR_WHATSNEW_6_0_STEP_1_TITLE', 1, 'COM_GUIDEDTOURS_TOUR_WHATSNEW_6_0_STEP_1_DESCRIPTION', 0, 'right', '#sidebarmenu nav > ul:first-of-type > li:last-child', 0, 1, '', '2025-10-24 17:28:14', 0, '2025-10-24 17:28:14', 0, NULL, NULL, '*', '', '\"{\"required\":1,\"requiredvalue\":\"\"}\"');


-- --------------------------------------------------------

--
-- Table structure for table `#__tuf_metadata`
--


DROP TABLE IF EXISTS `#__tuf_metadata`;
CREATE TABLE `#__tuf_metadata` (
  `id` int NOT NULL AUTO_INCREMENT,
  `update_site_id` int DEFAULT '0',
  `root` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `targets` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `snapshot` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `timestamp` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mirrors` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Secure TUF Updates';


--
-- Dumping data for table `#__tuf_metadata`
--


INSERT INTO `#__tuf_metadata` (`id`, `update_site_id`, `root`, `targets`, `snapshot`, `timestamp`, `mirrors`) VALUES 
(1, 51, '{\"signed\":{\"_type\":\"root\",\"spec_version\":\"1.0\",\"version\":10,\"expires\":\"2026-10-05T17:34:42Z\",\"keys\":{\"00e432b504508246e2bd536dd6c13e55e8b3256f0be9f767fae26da6c2a28663\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"250f8d293c49817a83909dead96ad82b62f7ac16844cf589f8d2f0e0b15cab21\"}},\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"9b2af2d9b9727227735253d795bd27ea8f0e294a5f3603e822dc5052b44802b9\"}},\"179d107f20a2354ac5bd9a1f32a2df1763c0059617f0c132bebeb4816a1a8637\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"159a4195cbafce2bb959f09ab2b36a2127b8967f94d389f65f1e7892fccfe8b8\"}},\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"a18e5ebabc19d5d5984b601a292ece61ba3662ab2d071dc520da5bd4f8948799\"}},\"273e94e5477e306ad6de75be1524860e219e265ff9a57c81ababd0691e45706c\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"1cb6702338830ef1c9e76a022fed27172d475bbaace754d8141ebc96dad8b15f\"}},\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"cb0a7a131961a20edea051d6dc2b091fb650bd399bd8514adb67b3c60db9f8f9\"}},\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"589d029a68b470deff1ca16dbf3eea6b5b3fcba0ae7bb52c468abc7fb058b2a2\"}},\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"6043c8bacc76ac5c9750f45454dd865c6ca1fc57d69e14cc192cfd420f6a66a9\"}},\"9eabc37383b243cd236375c66693db385911914b52556e1ec05fc70ed45e1bfe\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"a4b8509488f1c29ab0b1f610e7452fbec78b4f33f1fba5a418d6ff087c567429\"}},\"a1a4b7fdbeedfdeff12d7776de098a2f8de8d2ab7bfe10062a281b3819b078c1\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"ea764b0b475b3c396627ac6689cbd8f54a5f93e87b6f5e3eb44a7ccafb542ff3\"}},\"bfee044dd4574a281c9b7c0b6829913ef292c66c0512d1091a298cfca8493da9\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"6eb44460e5914e8e0df726ddb90bd1f3771b8ce5af19b40fb01ac5a85b023a6f\"}},\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"ad1950e117b29ebe7a38635a2e574123e07571e4f9a011783e053b5f15d2562a\"}},\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"5d451915bc2b93a0e4e4745bc6a8b292d58996d50e0fb66c78c7827152a65879\"}}},\"roles\":{\"root\":{\"keyids\":[\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\"],\"threshold\":1},\"snapshot\":{\"keyids\":[\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\",\"bfee044dd4574a281c9b7c0b6829913ef292c66c0512d1091a298cfca8493da9\",\"9eabc37383b243cd236375c66693db385911914b52556e1ec05fc70ed45e1bfe\",\"273e94e5477e306ad6de75be1524860e219e265ff9a57c81ababd0691e45706c\",\"00e432b504508246e2bd536dd6c13e55e8b3256f0be9f767fae26da6c2a28663\",\"179d107f20a2354ac5bd9a1f32a2df1763c0059617f0c132bebeb4816a1a8637\",\"a1a4b7fdbeedfdeff12d7776de098a2f8de8d2ab7bfe10062a281b3819b078c1\"],\"threshold\":1},\"targets\":{\"keyids\":[\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\",\"bfee044dd4574a281c9b7c0b6829913ef292c66c0512d1091a298cfca8493da9\",\"9eabc37383b243cd236375c66693db385911914b52556e1ec05fc70ed45e1bfe\",\"273e94e5477e306ad6de75be1524860e219e265ff9a57c81ababd0691e45706c\",\"00e432b504508246e2bd536dd6c13e55e8b3256f0be9f767fae26da6c2a28663\",\"179d107f20a2354ac5bd9a1f32a2df1763c0059617f0c132bebeb4816a1a8637\",\"a1a4b7fdbeedfdeff12d7776de098a2f8de8d2ab7bfe10062a281b3819b078c1\"],\"threshold\":1},\"timestamp\":{\"keyids\":[\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\"],\"threshold\":1}},\"consistent_snapshot\":true},\"signatures\":[{\"keyid\":\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"sig\":\"eb35e82f88ac55a34a8d49c6c0d6b0448e06fb394db76c090282fba511cba00194f78ddbc67879077b3fc5c9d48f8b40c9dd1389b6ca6612ed182549dc77ff08\"}]}', '{\"signed\":{\"_type\":\"targets\",\"spec_version\":\"1.0\",\"version\":72,\"expires\":\"2026-01-18T11:35:26Z\",\"targets\":{\"Joomla_5.1.2-Stable-Upgrade_Package.zip\":{\"length\":28134889,\"hashes\":{\"sha512\":\"d6b46cdedb9b31d01a607fe4c2f3a830a3265ed6ae5c0cb7b0f836b1b016ee7c639bd8948df00baf1b61a87f2fc71368a80b39e67ef9ec2b8842ee0ab09a620f\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.1.2 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-1-2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.1.2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.1.2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5909-joomla-5-1-2-and-joomla-4-4-6-security-and-bug-fix-release.html\",\"title\":\"Joomla! 5.1.2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.1.2\",\"php_minimum\":\"8.1.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.1.2\"}},\"Joomla_5.3.3-Stable-Update_Package.zip\":{\"length\":29441974,\"hashes\":{\"sha512\":\"396cdba79e1c85138341e00f7e91fcb7d78e6de4126a7f9f76dc5a3973ceaf20dee90bb1b09492669dbaf4d4c9200df46677c09fb7fbd0535d14505d3c7cf3a2\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.3.3 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-3-3/Joomla_5.3.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.3.3/Joomla_5.3.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.3.3/Joomla_5.3.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5930-joomla-5-3-3-bugfix-release.html\",\"title\":\"Joomla! 5.3.3 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.3.3\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.3.3\"}},\"Joomla_5.3.4-Stable-Update_Package.zip\":{\"length\":29854677,\"hashes\":{\"sha512\":\"12a386645464b4f973ec28b40252cca28f56fdbe3f89efa37a4deaebb3334088c427e74bb90fa3068efc2df785a96510befde496f6341bd83f2a1b45b3d693ea\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.3.4 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-3-4/Joomla_5.3.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.3.4/Joomla_5.3.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.3.4/Joomla_5.3.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5936-joomla-5-3-4-security-bugfix-release.html\",\"title\":\"Joomla! 5.3.4 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.3.4\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.3.4\"}},\"Joomla_5.4.0-Stable-Update_Package.zip\":{\"length\":29974846,\"hashes\":{\"sha512\":\"c862b2674acd3f7da6062ea2a0defa35c2c5c9091eaf742106f6cf5793d321ed7a9b99901c7ad15845cef4e4cb7e2806af64794fdcf5a30b7e1c4db60bcd10ae\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.0 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-4-0/Joomla_5.4.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.0/Joomla_5.4.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.4.0/Joomla_5.4.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5939-joomla-6-0-and-joomla-5-4-are-here.html\",\"title\":\"Joomla! 5.4.0 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.0\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.0\"}},\"Joomla_6.0.0-Stable-Update_Package.zip\":{\"length\":30236123,\"hashes\":{\"sha512\":\"ab69bb8305aa23f010695366ef769c99ec5a32343afbb418b6ed03c9ca541ad0222136d3a7ed4a8989f33d638ffdfc4c551e96250e0dbaa3fe45f2c2e8825018\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.0 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla6/6-0-0/Joomla_6.0.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.0/Joomla_6.0.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/6.0.0/Joomla_6.0.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5939-joomla-6-0-and-joomla-5-4-are-here.html\",\"title\":\"Joomla! 6.0.0 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.0\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.0\"}}}},\"signatures\":[{\"keyid\":\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"sig\":\"cef692436977e4d15a2bf1d95f838993e6cd89c53c7140e0c3c08a09a126201ece84807fad65f80fbed1204ac857911c1650d467bab372c3aa766a414f4e680a\"}]}', '{\"signed\":{\"_type\":\"snapshot\",\"spec_version\":\"1.0\",\"version\":81,\"expires\":\"2026-05-16T11:38:10Z\",\"meta\":{\"targets.json\":{\"length\":6288,\"hashes\":{\"sha512\":\"d155ef869baebbaa9bd1b9e551f7f5ad364a964564431c355c3d68d8dfe44d89e7a9702fd9b4c26f5f5249e7cefa1807c5ec875c2a066b6000cb51cbc6d33247\"},\"version\":72}}},\"signatures\":[{\"keyid\":\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"sig\":\"69853bc982344572a0f26e512f7f9427aafd6f0d6f9bb01af593c728c498fa4708db9ea5d1a82d57979941a06021102b0eb61354414162285abe9bce1f4b2000\"}]}', '{\"signed\":{\"_type\":\"timestamp\",\"spec_version\":\"1.0\",\"version\":805,\"expires\":\"2025-10-26T01:04:49Z\",\"meta\":{\"snapshot.json\":{\"length\":531,\"hashes\":{\"sha512\":\"8f659b6575806b78dd83108f7949756ed6d320147348e2354433e626301861221ad24122b124877960aaf0e49b34d61611299f1bb2d263773b163c3ec4b1264a\"},\"version\":81}}},\"signatures\":[{\"keyid\":\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\",\"sig\":\"82f267e3483217022c1d774176fc749aab88a11953d2f903466590c01a1c6e75546a2edbb182542a6fa5c5493d24b6d9bc0c4f4296d3879020cb1debfeb75e0e\"}]}', NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_categories`
--


DROP TABLE IF EXISTS `#__easystore_categories`;
CREATE TABLE `#__easystore_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `is_gift_card` tinyint NOT NULL DEFAULT '0',
  `is_uncategorised` tinyint NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`(100)),
  KEY `idx_title_description` (`title`(100),`description`(100)),
  KEY `idx_publish_access` (`published`,`access`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100)),
  KEY `idx_language` (`language`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_image` (`image`(100))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_categories`
--


INSERT INTO `#__easystore_categories` (`id`, `asset_id`, `title`, `alias`, `description`, `parent_id`, `is_gift_card`, `is_uncategorised`, `lft`, `rgt`, `level`, `image`, `path`, `published`, `access`, `ordering`, `language`, `checked_out`, `checked_out_time`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(1, 0, 'ROOT', 'root', NULL, 0, 0, 0, 0, 13, 0, NULL, '', 1, 0, 0, '*', NULL, NULL, '2025-01-13 08:27:54', NULL, '2025-01-13 08:27:54', NULL),
(2, 123, 'Computer & Laptop', 'computer-laptop', NULL, 1, 0, 0, 1, 2, 1, '', 'computer-laptop', 1, 1, 0, '*', NULL, NULL, '2025-01-13 08:29:10', 752, '2025-01-13 08:29:10', 752),
(3, 129, 'Mobile & Gadget', 'mobile-gadget', '', 1, 0, 0, 3, 4, 1, '', 'mobile-gadget', 1, 1, 0, '*', NULL, NULL, '2025-01-13 10:30:39', 752, '2025-01-13 10:30:39', 752),
(4, 130, 'Watches', 'watches', '', 1, 0, 0, 5, 6, 1, '', 'watches', 1, 1, 0, '*', NULL, NULL, '2025-01-13 10:30:50', 752, '2025-01-13 10:30:50', 752),
(5, 131, 'Electronics', 'electronics', '', 1, 0, 0, 7, 8, 1, '', 'electronics', 1, 1, 0, '*', NULL, NULL, '2025-01-13 10:31:01', 752, '2025-01-13 10:31:01', 752),
(6, 132, 'Accessories', 'accessories', '', 1, 0, 0, 9, 10, 1, '', 'accessories', 1, 1, 0, '*', NULL, NULL, '2025-01-13 10:31:19', 752, '2025-01-13 10:31:19', 752),
(7, 133, 'Camera & Lens kit', 'camera-lens-kit', '', 1, 0, 0, 11, 12, 1, '', 'camera-lens-kit', 1, 1, 0, '*', NULL, NULL, '2025-01-13 10:31:59', 752, '2025-01-13 10:31:59', 752);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_tags`
--


DROP TABLE IF EXISTS `#__easystore_tags`;
CREATE TABLE `#__easystore_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title_description` (`title`(100),`description`(100))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_tags`
--


INSERT INTO `#__easystore_tags` (`id`, `asset_id`, `title`, `alias`, `description`, `published`, `access`, `ordering`, `language`, `checked_out`, `checked_out_time`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(1, 159, 'Camera Lens', 'camera-lens', NULL, 1, 1, 0, '*', NULL, NULL, '2025-01-20 10:42:27', 752, '2025-01-20 10:42:27', 752),
(2, 160, 'Electronics', 'electronics', NULL, 1, 1, 0, '*', NULL, NULL, '2025-01-20 10:42:48', 752, '2025-01-20 10:42:48', 752),
(3, 161, 'Gadget', 'gadget', NULL, 1, 1, 0, '*', NULL, NULL, '2025-01-20 10:42:55', 752, '2025-01-20 10:42:55', 752),
(4, 162, 'Mobile', 'mobile', NULL, 1, 1, 0, '*', NULL, NULL, '2025-01-20 10:44:12', 752, '2025-01-20 10:44:12', 752),
(5, 163, 'Watch', 'watch', NULL, 1, 1, 0, '*', NULL, NULL, '2025-01-20 10:44:21', 752, '2025-01-20 10:44:21', 752),
(6, 164, 'Accessories', 'accessories', NULL, 1, 1, 0, '*', NULL, NULL, '2025-01-20 10:44:44', 752, '2025-01-20 10:44:44', 752);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_products`
--


DROP TABLE IF EXISTS `#__easystore_products`;
CREATE TABLE `#__easystore_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `catid` bigint unsigned NOT NULL DEFAULT '0',
  `brand_id` int DEFAULT '0',
  `weight` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dimension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `regular_price` decimal(13,2) DEFAULT NULL,
  `has_sale` tinyint NOT NULL DEFAULT '0',
  `has_variants` tinyint NOT NULL DEFAULT '0',
  `is_taxable` tinyint NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `is_tracking_inventory` tinyint NOT NULL DEFAULT '0',
  `inventory_status` tinyint NOT NULL DEFAULT '0',
  `enable_out_of_stock_sell` tinyint NOT NULL DEFAULT '0',
  `quantity` int NOT NULL DEFAULT '0',
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `additional_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `metatitle` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta title for the page.',
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title_description` (`title`(100),`description`(100)),
  KEY `idx_published` (`published`),
  KEY `idx_has_sale` (`has_sale`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_products`
--


INSERT INTO `#__easystore_products` (`id`, `asset_id`, `title`, `alias`, `description`, `catid`, `brand_id`, `weight`, `unit`, `dimension`, `regular_price`, `has_sale`, `has_variants`, `is_taxable`, `featured`, `is_tracking_inventory`, `inventory_status`, `enable_out_of_stock_sell`, `quantity`, `sku`, `additional_data`, `discount_type`, `discount_value`, `published`, `access`, `ordering`, `language`, `metatitle`, `metadesc`, `metakey`, `metadata`, `checked_out`, `checked_out_time`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(1, 124, 'Canon EOS R5 Mark', 'canon-eos-r5-mark', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 7, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 08:29:10', 752, '2025-01-20 09:01:38', 752),
(2, 134, 'Macbook Pro M2', 'macbook-pro-m2', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 10:32:55', 752, '2025-01-23 10:45:43', 752),
(3, 135, 'FlexiTab Convertible Laptop', 'flexitab-convertible-laptop', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 10:34:55', 752, '2025-01-23 10:45:32', 752),
(4, 136, 'VisionX Ultra Laptop', 'visionx-ultra-laptop', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 10:35:32', 752, '2025-01-23 10:45:12', 752),
(5, 137, 'Samsung S24', 'samsung-s24', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 3, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 10:39:00', 752, '2025-01-23 10:41:48', 752),
(6, 138, 'Oppo F3', 'oppo-f3', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 3, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 10:39:57', 752, '2025-01-23 10:41:34', 752),
(7, 139, 'EchoBeam Speaker', 'echobeam-speaker', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 3, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 10:41:15', 752, '2025-01-23 10:43:19', 752),
(8, 140, 'Canon EOS R5', 'canon-eos-r5-mark-ii', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 7, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 11:19:51', 752, '2025-01-20 09:01:15', 752),
(9, 141, 'Canon EOS R1', 'canon-eos-r1', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 7, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 11:20:17', 752, '2025-01-13 11:24:50', 752),
(10, 142, 'Omega Seamaster Diver', 'omega-seamaster-diver', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 4, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 11:21:12', 752, '2025-01-20 10:46:18', 752),
(11, 143, 'Omega Seamaster', 'omega-seamaster', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 4, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 11:22:10', 752, '2025-01-20 10:46:11', 752),
(12, 144, 'Rolex Oyster Submariner', 'rolex-oyster-submariner', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 4, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 12:39:27', 752, '2025-01-20 10:46:02', 752),
(13, 145, 'Rolex Oyster Perpetual', 'rolex-oyster-perpetual', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 4, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 12:39:51', 752, '2025-01-20 10:45:54', 752),
(14, 146, 'Apple Watch Series 4', 'apple-watch-series-4', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 4, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 12:40:23', 752, '2025-01-22 09:40:30', 752),
(15, 147, 'Fossil Leather Watch', 'fossil-leather-watch', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 4, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-13 12:41:23', 752, '2025-01-20 10:45:35', 752),
(16, 151, 'CANON RF 35', 'canon-rf-35', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 7, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-20 09:02:49', 752, '2025-01-20 09:06:38', 752),
(17, 152, 'Rokinon Lense', 'rokinon-lense', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 7, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-20 09:07:18', 752, '2025-01-20 09:07:45', 752),
(18, 153, 'Canon EF-S 18', 'canon-ef-s-18', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 7, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-20 09:08:20', 752, '2025-01-20 09:08:44', 752),
(19, 154, 'PlayStation 5', 'playstation-5', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 5, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-20 09:10:08', 752, '2025-01-20 09:13:14', 752),
(21, 156, 'PlayStation', 'playstation', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 5, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-20 09:14:18', 752, '2025-01-20 09:15:41', 752),
(22, 157, 'Nintendo', 'nintendo', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 5, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-20 09:15:48', 752, '2025-01-20 09:16:37', 752),
(23, 158, 'SoundSphere Earbuds', 'soundsphere-earbuds', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 3, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-20 09:31:07', 752, '2025-01-23 10:43:10', 752),
(24, 166, 'ProTower G500 Desktop PC', 'protower-g500-desktop-pc', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:23:59', 752, '2025-01-23 10:45:01', 752),
(25, 167, 'M4 Portable Mini PC', 'm4-portable-mini-pc', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:24:45', 752, '2025-01-23 10:44:45', 752),
(26, 168, 'ThunderCore Gaming Laptop', 'thundercore-gaming-laptop', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:25:41', 752, '2025-01-23 10:44:32', 752),
(27, 169, 'Ipad Pro M2', 'ipad-pro-m2', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:26:20', 752, '2025-01-23 10:44:11', 752),
(28, 170, 'Iphone 16 PRO', 'iphone-16-pro', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 3, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:31:50', 752, '2025-01-23 10:40:46', 752),
(29, 171, 'Sony New gen Mini', 'sony-new-gen-mini', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 5, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:41:18', 752, '2025-01-22 09:44:41', 752),
(30, 172, 'Dji Drone Remote', 'dji-drone-remote', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 5, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:44:57', 752, '2025-01-22 09:45:20', 752),
(31, 173, 'Xbox 360 v2', 'nintendo-2', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 5, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:46:18', 752, '2025-01-22 09:47:44', 752),
(32, 174, 'Canon PixelPro X100', 'canon-pixelpro-x100', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 6, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:48:01', 752, '2025-01-22 09:48:43', 752),
(33, 175, 'Fujifilm SnapFlex Z7', 'fujifilm-snapflex-z7', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 6, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:48:59', 752, '2025-01-22 09:49:24', 752),
(34, 176, 'PrimeVision 50mm f/1.4', 'primevision-50mm-f-1-4', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 6, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:49:30', 752, '2025-01-22 09:51:19', 752),
(35, 177, 'Acer Chromebook', 'acer-chromebook', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 6, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-22 09:51:40', 752, '2025-01-22 09:52:04', 752),
(36, 179, 'Xbox Controller', 'xbox-controller', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 3, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-23 10:38:32', 752, '2025-01-23 10:40:16', 752),
(37, 180, 'Chromebook', 'chromebook', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-23 10:48:28', 752, '2025-01-23 10:50:41', 752),
(38, 181, 'VisionEdge 8K', 'visionedge-8k', '<p>The Nikon ProCapture X100 is a DSLR designed for photographers who demand exceptional performance and versatility. Built with Nikon\'s renowned precision and cutting-edge technology.</p>', 2, 0, '0', NULL, '', '0.00', 1, 1, 1, 0, 1, 0, 0, 0, '', '[{\"title\":\"Features\",\"values\":[{\"key\":\"Feature\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"Feature\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"Feature\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"Feature\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"Feature\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"Feature\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"Feature\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'percent', '5.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-01-23 10:50:47', 752, '2025-01-23 10:51:38', 752),
(40, 210, 'Wireless earbuds', 'wireless-earbuds', '<p>The Wireless earbuds designed for photographers who demand exceptional performance and versatility.</p>', 3, 0, '0', NULL, '', '399.00', 1, 0, 1, 0, 0, 1, 0, 0, 'meag-wireless', '[{\"title\":\"Features\",\"values\":[{\"key\":\"\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'amount', '100.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-02-19 06:36:08', 752, '2025-02-19 06:50:00', 752),
(41, 211, 'DJI Mini 4 Pro', 'dji-mini-4-pro', '<p>DJI Mini 4 Pro is our most advanced mini-camera drone to date. [4] It integrates powerful imaging capabilities, omnidirectional obstacle sensing, ActiveTrack 360°</p>', 5, 0, '0', NULL, '', '999.00', 1, 0, 1, 0, 0, 1, 0, 0, 'mega-dji', '[{\"title\":\"Features\",\"values\":[{\"key\":\"\",\"value\":\"Built with high-quality materials to withstand daily wear and tear, ensuring longevity and reliability.\"},{\"key\":\"\",\"value\":\"Thoughtfully designed to fit comfortably in your hand, reducing strain during extended use.\"},{\"key\":\"\",\"value\":\"Engineered to consume less power without compromising performance, helping you save on energy bills.\"},{\"key\":\"\",\"value\":\"Intuitive controls and a clear display make it simple to use, even for beginners.\"},{\"key\":\"\",\"value\":\"Sleek and lightweight design makes it easy to carry and store, perfect for on-the-go use.\"},{\"key\":\"\",\"value\":\"Equipped with advanced technology to deliver consistent and efficient performance.\"},{\"key\":\"\",\"value\":\"Multi-purpose features allow it to adapt to different tasks and requirements, providing great value.\"}],\"isCollapsed\":true,\"isLatest\":false}]', 'amount', '100.00', 1, 1, 0, '*', '', '', '', '{\"robots\":\"\"}', NULL, NULL, '2025-02-19 06:43:08', 752, '2025-02-19 06:51:17', 752);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_tag_map`
--


DROP TABLE IF EXISTS `#__easystore_product_tag_map`;
CREATE TABLE `#__easystore_product_tag_map` (
  `product_id` bigint unsigned NOT NULL,
  `tag_id` bigint unsigned NOT NULL,
  KEY `idx_product_tag` (`product_id`,`tag_id`),
  KEY `tag_id` (`tag_id`),
  CONSTRAINT `#__easystore_product_tag_map_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_product_tag_map_ibfk_2` FOREIGN KEY (`tag_id`) REFERENCES `#__easystore_tags` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_product_tag_map`
--


INSERT INTO `#__easystore_product_tag_map` (`product_id`, `tag_id`) VALUES 
(10, 5),
(10, 6),
(11, 5),
(11, 6),
(12, 5),
(12, 6),
(13, 5),
(13, 6),
(14, 5),
(14, 6),
(15, 5),
(15, 6);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_media`
--


DROP TABLE IF EXISTS `#__easystore_media`;
CREATE TABLE `#__easystore_media` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'image',
  `is_featured` tinyint DEFAULT '0',
  `width` int DEFAULT NULL,
  `height` int DEFAULT NULL,
  `src` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_product_id` (`product_id`),
  CONSTRAINT `fk_product` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_media`
--


INSERT INTO `#__easystore_media` (`id`, `product_id`, `name`, `type`, `is_featured`, `width`, `height`, `src`, `alt_text`, `ordering`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(8, 8, 'product_8_6784f6d79fdc9.jpg', 'image', 1, NULL, NULL, 'images/easystore/product-8/product_8_6784f6d79fdc9.jpg', 'product_8_6784f6d79fdc9.jpg', 0, '2025-01-13 11:19:51', NULL, '2025-01-13 17:19:51', NULL),
(9, 9, 'product_9_6784f6f1a5141.jpg', 'image', 0, NULL, NULL, 'images/easystore/product-9/product_9_6784f6f1a5141.jpg', 'product_9_6784f6f1a5141.jpg', 2, '2025-01-13 11:20:17', NULL, '2025-01-13 17:20:17', NULL),
(12, 9, 'product-112.jpg', 'image', 1, 474, 474, 'images/easystore/product-9/product-112.jpg', 'product-112.jpg', 1, '2025-01-13 11:24:46', 752, '2025-01-13 17:24:46', 752),
(18, 12, 'product-211.jpg', 'image', 0, 474, 474, 'images/easystore/product-12/product-211.jpg', 'product-211.jpg', 2, '2025-01-13 12:45:06', 752, '2025-01-13 18:45:06', 752),
(19, 13, 'product-211.jpg', 'image', 0, 474, 474, 'images/easystore/product-13/product-211.jpg', 'product-211.jpg', 2, '2025-01-13 12:45:22', 752, '2025-01-13 18:45:22', 752),
(21, 15, 'product-211.jpg', 'image', 1, 474, 474, 'images/easystore/product-15/product-211.jpg', 'product-211.jpg', 1, '2025-01-13 12:46:03', 752, '2025-01-13 18:46:02', 752),
(23, 13, 'product-113.jpg', 'image', 1, 474, 474, 'images/easystore/product-13/product-113.jpg', 'product-113.jpg', 1, '2025-01-17 11:12:07', 752, '2025-01-17 17:12:07', 752),
(24, 12, 'product-115.jpg', 'image', 1, 474, 474, 'images/easystore/product-12/product-115.jpg', 'product-115.jpg', 1, '2025-01-17 11:12:50', 752, '2025-01-17 17:12:50', 752),
(25, 11, 'product-215.jpg', 'image', 1, 474, 474, 'images/easystore/product-11/product-215.jpg', 'product-215.jpg', 1, '2025-01-17 11:24:07', 752, '2025-01-17 17:24:07', 752),
(26, 11, 'product-216.jpg', 'image', 0, 474, 474, 'images/easystore/product-11/product-216.jpg', 'product-216.jpg', 2, '2025-01-17 11:24:13', 752, '2025-01-17 17:24:13', 752),
(27, 10, 'product-216.jpg', 'image', 1, 474, 474, 'images/easystore/product-10/product-216.jpg', 'product-216.jpg', 1, '2025-01-17 11:26:50', 752, '2025-01-17 17:26:50', 752),
(28, 10, 'product-215.jpg', 'image', 0, 474, 474, 'images/easystore/product-10/product-215.jpg', 'product-215.jpg', 2, '2025-01-17 11:26:53', 752, '2025-01-17 17:26:53', 752),
(31, 1, 'product-133.jpg', 'image', 1, 474, 474, 'images/easystore/product-1/product-133.jpg', 'product-133.jpg', 1, '2025-01-20 09:01:34', 752, '2025-01-20 15:01:34', 752),
(32, 1, 'product-132.jpg', 'image', 0, 474, 474, 'images/easystore/product-1/product-132.jpg', 'product-132.jpg', 2, '2025-01-20 09:01:37', 752, '2025-01-20 15:01:37', 752),
(35, 16, 'product-134.jpg', 'image', 1, 474, 474, 'images/easystore/product-16/product-134.jpg', 'product-134.jpg', 1, '2025-01-20 09:06:33', 752, '2025-01-20 15:06:33', 752),
(36, 16, 'product-135.jpg', 'image', 0, 474, 474, 'images/easystore/product-16/product-135.jpg', 'product-135.jpg', 2, '2025-01-20 09:06:36', 752, '2025-01-20 15:06:36', 752),
(39, 17, 'product-136.jpg', 'image', 1, 474, 474, 'images/easystore/product-17/product-136.jpg', 'product-136.jpg', 1, '2025-01-20 09:07:41', 752, '2025-01-20 15:07:41', 752),
(40, 17, 'product-135.jpg', 'image', 0, 474, 474, 'images/easystore/product-17/product-135.jpg', 'product-135.jpg', 2, '2025-01-20 09:07:44', 752, '2025-01-20 15:07:44', 752),
(43, 18, 'product-137.jpg', 'image', 1, 474, 474, 'images/easystore/product-18/product-137.jpg', 'product-137.jpg', 1, '2025-01-20 09:08:40', 752, '2025-01-20 15:08:40', 752),
(44, 18, 'product-139.jpg', 'image', 0, 474, 474, 'images/easystore/product-18/product-139.jpg', 'product-139.jpg', 2, '2025-01-20 09:08:42', 752, '2025-01-20 15:08:42', 752),
(47, 19, 'product-141.jpg', 'image', 1, 474, 474, 'images/easystore/product-19/product-141.jpg', 'product-141.jpg', 1, '2025-01-20 09:13:07', 752, '2025-01-20 15:13:07', 752),
(48, 19, 'product-142.jpg', 'image', 0, 474, 474, 'images/easystore/product-19/product-142.jpg', 'product-142.jpg', 2, '2025-01-20 09:13:11', 752, '2025-01-20 15:13:11', 752),
(53, 21, 'product-143.jpg', 'image', 1, 474, 474, 'images/easystore/product-21/product-143.jpg', 'product-143.jpg', 1, '2025-01-20 09:15:35', 752, '2025-01-20 15:15:35', 752),
(54, 21, 'product-144.jpg', 'image', 0, 474, 474, 'images/easystore/product-21/product-144.jpg', 'product-144.jpg', 2, '2025-01-20 09:15:35', 752, '2025-01-20 15:15:35', 752),
(57, 22, 'product-145.jpg', 'image', 1, 474, 474, 'images/easystore/product-22/product-145.jpg', 'product-145.jpg', 1, '2025-01-20 09:16:36', 752, '2025-01-20 15:16:36', 752),
(58, 22, 'product-146.jpg', 'image', 0, 474, 474, 'images/easystore/product-22/product-146.jpg', 'product-146.jpg', 2, '2025-01-20 09:16:36', 752, '2025-01-20 15:16:36', 752),
(71, 4, 'product-183.jpg', 'image', 0, 474, 474, 'images/easystore/product-4/product-183.jpg', 'product-183.jpg', 2, '2025-01-22 09:21:49', 752, '2025-01-22 15:21:49', 752),
(72, 4, 'product-185.jpg', 'image', 1, 474, 474, 'images/easystore/product-4/product-185.jpg', 'product-185.jpg', 1, '2025-01-22 09:21:49', 752, '2025-01-22 15:21:49', 752),
(73, 3, 'product-181.jpg', 'image', 1, 474, 474, 'images/easystore/product-3/product-181.jpg', 'product-181.jpg', 1, '2025-01-22 09:22:24', 752, '2025-01-22 15:22:24', 752),
(74, 3, 'product-182.jpg', 'image', 0, 474, 474, 'images/easystore/product-3/product-182.jpg', 'product-182.jpg', 2, '2025-01-22 09:22:24', 752, '2025-01-22 15:22:24', 752),
(75, 2, 'product-179.jpg', 'image', 1, 474, 474, 'images/easystore/product-2/product-179.jpg', 'product-179.jpg', 1, '2025-01-22 09:23:00', 752, '2025-01-22 15:23:00', 752),
(76, 2, 'product-180.jpg', 'image', 0, 474, 474, 'images/easystore/product-2/product-180.jpg', 'product-180.jpg', 2, '2025-01-22 09:23:00', 752, '2025-01-22 15:23:00', 752),
(79, 24, 'product-176.jpg', 'image', 1, 474, 474, 'images/easystore/product-24/product-176.jpg', 'product-176.jpg', 1, '2025-01-22 09:24:29', 752, '2025-01-22 15:24:29', 752),
(80, 24, 'product-178.jpg', 'image', 0, 474, 474, 'images/easystore/product-24/product-178.jpg', 'product-178.jpg', 2, '2025-01-22 09:24:29', 752, '2025-01-22 15:24:29', 752),
(83, 25, 'product-171.jpg', 'image', 1, 474, 474, 'images/easystore/product-25/product-171.jpg', 'product-171.jpg', 1, '2025-01-22 09:25:28', 752, '2025-01-22 15:25:28', 752),
(84, 25, 'product-186.jpg', 'image', 0, 474, 474, 'images/easystore/product-25/product-186.jpg', 'product-186.jpg', 2, '2025-01-22 09:25:28', 752, '2025-01-22 15:25:28', 752),
(87, 26, 'product-174.jpg', 'image', 1, 474, 474, 'images/easystore/product-26/product-174.jpg', 'product-174.jpg', 1, '2025-01-22 09:26:00', 752, '2025-01-22 15:26:00', 752),
(88, 26, 'product-175.jpg', 'image', 0, 474, 474, 'images/easystore/product-26/product-175.jpg', 'product-175.jpg', 2, '2025-01-22 09:26:00', 752, '2025-01-22 15:26:00', 752),
(91, 27, 'product-172.jpg', 'image', 1, 474, 474, 'images/easystore/product-27/product-172.jpg', 'product-172.jpg', 1, '2025-01-22 09:26:42', 752, '2025-01-22 15:26:42', 752),
(92, 27, 'product-173.jpg', 'image', 0, 474, 474, 'images/easystore/product-27/product-173.jpg', 'product-173.jpg', 2, '2025-01-22 09:26:42', 752, '2025-01-22 15:26:42', 752),
(93, 23, 'product-197.jpg', 'image', 1, 474, 474, 'images/easystore/product-23/product-197.jpg', 'product-197.jpg', 1, '2025-01-22 09:29:49', 752, '2025-01-22 15:29:49', 752),
(94, 23, 'product-198.jpg', 'image', 0, 474, 474, 'images/easystore/product-23/product-198.jpg', 'product-198.jpg', 2, '2025-01-22 09:29:49', 752, '2025-01-22 15:29:49', 752),
(95, 7, 'product-199.jpg', 'image', 1, 474, 474, 'images/easystore/product-7/product-199.jpg', 'product-199.jpg', 1, '2025-01-22 09:30:19', 752, '2025-01-22 15:30:19', 752),
(96, 7, 'product-200.jpg', 'image', 0, 474, 474, 'images/easystore/product-7/product-200.jpg', 'product-200.jpg', 2, '2025-01-22 09:30:19', 752, '2025-01-22 15:30:19', 752),
(99, 5, 'product-195.jpg', 'image', 0, 474, 474, 'images/easystore/product-5/product-195.jpg', 'product-195.jpg', 2, '2025-01-22 09:31:18', 752, '2025-01-22 15:31:18', 752),
(100, 5, 'product-196.jpg', 'image', 1, 474, 474, 'images/easystore/product-5/product-196.jpg', 'product-196.jpg', 1, '2025-01-22 09:31:18', 752, '2025-01-22 15:31:18', 752),
(103, 28, 'product-193.jpg', 'image', 1, 474, 474, 'images/easystore/product-28/product-193.jpg', 'product-193.jpg', 1, '2025-01-22 09:32:23', 752, '2025-01-22 15:32:23', 752),
(104, 28, 'product-194.jpg', 'image', 0, 474, 474, 'images/easystore/product-28/product-194.jpg', 'product-194.jpg', 2, '2025-01-22 09:32:23', 752, '2025-01-22 15:32:23', 752),
(105, 6, 'product-191.jpg', 'image', 1, 474, 474, 'images/easystore/product-6/product-191.jpg', 'product-191.jpg', 1, '2025-01-22 09:32:51', 752, '2025-01-22 15:32:51', 752),
(106, 6, 'product-192.jpg', 'image', 0, 474, 474, 'images/easystore/product-6/product-192.jpg', 'product-192.jpg', 2, '2025-01-22 09:32:51', 752, '2025-01-22 15:32:51', 752),
(107, 14, 'product-210.jpg', 'image', 1, 474, 474, 'images/easystore/product-14/product-210.jpg', 'product-210.jpg', 1, '2025-01-22 09:40:12', 752, '2025-01-22 15:40:12', 752),
(109, 14, 'product-210.jpg', 'image', 0, 474, 474, 'images/easystore/product-14/product-210.jpg', 'product-210.jpg', 2, '2025-01-22 09:40:25', 752, '2025-01-22 15:40:25', 752),
(112, 29, 'product-223.jpg', 'image', 1, 474, 474, 'images/easystore/product-29/product-223.jpg', 'product-223.jpg', 1, '2025-01-22 09:44:38', 752, '2025-01-22 15:44:38', 752),
(113, 29, 'product-224.jpg', 'image', 0, 474, 474, 'images/easystore/product-29/product-224.jpg', 'product-224.jpg', 2, '2025-01-22 09:44:38', 752, '2025-01-22 15:44:38', 752),
(116, 30, 'product-226.jpg', 'image', 1, 474, 474, 'images/easystore/product-30/product-226.jpg', 'product-226.jpg', 1, '2025-01-22 09:45:18', 752, '2025-01-22 15:45:18', 752),
(117, 30, 'product-227.jpg', 'image', 0, 474, 474, 'images/easystore/product-30/product-227.jpg', 'product-227.jpg', 2, '2025-01-22 09:45:18', 752, '2025-01-22 15:45:18', 752),
(120, 31, 'product-350.jpg', 'image', 1, 474, 474, 'images/easystore/product-31/product-350.jpg', 'product-350.jpg', 1, '2025-01-22 09:47:41', 752, '2025-01-22 15:47:41', 752),
(121, 31, 'product-351.jpg', 'image', 0, 474, 474, 'images/easystore/product-31/product-351.jpg', 'product-351.jpg', 2, '2025-01-22 09:47:41', 752, '2025-01-22 15:47:41', 752),
(124, 32, 'product-220.jpg', 'image', 1, 474, 474, 'images/easystore/product-32/product-220.jpg', 'product-220.jpg', 1, '2025-01-22 09:48:40', 752, '2025-01-22 15:48:40', 752),
(125, 32, 'product-232.jpg', 'image', 0, 474, 474, 'images/easystore/product-32/product-232.jpg', 'product-232.jpg', 2, '2025-01-22 09:48:40', 752, '2025-01-22 15:48:40', 752),
(128, 33, 'product-230.jpg', 'image', 1, 474, 474, 'images/easystore/product-33/product-230.jpg', 'product-230.jpg', 1, '2025-01-22 09:49:23', 752, '2025-01-22 15:49:23', 752),
(129, 33, 'product-231.jpg', 'image', 0, 474, 474, 'images/easystore/product-33/product-231.jpg', 'product-231.jpg', 2, '2025-01-22 09:49:23', 752, '2025-01-22 15:49:23', 752),
(132, 34, 'product-228.jpg', 'image', 1, 474, 474, 'images/easystore/product-34/product-228.jpg', 'product-228.jpg', 1, '2025-01-22 09:51:17', 752, '2025-01-22 15:51:17', 752),
(133, 34, 'product-229.jpg', 'image', 0, 474, 474, 'images/easystore/product-34/product-229.jpg', 'product-229.jpg', 2, '2025-01-22 09:51:17', 752, '2025-01-22 15:51:17', 752),
(136, 35, 'group-34837.jpg', 'image', 1, 485, 474, 'images/easystore/product-35/group-34837.jpg', 'group-34837.jpg', 1, '2025-01-22 09:52:02', 752, '2025-01-22 15:52:02', 752),
(137, 35, 'product-225.jpg', 'image', 0, 474, 474, 'images/easystore/product-35/product-225.jpg', 'product-225.jpg', 2, '2025-01-22 09:52:02', 752, '2025-01-22 15:52:02', 752),
(140, 36, 'product-310.jpg', 'image', 1, 474, 474, 'images/easystore/product-36/product-310.jpg', 'product-310.jpg', 1, '2025-01-23 10:40:02', 752, '2025-01-23 16:40:02', 752),
(141, 36, 'product-311.jpg', 'image', 0, 474, 474, 'images/easystore/product-36/product-311.jpg', 'product-311.jpg', 2, '2025-01-23 10:40:02', 752, '2025-01-23 16:40:02', 752),
(144, 37, 'product-213.jpg', 'image', 1, 485, 474, 'images/easystore/product-37/product-213.jpg', 'product-213.jpg', 1, '2025-01-23 10:49:37', 752, '2025-01-23 16:49:37', 752),
(145, 37, 'product-214.jpg', 'image', 0, 474, 474, 'images/easystore/product-37/product-214.jpg', 'product-214.jpg', 2, '2025-01-23 10:49:37', 752, '2025-01-23 16:49:37', 752),
(148, 38, 'product-215.jpg', 'image', 1, 474, 474, 'images/easystore/product-38/product-215.jpg', 'product-215.jpg', 1, '2025-01-23 10:51:25', 752, '2025-01-23 16:51:25', 752),
(149, 38, 'product-216.jpg', 'image', 0, 474, 474, 'images/easystore/product-38/product-216.jpg', 'product-216.jpg', 2, '2025-01-23 10:51:25', 752, '2025-01-23 16:51:25', 752),
(160, 40, 'frame-627368.jpg', 'image', 1, 474, 474, 'images/easystore/product-40/frame-627368.jpg', 'frame-627368.jpg', 1, '2025-02-19 06:36:08', 752, '2025-02-19 12:36:08', 752),
(161, 40, 'frame-627369.jpg', 'image', 0, 474, 474, 'images/easystore/product-40/frame-627369.jpg', 'frame-627369.jpg', 2, '2025-02-19 06:36:08', 752, '2025-02-19 12:36:08', 752),
(162, 41, 'frame-10003jpg.jpg', 'image', 1, 474, 475, 'images/easystore/product-41/frame-10003jpg.jpg', 'frame-10003jpg.jpg', 1, '2025-02-19 06:43:08', 752, '2025-02-19 12:43:08', 752),
(163, 41, 'group-34836.jpg', 'image', 0, 474, 474, 'images/easystore/product-41/group-34836.jpg', 'group-34836.jpg', 2, '2025-02-19 06:43:08', 752, '2025-02-19 12:43:08', 752),
(164, 40, 'frame-100059.jpg', 'image', 0, 474, 475, 'images/easystore/product-40/frame-100059.jpg', 'frame-100059.jpg', 3, '2025-02-19 06:47:07', 752, '2025-02-19 12:47:07', 752);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_temp_media`
--


DROP TABLE IF EXISTS `#__easystore_temp_media`;
CREATE TABLE `#__easystore_temp_media` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'image',
  `is_featured` tinyint DEFAULT '0',
  `width` int DEFAULT NULL,
  `height` int DEFAULT NULL,
  `src` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ordering` int NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_is_featured` (`client_id`,`is_featured`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_coupons`
--


DROP TABLE IF EXISTS `#__easystore_coupons`;
CREATE TABLE `#__easystore_coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `coupon_category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'discount' COMMENT 'discount, free_shipping, sale_price, buy_get_free',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) NOT NULL DEFAULT '0.00',
  `sale_value` decimal(13,2) NOT NULL DEFAULT '0.00',
  `applies_to` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'all_products' COMMENT 'all_products, specific_products, specific_categories',
  `country_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all' COMMENT 'all, selected',
  `selected_countries` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `applies_to_x` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'all_products' COMMENT 'all_products, specific_products, specific_categories',
  `buy_x` int DEFAULT NULL,
  `applies_to_y` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'all_products' COMMENT 'all_products, specific_products, specific_categories',
  `get_y` int DEFAULT NULL,
  `coupon_limit_status` tinyint(1) NOT NULL DEFAULT '0',
  `coupon_limit_value` int DEFAULT NULL,
  `usage_limit_status` tinyint(1) NOT NULL DEFAULT '0',
  `usage_limit_value` int DEFAULT NULL,
  `purchase_requirements` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'no_minimum' COMMENT 'no_minimum, minimum_purchase, minimum_quantity',
  `purchase_requirements_value` decimal(13,2) DEFAULT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `has_date` tinyint NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`(100)),
  KEY `idx_title` (`title`(100)),
  KEY `idx_code` (`code`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_coupon_category_map`
--


DROP TABLE IF EXISTS `#__easystore_coupon_category_map`;
CREATE TABLE `#__easystore_coupon_category_map` (
  `coupon_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `buy_get_offer` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  KEY `idx_coupon_category` (`coupon_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_coupon_product_map`
--


DROP TABLE IF EXISTS `#__easystore_coupon_product_map`;
CREATE TABLE `#__easystore_coupon_product_map` (
  `coupon_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `buy_get_offer` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  KEY `idx_coupon_product` (`coupon_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_wishlist`
--


DROP TABLE IF EXISTS `#__easystore_wishlist`;
CREATE TABLE `#__easystore_wishlist` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_product_wish` (`user_id`,`product_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_wishlist_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `#__users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_wishlist_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_reviews`
--


DROP TABLE IF EXISTS `#__easystore_reviews`;
CREATE TABLE `#__easystore_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `product_id` bigint unsigned NOT NULL,
  `rating` int unsigned NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `review` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `access` int unsigned NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_reviews_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_options`
--


DROP TABLE IF EXISTS `#__easystore_product_options`;
CREATE TABLE `#__easystore_product_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'color',
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`,`name`(100)),
  KEY `idx_product_id` (`product_id`),
  KEY `idx_name` (`name`(100)),
  CONSTRAINT `#__easystore_product_options_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb3;


--
-- Dumping data for table `#__easystore_product_options`
--


INSERT INTO `#__easystore_product_options` (`id`, `product_id`, `name`, `type`, `ordering`) VALUES 
(1, 1, 'Colors', 'color', 1),
(2, 2, 'Colors', 'color', 1),
(3, 3, 'Colors', 'color', 1),
(4, 4, 'Colors', 'color', 1),
(5, 5, 'Colors', 'color', 1),
(6, 6, 'Colors', 'color', 1),
(7, 7, 'Colors', 'color', 1),
(8, 8, 'Colors', 'color', 1),
(9, 9, 'Colors', 'color', 1),
(10, 10, 'Colors', 'color', 1),
(11, 11, 'Colors', 'color', 1),
(12, 12, 'Colors', 'color', 1),
(13, 13, 'Colors', 'color', 1),
(14, 14, 'Colors', 'color', 1),
(15, 15, 'Colors', 'color', 1),
(16, 16, 'Colors', 'color', 1),
(17, 17, 'Colors', 'color', 1),
(18, 18, 'Colors', 'color', 1),
(19, 19, 'Colors', 'color', 1),
(21, 21, 'Colors', 'color', 1),
(22, 22, 'Colors', 'color', 1),
(23, 23, 'Colors', 'color', 1),
(24, 24, 'Colors', 'color', 1),
(25, 25, 'Colors', 'color', 1),
(26, 26, 'Colors', 'color', 1),
(27, 27, 'Colors', 'color', 1),
(28, 28, 'Colors', 'color', 1),
(29, 29, 'Colors', 'color', 1),
(30, 30, 'Colors', 'color', 1),
(31, 31, 'Colors', 'color', 1),
(32, 32, 'Colors', 'color', 1),
(33, 33, 'Colors', 'color', 1),
(34, 34, 'Colors', 'color', 1),
(35, 35, 'Colors', 'color', 1),
(36, 36, 'Colors', 'color', 1),
(37, 37, 'Colors', 'color', 1),
(38, 38, 'Colors', 'color', 1);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_option_values`
--


DROP TABLE IF EXISTS `#__easystore_product_option_values`;
CREATE TABLE `#__easystore_product_option_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `option_id` bigint unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `color` varchar(255) DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`,`option_id`,`name`(100)),
  KEY `idx_product_id` (`product_id`),
  KEY `idx_name` (`name`(100)),
  KEY `option_id` (`option_id`),
  CONSTRAINT `#__easystore_product_option_values_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_product_option_values_ibfk_2` FOREIGN KEY (`option_id`) REFERENCES `#__easystore_product_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb3;


--
-- Dumping data for table `#__easystore_product_option_values`
--


INSERT INTO `#__easystore_product_option_values` (`id`, `product_id`, `option_id`, `name`, `color`, `ordering`) VALUES 
(1, 1, 1, 'Black', '#000000', 1),
(2, 1, 1, 'Gray', '#97999a', 2),
(3, 2, 2, 'Black', '#000000', 1),
(4, 2, 2, 'Gray', '#97999a', 2),
(5, 3, 3, 'Black', '#000000', 1),
(6, 3, 3, 'Gray', '#97999a', 2),
(7, 4, 4, 'Black', '#000000', 1),
(8, 4, 4, 'Gray', '#97999a', 2),
(9, 5, 5, 'Black', '#000000', 1),
(10, 5, 5, 'Gray', '#97999a', 2),
(11, 6, 6, 'Black', '#000000', 1),
(12, 6, 6, 'Gray', '#97999a', 2),
(13, 7, 7, 'Black', '#000000', 1),
(14, 7, 7, 'Gray', '#97999a', 2),
(15, 8, 8, 'Black', '#000000', 1),
(16, 8, 8, 'Gray', '#97999a', 2),
(17, 9, 9, 'Black', '#000000', 1),
(18, 9, 9, 'Gray', '#97999a', 2),
(19, 10, 10, 'Black', '#000000', 1),
(20, 10, 10, 'Gray', '#97999a', 2),
(21, 11, 11, 'Black', '#000000', 1),
(22, 11, 11, 'Gray', '#97999a', 2),
(23, 12, 12, 'Black', '#000000', 1),
(24, 12, 12, 'Gray', '#97999a', 2),
(25, 13, 13, 'Black', '#000000', 1),
(26, 13, 13, 'Gray', '#97999a', 2),
(27, 14, 14, 'Black', '#000000', 1),
(28, 14, 14, 'Gray', '#97999a', 2),
(29, 15, 15, 'Black', '#000000', 1),
(30, 15, 15, 'Gray', '#97999a', 2),
(31, 16, 16, 'Black', '#000000', 1),
(32, 16, 16, 'Gray', '#97999a', 2),
(33, 17, 17, 'Black', '#000000', 1),
(34, 17, 17, 'Gray', '#97999a', 2),
(35, 18, 18, 'Black', '#000000', 1),
(36, 18, 18, 'Gray', '#97999a', 2),
(37, 19, 19, 'Black', '#000000', 1),
(38, 19, 19, 'Gray', '#97999a', 2),
(41, 21, 21, 'Black', '#000000', 1),
(42, 21, 21, 'Gray', '#97999a', 2),
(43, 22, 22, 'Black', '#000000', 1),
(44, 22, 22, 'Gray', '#97999a', 2),
(45, 23, 23, 'Black', '#000000', 1),
(46, 23, 23, 'Gray', '#97999a', 2),
(47, 24, 24, 'Black', '#000000', 1),
(48, 24, 24, 'Gray', '#97999a', 2),
(49, 25, 25, 'Black', '#000000', 1),
(50, 25, 25, 'Gray', '#97999a', 2),
(51, 26, 26, 'Black', '#000000', 1),
(52, 26, 26, 'Gray', '#97999a', 2),
(53, 27, 27, 'Black', '#000000', 1),
(54, 27, 27, 'Gray', '#97999a', 2),
(55, 28, 28, 'Black', '#000000', 1),
(56, 28, 28, 'Gray', '#97999a', 2),
(57, 29, 29, 'Black', '#000000', 1),
(58, 29, 29, 'Gray', '#97999a', 2),
(59, 30, 30, 'Black', '#000000', 1),
(60, 30, 30, 'Gray', '#97999a', 2),
(61, 31, 31, 'Black', '#000000', 1),
(62, 31, 31, 'Gray', '#97999a', 2),
(63, 32, 32, 'Black', '#000000', 1),
(64, 32, 32, 'Gray', '#97999a', 2),
(65, 33, 33, 'Black', '#000000', 1),
(66, 33, 33, 'Gray', '#97999a', 2),
(67, 34, 34, 'Black', '#000000', 1),
(68, 34, 34, 'Gray', '#97999a', 2),
(69, 35, 35, 'Black', '#000000', 1),
(70, 35, 35, 'Gray', '#97999a', 2),
(71, 36, 36, 'Black', '#000000', 1),
(72, 36, 36, 'Gray', '#97999a', 2),
(73, 37, 37, 'Black', '#000000', 1),
(74, 37, 37, 'Gray', '#97999a', 2),
(75, 38, 38, 'Black', '#000000', 1),
(76, 38, 38, 'Gray', '#97999a', 2);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_skus`
--


DROP TABLE IF EXISTS `#__easystore_product_skus`;
CREATE TABLE `#__easystore_product_skus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint unsigned NOT NULL,
  `image_id` bigint unsigned DEFAULT NULL,
  `combination_name` varchar(500) NOT NULL,
  `combination_value` varchar(500) NOT NULL,
  `price` decimal(13,2) DEFAULT NULL,
  `inventory_status` tinyint NOT NULL DEFAULT '0',
  `inventory_amount` int DEFAULT NULL,
  `is_taxable` tinyint NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `sku` varchar(100) NOT NULL DEFAULT '',
  `weight` varchar(100) NOT NULL DEFAULT '',
  `unit` varchar(10) DEFAULT NULL,
  `visibility` tinyint NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`,`combination_value`(100)),
  KEY `price` (`price`),
  CONSTRAINT `#__easystore_product_skus_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb3;


--
-- Dumping data for table `#__easystore_product_skus`
--


INSERT INTO `#__easystore_product_skus` (`id`, `product_id`, `image_id`, `combination_name`, `combination_value`, `price`, `inventory_status`, `inventory_amount`, `is_taxable`, `ordering`, `sku`, `weight`, `unit`, `visibility`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(1, 1, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 08:29:10', 752, '2025-01-20 09:01:38', NULL),
(2, 1, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 08:29:10', 752, '2025-01-20 09:01:38', NULL),
(3, 2, NULL, 'Black', 'Black', '1300.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 10:32:55', 752, '2025-01-23 10:45:43', NULL),
(4, 2, NULL, 'Gray', 'Gray', '1300.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 10:32:55', 752, '2025-01-23 10:45:43', NULL),
(5, 3, NULL, 'Black', 'Black', '400.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 10:34:55', 752, '2025-01-23 10:45:32', NULL),
(6, 3, NULL, 'Gray', 'Gray', '400.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 10:34:55', 752, '2025-01-23 10:45:32', NULL),
(7, 4, NULL, 'Black', 'Black', '890.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 10:35:32', 752, '2025-01-23 10:45:12', NULL),
(8, 4, NULL, 'Gray', 'Gray', '890.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 10:35:32', 752, '2025-01-23 10:45:12', NULL),
(9, 5, NULL, 'Black', 'Black', '799.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 10:39:00', 752, '2025-01-23 10:41:48', NULL),
(10, 5, NULL, 'Gray', 'Gray', '799.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 10:39:00', 752, '2025-01-23 10:41:48', NULL),
(11, 6, NULL, 'Black', 'Black', '300.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 10:39:57', 752, '2025-01-23 10:41:34', NULL),
(12, 6, NULL, 'Gray', 'Gray', '300.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 10:39:57', 752, '2025-01-23 10:41:34', NULL),
(13, 7, NULL, 'Black', 'Black', '129.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 10:41:15', 752, '2025-01-23 10:43:19', NULL),
(14, 7, NULL, 'Gray', 'Gray', '139.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 10:41:15', 752, '2025-01-23 10:43:19', NULL),
(15, 8, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 11:19:51', 752, '2025-01-20 09:01:15', NULL),
(16, 8, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 11:19:51', 752, '2025-01-20 09:01:15', NULL),
(17, 9, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 11:20:17', 752, '2025-01-13 11:24:50', NULL),
(18, 9, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 11:20:17', 752, '2025-01-13 11:24:50', NULL),
(19, 10, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 11:21:12', 752, '2025-01-20 10:46:18', NULL),
(20, 10, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 11:21:12', 752, '2025-01-20 10:46:18', NULL),
(21, 11, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 11:22:10', 752, '2025-01-20 10:46:11', NULL),
(22, 11, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 11:22:10', 752, '2025-01-20 10:46:11', NULL),
(23, 12, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 12:39:27', 752, '2025-01-20 10:46:02', NULL),
(24, 12, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 12:39:27', 752, '2025-01-20 10:46:02', NULL),
(25, 13, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 12:39:51', 752, '2025-01-20 10:45:54', NULL),
(26, 13, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 12:39:51', 752, '2025-01-20 10:45:54', NULL),
(27, 14, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 12:40:23', 752, '2025-01-22 09:40:30', NULL),
(28, 14, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 12:40:23', 752, '2025-01-22 09:40:30', NULL),
(29, 15, NULL, 'Black', 'Black', '100.00', 1, 99, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-13 12:41:23', 752, '2025-01-20 10:45:35', NULL),
(30, 15, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-13 12:41:23', 752, '2025-01-20 10:45:35', NULL),
(31, 16, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-20 09:02:49', 752, '2025-01-20 09:06:38', NULL),
(32, 16, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-20 09:02:49', 752, '2025-01-20 09:06:38', NULL),
(33, 17, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-20 09:07:18', 752, '2025-01-20 09:07:45', NULL),
(34, 17, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-20 09:07:18', 752, '2025-01-20 09:07:45', NULL),
(35, 18, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-20 09:08:20', 752, '2025-01-20 09:08:44', NULL),
(36, 18, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-20 09:08:20', 752, '2025-01-20 09:08:44', NULL),
(37, 19, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-20 09:10:08', 752, '2025-01-20 09:13:14', NULL),
(38, 19, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-20 09:10:08', 752, '2025-01-20 09:13:14', NULL),
(41, 21, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-20 09:14:18', 752, '2025-01-20 09:15:41', NULL),
(42, 21, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-20 09:14:18', 752, '2025-01-20 09:15:41', NULL),
(43, 22, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-20 09:15:48', 752, '2025-01-20 09:16:37', NULL),
(44, 22, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-20 09:15:48', 752, '2025-01-20 09:16:37', NULL),
(45, 23, NULL, 'Black', 'Black', '89.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-20 09:31:07', 752, '2025-01-23 10:43:10', NULL),
(46, 23, NULL, 'Gray', 'Gray', '99.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-20 09:31:07', 752, '2025-01-23 10:43:10', NULL),
(47, 24, NULL, 'Black', 'Black', '2500.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:23:59', 752, '2025-01-23 10:45:01', NULL),
(48, 24, NULL, 'Gray', 'Gray', '2500.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:23:59', 752, '2025-01-23 10:45:01', NULL),
(49, 25, NULL, 'Black', 'Black', '699.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:24:45', 752, '2025-01-23 10:44:45', NULL),
(50, 25, NULL, 'Gray', 'Gray', '699.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:24:45', 752, '2025-01-23 10:44:45', NULL),
(51, 26, NULL, 'Black', 'Black', '1400.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:25:41', 752, '2025-01-23 10:44:32', NULL),
(52, 26, NULL, 'Gray', 'Gray', '1400.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:25:41', 752, '2025-01-23 10:44:32', NULL),
(53, 27, NULL, 'Black', 'Black', '600.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:26:20', 752, '2025-01-23 10:44:11', NULL),
(54, 27, NULL, 'Gray', 'Gray', '600.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:26:20', 752, '2025-01-23 10:44:11', NULL),
(55, 28, NULL, 'Black', 'Black', '499.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:31:50', 752, '2025-01-23 10:40:46', NULL),
(56, 28, NULL, 'Gray', 'Gray', '599.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:31:50', 752, '2025-01-23 10:40:46', NULL),
(57, 29, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:41:18', 752, '2025-01-22 09:44:41', NULL),
(58, 29, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:41:18', 752, '2025-01-22 09:44:41', NULL),
(59, 30, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:44:57', 752, '2025-01-22 09:45:20', NULL),
(60, 30, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:44:57', 752, '2025-01-22 09:45:20', NULL),
(61, 31, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:46:18', 752, '2025-01-22 09:47:44', NULL),
(62, 31, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:46:18', 752, '2025-01-22 09:47:44', NULL),
(63, 32, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:48:01', 752, '2025-01-22 09:48:43', NULL),
(64, 32, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:48:01', 752, '2025-01-22 09:48:43', NULL),
(65, 33, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:48:59', 752, '2025-01-22 09:49:24', NULL),
(66, 33, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:48:59', 752, '2025-01-22 09:49:24', NULL),
(67, 34, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:49:30', 752, '2025-01-22 09:51:19', NULL),
(68, 34, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:49:30', 752, '2025-01-22 09:51:19', NULL),
(69, 35, NULL, 'Black', 'Black', '100.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-22 09:51:40', 752, '2025-01-22 09:52:04', NULL),
(70, 35, NULL, 'Gray', 'Gray', '100.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-22 09:51:40', 752, '2025-01-22 09:52:04', NULL),
(71, 36, NULL, 'Black', 'Black', '50.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-23 10:38:32', 752, '2025-01-23 10:40:16', NULL),
(72, 36, NULL, 'Gray', 'Gray', '60.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-23 10:38:32', 752, '2025-01-23 10:40:16', NULL),
(73, 37, NULL, 'Black', 'Black', '800.00', 1, 99, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-23 10:48:28', 752, '2025-01-23 10:50:41', NULL),
(74, 37, NULL, 'Gray', 'Gray', '800.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-23 10:48:28', 752, '2025-01-23 10:50:41', NULL),
(75, 38, NULL, 'Black', 'Black', '980.00', 1, 100, 1, 1, 'MEGA-1', '', NULL, 1, '2025-01-23 10:50:47', 752, '2025-01-23 10:51:38', NULL),
(76, 38, NULL, 'Gray', 'Gray', '980.00', 1, 100, 1, 2, 'MEGA-3', '', NULL, 1, '2025-01-23 10:50:47', 752, '2025-01-23 10:51:38', NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_coupon_product_sku_map`
--


DROP TABLE IF EXISTS `#__easystore_coupon_product_sku_map`;
CREATE TABLE `#__easystore_coupon_product_sku_map` (
  `coupon_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `sku_id` bigint unsigned NOT NULL,
  KEY `idx_coupon_product_sku` (`coupon_id`,`product_id`,`sku_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_orders`
--


DROP TABLE IF EXISTS `#__easystore_orders`;
CREATE TABLE `#__easystore_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `creation_date` datetime DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `customer_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_information` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `billing_address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unpaid',
  `fulfilment` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unfulfilled',
  `order_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'draft',
  `is_guest_order` tinyint NOT NULL DEFAULT '0',
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) DEFAULT NULL,
  `discount_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_error_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tracking_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_carrier` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  `coupon_category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'discount' COMMENT 'discount, free_shipping, sale_price, buy_get_free',
  `coupon_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_amount` decimal(13,2) DEFAULT '0.00',
  `is_tax_included_in_price` tinyint NOT NULL DEFAULT '1',
  `sale_tax` decimal(13,2) DEFAULT '0.00',
  `shipping_tax` decimal(13,2) DEFAULT '0.00',
  `shipping_tax_rate` decimal(13,2) DEFAULT '0.00',
  `shipping_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_value` decimal(13,2) DEFAULT '0.00',
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_send_shipping_confirmation_email` tinyint NOT NULL DEFAULT '1',
  `published` tinyint NOT NULL DEFAULT '1',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  `order_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_invoice_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_order_payment_status` (`payment_status`),
  KEY `idx_order_fulfillment` (`fulfilment`),
  KEY `idx_order_order_status` (`order_status`),
  KEY `idx_custom_invoice_id` (`custom_invoice_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_order_product_map`
--


DROP TABLE IF EXISTS `#__easystore_order_product_map`;
CREATE TABLE `#__easystore_order_product_map` (
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variant_id` bigint unsigned DEFAULT NULL,
  `discount_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'percent',
  `discount_value` decimal(13,2) DEFAULT NULL,
  `discount_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `price` decimal(13,2) NOT NULL DEFAULT '0.00',
  `cart_item` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  KEY `idx_order_product_variant` (`order_id`,`product_id`,`variant_id`),
  CONSTRAINT `#__easystore_order_product_map_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `#__easystore_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_order_activities`
--


DROP TABLE IF EXISTS `#__easystore_order_activities`;
CREATE TABLE `#__easystore_order_activities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `activity_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'order_created',
  `activity_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  CONSTRAINT `#__easystore_order_activities_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `#__easystore_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_order_refunds`
--


DROP TABLE IF EXISTS `#__easystore_order_refunds`;
CREATE TABLE `#__easystore_order_refunds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `refund_value` decimal(13,2) NOT NULL,
  `refund_reason` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  CONSTRAINT `#__easystore_order_refunds_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `#__easystore_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_users`
--


DROP TABLE IF EXISTS `#__easystore_users`;
CREATE TABLE `#__easystore_users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` int NOT NULL,
  `user_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'customer',
  `phone` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_information` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `shipping_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_billing_and_shipping_address_same` tinyint NOT NULL DEFAULT '0',
  `billing_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_phone` (`phone`),
  CONSTRAINT `#__easystore_users_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `#__users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_cart`
--


DROP TABLE IF EXISTS `#__easystore_cart`;
CREATE TABLE `#__easystore_cart` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned DEFAULT NULL,
  `status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Possible values (cart, information, shipping, payment)',
  `token` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `shipping_method` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'discount' COMMENT 'discount, free_shipping, sale_price, buy_get_free',
  `coupon_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_amount` decimal(13,2) NOT NULL DEFAULT '0.00',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_cart`
--


INSERT INTO `#__easystore_cart` (`id`, `customer_id`, `status`, `token`, `shipping_method`, `payment_method`, `coupon_category`, `coupon_code`, `coupon_type`, `coupon_amount`, `created`, `created_by`, `modified`, `modified_by`) VALUES 
(2, NULL, NULL, '6e765929-a10c-435f-b57c-a5da46e0dd9e', NULL, NULL, 'discount', NULL, NULL, '0.00', '2025-02-12 11:55:59', 0, '2025-02-12 11:55:59', 0),
(3, NULL, NULL, '669fe26c-1300-45fb-a552-9d74443b485b', NULL, NULL, 'discount', NULL, NULL, '0.00', '2025-02-14 10:43:14', 0, '2025-02-14 10:43:14', 0),
(4, NULL, NULL, '8314b274-79e7-4d57-b50b-9e01aa60a620', NULL, NULL, 'discount', NULL, NULL, '0.00', '2025-02-18 10:06:37', 0, '2025-02-18 10:06:37', 0),
(6, 1, NULL, 'c1f0aac4-57c2-42ba-be2f-9f0d8e924249', NULL, NULL, 'discount', NULL, NULL, '0.00', '2025-02-19 05:39:11', 752, '2025-02-19 05:39:11', 752),
(7, NULL, NULL, 'a9e4c667-4f6f-4244-8d02-903c3074baed', NULL, NULL, 'discount', NULL, NULL, '0.00', '2025-02-19 08:07:49', 0, '2025-02-19 08:07:49', 0),
(10, NULL, NULL, '52dd35e5-860c-4e39-bbac-f16bac639fa0', '[{\"uuid\":\"be2dcb81-16fe-4bfa-859f-a98a40c60350\",\"name\":\"Free Shipping\",\"estimate\":\"3-5 Business days\",\"rate\":0,\"rate_with_currency\":\"$0.00\"}]', NULL, 'discount', NULL, NULL, '0.00', '2025-10-24 11:46:02', NULL, '2025-10-24 11:46:02', NULL);


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_cart_items`
--


DROP TABLE IF EXISTS `#__easystore_cart_items`;
CREATE TABLE `#__easystore_cart_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cart_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `sku_id` bigint unsigned DEFAULT NULL,
  `quantity` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cart_id` (`cart_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_cart_items_ibfk_1` FOREIGN KEY (`cart_id`) REFERENCES `#__easystore_cart` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_cart_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_settings`
--


DROP TABLE IF EXISTS `#__easystore_settings`;
CREATE TABLE `#__easystore_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


--
-- Dumping data for table `#__easystore_settings`
--


INSERT INTO `#__easystore_settings` (`id`, `key`, `value`) VALUES 
(1, 'email_templates', '{\"order\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_ORDER\",\"templates\":[{\"type\":\"order_confirmation\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_CONFIRMATION_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_CONFIRMATION_SUBTITLE\",\"subject\":\"Order Placed Successfully: Order ID #{order_id}\",\"body\":\"<p>Dear {customer_name},<br><br>Thank you for choosing {store_name}! Your order ID is {order_id}.<br>The details of the placed <a target=\'_blank\' rel=\'noopener\' href=\'{order_link}\'>order<\\/a> are as follows:<br><br><strong>Customer name:<\\/strong> {customer_name}<br><strong>Order Date:<\\/strong> {order_date}<br><strong>Company Name: {company_name}<\\/strong><br><strong>VAT Identification Number (VATIN): <\\/strong>{vat_information}<br><strong>Shipping Address: <\\/strong>{shipping_address}<br><strong>Order Summary:<\\/strong> {order_summary}<br><strong>Customer Note:<\\/strong> {customer_note}<br><br>Need assistance with anything? Just reach out to us at {store_phone} for any assistance.<br><br>Have a good day!<br>{store_name}<br>{store_email}<br>{store_address}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Customer Note\",\"code\":\"{customer_note}\"},{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Company name\",\"code\":\"{company_name}\"},{\"title\":\"Company ID\",\"code\":\"{company_id}\"},{\"title\":\"VAT Identification Number (VATIN)\",\"code\":\"{vat_information}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Order Summary\",\"code\":\"{order_summary}\"},{\"title\":\"Payment Status\",\"code\":\"{payment_status}\"},{\"title\":\"Payment Method\",\"code\":\"{payment_method}\"},{\"title\":\"Shipping Address\",\"code\":\"{shipping_address}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"},{\"title\":\"Seller Tax Id\",\"code\":\"{seller_tax_id}\"}]},{\"type\":\"order_confirmation_admin\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_CONFIRMATION_TITLE_ADMIN\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_CONFIRMATION_SUBTITLE_ADMIN\",\"subject\":\"New Order Placed: Order ID #{order_id}\",\"body\":\"<p>Dear Admin,<\\/p><br><p>A new order with ID {order_id} has been placed on {order_date} in your store, {store_name}.<br>The details of the order are as follows: <br><br><strong>Name:<\\/strong> {customer_name}<strong><br><strong>Email: <\\/strong>{company_email}<br>Order ID:<\\/strong> {order_id}<br><strong>Order Date:<\\/strong> {order_date}<br><strong>Order Summary:<\\/strong> {order_summary}<br><strong>Customer Note:<\\/strong> {customer_note}<br><strong>Payment Status:<\\/strong> {payment_status}<\\/p><p><strong>Company Name:<\\/strong> {company_name}<br><strong>VAT Identification Number (VATIN):<\\/strong> {vat_information}<\\/p><p>Please review the order details and proceed accordingly.<\\/p><p><br>From<br>{store_name}<br>{store_phone}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Customer Email\",\"code\":\"{customer_email}\"},{\"title\":\"Customer Note\",\"code\":\"{customer_note}\"},{\"title\":\"Company name\",\"code\":\"{company_name}\"},{\"title\":\"Company ID\",\"code\":\"{company_id}\"},{\"title\":\"VAT Identification Number (VATIN)\",\"code\":\"{vat_information}\"},{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Order Summary\",\"code\":\"{order_summary}\"},{\"title\":\"Payment Status\",\"code\":\"{payment_status}\"},{\"title\":\"Payment Method\",\"code\":\"{payment_method}\"},{\"title\":\"Shipping Address\",\"code\":\"{shipping_address}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]},{\"type\":\"order_refund\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_REFUND_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_REFUND_SUBTITLE\",\"subject\":\"Refund Confirmation - Order #{order_id}\",\"body\":\"<p>Dear {customer_name},<\\/p><p>We are pleased to confirm that your refund request for Order #{order_id} has been processed. Below are the details of your refund:<\\/p><p><strong>Order ID:<\\/strong> {order_id}<br><strong>Order Date:<\\/strong> {order_date}<\\/p><p><\\/p><p><strong>Refund Amount:<\\/strong> {refund_amount}<br><\\/p><p>Please allow a few business days for the refund to reflect in your account, depending on your bank or payment provider. If you have any questions or concerns regarding your refund, please do not hesitate to reach out to our customer support team at {store_email} or call us at {store_phone}. We are here to assist you with any further inquiries.<br><\\/p><p>Thank you for choosing {store_name}.<\\/p><p><br>{store_address}<\\/p><p><\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Order Id\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Refund Amount\",\"code\":\"{refund_amount}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]}]},\"payment\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_PAYMENT\",\"templates\":[{\"type\":\"payment_success\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_SUCCESS_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_SUCCESS_SUBTITLE\",\"subject\":\"Payment Successful for Your Recent Order\",\"body\":\"<p>Dear {customer_name},<\\/p><p>We are excited to inform you that your recent payment has been successfully processed. Your <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{order_link}\\\">order<\\/a> is now confirmed, and we are preparing it for shipment. Below are the details of your purchase:<\\/p><p><b>Order ID:<\\/b> {order_id}<br><b>Order Date:<\\/b> {order_date}<\\/p><p><b>Shipping Address:<\\/b><br>{shipping_address}<\\/p><p><b>Order Summary:<\\/b><br>{order_summary}<p><p>Please allow us some time to prepare your order for shipment. You will receive a shipping confirmation email with tracking information once your order is on its way.<\\/p><p>If you have any questions or require assistance with your order, please do not hesitate to reach out to our customer support team at  <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{store_email}\\\">{store_email}<\\/a> or call us at {store_phone}.<\\/p><p>Thank you for choosing {store_name}. <br><br>{store_name}<br>{store_phone}<br>{store_email}<br>{store_address}<br><\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Shipping Address\",\"code\":\"{shipping_address}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]},{\"type\":\"payment_error\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_ERROR_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_ERROR_SUBTITLE\",\"subject\":\"Payment Error for Order #{order_id}\",\"body\":\"<p>Dear {customer_name},<\\/p><p>We regret to inform you that there was an issue with the payment for your recent <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{order_link}\\\">order<\\/a> with us. Unfortunately, we were unable to process your payment successfully. The details of your order are as follows:<\\/p><p><b>Order ID:<\\/b> {order_id}<br><b>Order Date:<\\/b> {order_date}<\\/p><p>If you believe this is an error, we recommend the following steps:<ol><li>Double-check your payment information for accuracy, including the card number, expiration date, and CVV code.<\\/li><li>Ensure that the billing address provided matches the one associated with your payment method.<\\/li><li>If you are using a credit or debit card, confirm that your card is valid and has available credit.<\\/li><li>If you continue to experience issues, we recommend trying an alternative payment method, such as a different card or payment option.<\\/li><\\/ol><p>If you still encounter difficulties or have questions about this payment error, please do not hesitate to reach out to our customer support team at  <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{store_email}\\\">{store_email}<\\/a> or call us at {store_phone}. We are here to assist you in resolving this issue and completing your order.<\\/p><p>We apologize for any inconvenience this may have caused and appreciate your patience and understanding.<\\/p><p>Thank you for considering {store_name}. We value your business and hope to provide you with a seamless shopping experience.<\\/p><p>Sincerely,<\\/p><p>{store_name}<br>{store_address}<br>{store_email}<br>{store_phone}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]},{\"type\":\"payment_success_admin\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_SUCCESS_TITLE_ADMIN\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_PAYMENT_SUCCESS_SUBTITLE_ADMIN\",\"subject\":\"Payment Successful for Order #{order_id}\",\"body\":\"<p>Dear {store_name},<\\/p><p>We\\u2019re pleased to inform you that a customer has successfully completed their payment, and their <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{order_link}\\\">order<\\/a> has been confirmed. Below are the order details:<\\/p><p><strong>Order ID:<\\/strong> {order_id}<br><strong>Order Date:<\\/strong> {order_date}<\\/p><p><strong>Customer Details:<\\/strong><br><strong>Name:<\\/strong> {customer_name}<br><\\/p><p><strong>Shipping Address:<\\/strong><br>{shipping_address}<br><\\/p><p>Please proceed with order fulfillment and prepare the shipment. The customer will receive a confirmation email along with tracking details once the order has been dispatched.<\\/p><p>If you need any further assistance, feel free to contact us at {store_email} or call us at {store_phone}.<\\/p><p>Thank you for your continued support.<br><\\/p><p><strong>Best regards,<\\/strong><br><strong>{store_name}<\\/strong><br>{store_phone} | {store_email}<br>{store_address}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Order ID\",\"code\":\"{order_id}\"},{\"title\":\"Order Date\",\"code\":\"{order_date}\"},{\"title\":\"Order Link\",\"code\":\"{order_link}\"},{\"title\":\"Shipping Address\",\"code\":\"{shipping_address}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"}]}]},\"shipping\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_SHIPPING\",\"templates\":[{\"type\":\"shipping_add_tracking\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_TRACKING_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_ORDER_TRACKING_SUBTITLE\",\"subject\":\"Shipping Carrier Added - Order #{order_id}\",\"body\":\"<p>Dear {customer_name},<br><\\/p><p>We are excited to inform you that a shipping carrier has been added to your order. <br>Here are the details:<\\/p><ul><li><p><strong>Order Number:<\\/strong> {order_id}<\\/p><\\/li><li><p><strong>Shipping Carrier: <\\/strong>{shipping_carrier}<\\/p><\\/li><\\/ul><p>You can track your order\'s status by clicking the following link:<\\/p><p><strong>Track Your Order:<\\/strong> <a target=\\\"_blank\\\" rel=\\\"noreferrer noopener\\\" href=\\\"{tracking_url}\\\">{tracking_url}<\\/a><br><\\/p><p>If you have any questions or need assistance, please feel free to contact our customer support team at <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{store_email}\\\">{store_email}<\\/a> or call us at {store_phone}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Order Number\",\"code\":\"{order_id}\"},{\"title\":\"Shipping Carrier\",\"code\":\"{shipping_carrier}\"},{\"title\":\"Tracking Url\",\"code\":\"{tracking_url}\"},{\"title\":\"Store Email\",\"code\":\"{store_email}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"}]}]},\"customer\":{\"name\":\"COM_EASYSTORE_EMAIL_TEMPLATE_GROUP_NAME_CUSTOMER\",\"templates\":[{\"type\":\"customer_new_account\",\"title\":\"COM_EASYSTORE_EMAIL_TEMPLATE_NEW_ACCOUNT_TITLE\",\"subtitle\":\"COM_EASYSTORE_EMAIL_TEMPLATE_NEW_ACCOUNT_SUBTITLE\",\"subject\":\"Welcome to {store_name} - Your New Account\",\"body\":\"<p>Dear {customer_name},<\\/p><p>We are excited to welcome you to {store_name}! Thank you for creating your account with us. Your journey with us has just begun, and we can\'t wait to provide you with a seamless and enjoyable experience.<\\/p><p>Here are a few things you can do with your {store_name} account:<\\/p><ol><li><p><strong>Explore Our Products:<\\/strong> Browse our wide range of high-quality products and discover the perfect items for your needs.<\\/p><\\/li><li><p><strong>Save Your Favorites:<\\/strong> Save your favorite products to your wishlist for easy access later.<\\/p><\\/li><li><p><strong>Streamlined Checkout:<\\/strong> Enjoy a faster and more convenient checkout process when you make a purchase.<\\/p><\\/li><li><p><strong>Order Tracking:<\\/strong> Keep an eye on the progress of your orders and access tracking information easily.<\\/p><\\/li><li><p><strong>Exclusive Offers:<\\/strong> As a valued member, you\'ll receive exclusive promotions, discounts, and updates.<\\/p><\\/li><\\/ol><p>To get started, simply log in to your account <a target=\\\"_blank\\\" rel=\\\"noopener noreferrer nofollow\\\" href=\\\"{account_login_link}\\\">Password Reset Link<\\/a> and start exploring the exciting features we have to offer.<\\/p><p>Thank you for choosing {store_name}. We value your trust and look forward to serving you. Welcome aboard!<\\/p><p><\\/p><p>{store_name}<br>{store_phone}<br>{store_address}<\\/p>\",\"is_enabled\":true,\"variables\":[{\"title\":\"Customer Name\",\"code\":\"{customer_name}\"},{\"title\":\"Account Login Link\",\"code\":\"{account_login_link}\"},{\"title\":\"Store Name\",\"code\":\"{store_name}\"},{\"title\":\"Store Address\",\"code\":\"{store_address}\"},{\"title\":\"Store Phone Number\",\"code\":\"{store_phone}\"}]}]}}'),
(2, 'general', '{\"storeName\":\"Megadeal\",\"storeLogo\":\"\\/images\\/easystore\\/store-logo\\/logo.png\",\"storeEmail\":\"install@joomshaper.com\",\"storePhone\":\"0123456789\",\"addressLineOne\":\"2744 Millwood Ave\",\"addressLineTwo\":\"\",\"city\":\"Columbia\",\"postcode\":\"29205\",\"country\":\"840\",\"state\":\"1443\",\"sellingLocation\":\"all_countries\",\"sellingCountries\":[],\"sellingCountriesExcept\":[],\"shippingLocation\":\"\",\"shippingCountries\":[],\"shippingCountriesExcept\":[],\"enableTaxes\":false,\"enableCouponCodes\":false,\"calculateCouponsSequentially\":false,\"currency\":\"USD:$\",\"currencyPosition\":\"before\",\"currencyFormat\":\"short\",\"thousandSeparator\":\",\",\"decimalSeparator\":\".\"}'),
(3, 'products', '{\"shopPage\":\"index.php?option=com_easystore&view=products&catid=0\",\"redirection\":false,\"standardUnits\":{\"weight\":\"kg\",\"dimension\":\"m\"},\"productReviews\":true,\"starRatingOnReviews\":true,\"variantLayout\":\"list\"}'),
(5, 'shipping', '[{\"uuid\":\"dd1093ea-be05-4c28-8ee2-251d7ea9ecce\",\"name\":\"European Region\",\"methodType\":\"free\",\"freeShipping\":{\"uuid\":\"be2dcb81-16fe-4bfa-859f-a98a40c60350\",\"name\":\"Free Shipping\",\"estimate\":\"3-5 Business days\"},\"flatRate\":[{\"uuid\":\"eb1a5818-c9e8-442e-8325-b80d118488bf\",\"name\":\"\",\"estimate\":\"\",\"rate\":null,\"offerFreeShipping\":false,\"offerOnAmount\":null,\"isCollapsed\":false,\"isLatest\":false}],\"rateByWeight\":[{\"uuid\":\"ca99f435-238a-422f-9f70-8fcabad537ee\",\"name\":\"\",\"estimate\":\"\",\"weights\":[{\"from\":null,\"to\":null,\"rate\":null}],\"offerFreeShipping\":false,\"offerOnAmount\":null,\"isCollapsed\":false,\"isLatest\":false}],\"isCollapsed\":false,\"enabled\":true,\"isLatest\":false,\"localPickup\":{\"name\":\"\",\"country\":\"\",\"state\":null,\"city\":\"\",\"postalCode\":\"\",\"orderReadyTime\":\"\",\"instruction\":\"\",\"isActive\":true},\"regions\":[{\"uuid\":\"891e76c8-6677-45ea-a2ae-8b92d9882bbf\",\"country\":\"840\",\"states\":[],\"isCollapsed\":true,\"isLatest\":false}]}]'),
(6, 'tax', '{\"rates\":[{\"country\":\"000\",\"isSameRate\":false,\"rate\":0,\"states\":[],\"vat_registration_type\":\"one-stop\"}],\"applyTaxOn\":\"product\",\"activeCountry\":null,\"showPriceWithTax\":false,\"chargeTaxOnShipping\":false,\"isTaxIncludedInPrice\":0}');


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_guests`
--


DROP TABLE IF EXISTS `#__easystore_guests`;
CREATE TABLE `#__easystore_guests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_address` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_user_coupon_usage`
--


DROP TABLE IF EXISTS `#__easystore_user_coupon_usage`;
CREATE TABLE `#__easystore_user_coupon_usage` (
  `user_id` int DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `coupon_id` int NOT NULL,
  `coupon_count` int NOT NULL DEFAULT '0',
  KEY `idx_coupon_usage` (`user_id`,`coupon_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_collections`
--


DROP TABLE IF EXISTS `#__easystore_collections`;
CREATE TABLE `#__easystore_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `metatitle` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta title for the page.',
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_alias` (`alias`),
  KEY `idx_title` (`title`),
  KEY `idx_published` (`published`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_collection_product_map`
--


DROP TABLE IF EXISTS `#__easystore_collection_product_map`;
CREATE TABLE `#__easystore_collection_product_map` (
  `collection_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`collection_id`,`product_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_collection_product_map_ibfk_1` FOREIGN KEY (`collection_id`) REFERENCES `#__easystore_collections` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_collection_product_map_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_brands`
--


DROP TABLE IF EXISTS `#__easystore_brands`;
CREATE TABLE `#__easystore_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` bigint unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` tinyint NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint DEFAULT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_alias` (`alias`),
  KEY `idx_title` (`title`),
  KEY `idx_published` (`published`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_upsells`
--


DROP TABLE IF EXISTS `#__easystore_product_upsells`;
CREATE TABLE `#__easystore_product_upsells` (
  `product_id` bigint unsigned NOT NULL,
  `upsell_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`upsell_id`,`product_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_product_upsells_ibfk_1` FOREIGN KEY (`upsell_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_product_upsells_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__easystore_product_crossells`
--


DROP TABLE IF EXISTS `#__easystore_product_crossells`;
CREATE TABLE `#__easystore_product_crossells` (
  `product_id` bigint unsigned NOT NULL,
  `crossell_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`crossell_id`,`product_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `#__easystore_product_crossells_ibfk_1` FOREIGN KEY (`crossell_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `#__easystore_product_crossells_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `#__easystore_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `#__sppagebuilder`
--


DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE `#__sppagebuilder` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `content` mediumtext,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '1',
  `catid` int NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL,
  `created_by` bigint NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` bigint NOT NULL DEFAULT '0',
  `checked_out` int NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL DEFAULT '',
  `og_image` varchar(255) NOT NULL DEFAULT '',
  `og_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `hits` bigint NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  `version` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb3;


--
-- Dumping data for table `#__sppagebuilder`
--


INSERT INTO `#__sppagebuilder` (`id`, `asset_id`, `title`, `text`, `content`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`, `version`) VALUES 
(2, 66, 'About', '[{\"id\":1519292114797,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519292114797,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0},\"layout\":\"12\",\"columns\":[{\"id\":1519292114796,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519292140689,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"About Us\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eium od tempor incididunt ut labore et dolore magna aliqua. Ut enim adm inim veniam, quis nostrud exercitation. Ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"instFormId\":1519292140689,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519292114817,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519292114817,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0},\"layout\":\"6,6\",\"columns\":[{\"id\":1519292114815,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519292279684,\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"style\":\"tabs\",\"active_tab_bg\":\"#e5e5e5\",\"active_tab_color\":\"#333333\",\"class\":\"\",\"sp_tab_item\":[{\"title\":\"Mission\",\"icon\":\"\",\"content\":[{\"id\":1519292114872,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.<br /><br />Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Wolf moon officia aute, non cupidatat skateboard dolor brunch.\",\"dropcap\":0}}]},{\"title\":\"Vision\",\"icon\":\"\",\"content\":[{\"id\":1519292350787,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.<br /><br />Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"dropcap\":0}}]}],\"instFormId\":1519292279684,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519292114816,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519292503968,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-default\",\"openitem\":\"\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"},{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}],\"instFormId\":1519292503968,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519320065460,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519320065460,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0,\"background_color\":\"#f9f9f9\"},\"layout\":\"12\",\"columns\":[{\"id\":1519320065461,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320065462,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Meet The Team\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eium od tempor incididunt ut labore et dolore magna aliqua.<br />Ut enim adm inim veniam, quis nostrud exercitation.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"instFormId\":1519320065462,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519320065459,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519320065459,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0,\"background_color\":\"#f9f9f9\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1519320065455,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320760276,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Lucas Schultz\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_position\":\"bottom\",\"image\":\"images/2018/02/22/person1.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"instFormId\":1519320760276,\"title_margin_top\":{\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519320065456,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320838960,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Ara Dare\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_position\":\"bottom\",\"image\":\"images/2018/02/22/person2.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"instFormId\":1519320838960,\"title_margin_top\":{\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519320065457,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320838963,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Dimitri Abernathy\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_position\":\"bottom\",\"image\":\"images/2018/02/22/person3.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"instFormId\":1519320838963,\"title_margin_top\":{\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519320065316,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519320065316,\"columns_align_center\":1,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0,\"background_color\":\"\"},\"layout\":\"3,9\",\"columns\":[{\"id\":1519320065315,\"class_name\":\"col-md-9\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320512191,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Discover all Helix Ultimate Features\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem Ipsum is simply dummy text of the printing and typesetting industry.<br />Lorem Ipsum has been the industry&rsquo;s.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"instFormId\":1519320512191,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519320065314,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320578289,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Learn More\",\"alignment\":\"sppb-text-right\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"flat\",\"background_color\":\"#03E16D\",\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"color_hover\":\"#FFFFFF\",\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"instFormId\":1519320578289,\"url\":\"#\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"size\":\"lg\"}}]}]}]', '[{\"id\":\"nPGkTax2UC5fAhUZGmTN6\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"30px 0px 20px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"60px 0px 20px 0px\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":\"nPGkTax2UC5fAhUZGmTN6\"},\"layout\":\"3.4+8.6\",\"columns\":[{\"id\":\"bXFVHGZ-_5AQjJtDixMjV\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"28.2%\",\"lg\":\"33.333333%\",\"md\":\"33.333333%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"HUStrTYIzHkS28UGjr9hL\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default-img\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/2025\\/02\\/11\\/about-img1.webp\",\"height\":740,\"width\":684},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":\"4\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":2},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"instFormId\":\"HUStrTYIzHkS28UGjr9hL\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Image\",\"parent\":false}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"VOa6ei84TQaJpb60w38xt\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"71.8%\",\"lg\":\"66.666667%\",\"md\":\"66.666667%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"gF4mxKMQineHe5fZD3gDu\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>At MegaDeal ii, we\\u2019re passionate about bringing you the latest and greatest in electronics at unbeatable prices. Whether you\'re looking for cutting-edge gadgets, high-quality audio gear, or everyday tech essentials, we\\u2019ve got you covered. <\\/p><p>The Beginning fueled by our love for technology, we set out to create a platform where customers could find premium electronics at competitive prices, all in one place. Growth &amp; Innovation over the years, we expanded our product range, partnered with top brands, and enhanced our shopping experience with fast shipping, secure payments, and exceptional customer service. The Future we\\u2019re committed to staying ahead of the curve, bringing you the latest innovations, and continuously improving our platform to make your shopping experience even better.<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"instFormId\":\"gF4mxKMQineHe5fZD3gDu\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"title\":\"Our Journey\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"global_background_color\":\"\",\"title_margin_bottom\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":\"gDn-HXQRJulgqcTcS6DnG\"},{\"id\":\"gDn-HXQRJulgqcTcS6DnG\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 20px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 20px 30px\",\"sm\":\"25px 25px 15px 25px\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"#addonWrapper,\\n#addonId {\\n\\theight: 100%;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":\"gDn-HXQRJulgqcTcS6DnG\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"global_background_color\":\"#ffffff\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[\"gF4mxKMQineHe5fZD3gDu\"]}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":false},{\"id\":\"gINOoNMQp9GHtupzNcSVz\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"20px 0px 100px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"20px 0px 60px 0px\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":\"gINOoNMQp9GHtupzNcSVz\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\",\"row_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"layout\":\"3.4+8.6\",\"columns\":[{\"id\":\"-MWOUDGjRhyAIG_uHCwO6\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"28.2%\",\"lg\":\"33.333333%\",\"md\":\"33.333333%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1739261334486,\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"\"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":1739261334486,\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"global_background_color\":\"#ffffff\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[1739261345931,1739267661419]},{\"id\":\"227d8246-87ac-44ea-934f-0e00ec6e85c9\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"30px 30px 30px 30px\"},\"global_margin\":{\"xl\":\"40px 0px 40px 0px\"},\"global_background_type\":\"image\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"images\\/2025\\/02\\/10\\/fast-delivery-9.jpg\",\"height\":476,\"width\":266},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"global_background_color\":\"#FFFFFF\"},\"children\":[\"2deb8d2b-b8bd-48c2-a2ec-803500e2c2c4\",\"2db76b2d-89aa-461b-8988-4776f7e401c4\",\"e25eb79e-0b7a-4b31-9bcc-cf456a8c1f66\"],\"parent\":false},{\"id\":\"3baa7c98-0534-4c58-97b1-0b346a8de652\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"25px 25px 25px 25px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"40px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default about-cta\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":1739261578629,\"url\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"global_background_color\":\"\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[\"82c4ad4f-7fde-4cf0-9b61-fe78f35497c9\",\"f1a17f3f-a338-47bd-a672-7648fdd5843f\"]},{\"id\":\"2deb8d2b-b8bd-48c2-a2ec-803500e2c2c4\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"title\":\"Image\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 30px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/2025\\/02\\/10\\/laptop-121.png\",\"height\":256,\"width\":208},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":0,\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":34},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"title\":\"\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"parent\":\"227d8246-87ac-44ea-934f-0e00ec6e85c9\"},{\"id\":\"2db76b2d-89aa-461b-8988-4776f7e401c4\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"0px 0px 20px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":1,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Lean. Mean.\\u00a0M3\\nmachine.\",\"heading_selector\":\"h3\",\"title_text_shadow\":\"0 0 0 transparent\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_link\":{\"type\":\"url\",\"url\":\"\",\"menu\":\"\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":34},\"heading_typography\":{\"font\":\"Poppins\",\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"600\",\"size\":{\"xl\":{\"value\":\"32\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"36\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"type\":\"google\"},\"title_color\":{\"type\":\"solid\",\"color\":\"#FFFFFF\",\"color2\":\"\",\"pos\":0,\"pos2\":100,\"deg\":0,\"radialPos\":\"center center\"},\"global_width\":{\"xl\":\"50\"}},\"parent\":\"227d8246-87ac-44ea-934f-0e00ec6e85c9\"},{\"id\":\"e25eb79e-0b7a-4b31-9bcc-cf456a8c1f66\",\"type\":\"general\",\"name\":\"button\",\"visibility\":true,\"title\":\"Button\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Order now\",\"aria_label\":\"\",\"type\":\"custom\",\"appearance\":\"\",\"shape\":\"rounded\",\"button_padding\":{\"xl\":\"0px 0px 0px 0px\"},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"right\",\"icon_margin\":{\"xl\":\"0px 0px 0px 5px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_style_state\":\"hover\",\"color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"background_color\":\"\",\"background_color_hover\":\"\",\"background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"button_link_style_state\":\"normal\",\"link_button_color\":\"#3366FF\",\"link_button_border_width\":1,\"link_border_color\":\"#3366FF\",\"link_button_hover_color\":\"#0037DD\",\"link_button_border_hover_color\":\"#0037DD\",\"url\":{\"type\":\"menu\",\"url\":\"\",\"menu\":\"index.php?option=com_easystore&view=products&catid=0&Itemid=358\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":34},\"size\":\"custom\",\"typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"icon\":\"fas fa-chevron-right\"},\"parent\":\"227d8246-87ac-44ea-934f-0e00ec6e85c9\"},{\"id\":\"82c4ad4f-7fde-4cf0-9b61-fe78f35497c9\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Contact our friendly support team\\u2014we\\u2019re happy to help!\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h2\",\"instFormId\":1739261589962,\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Have Questions?\",\"title_margin_bottom\":{\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_typography\":{\"font\":\"\",\"weight\":\"500\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title_text_color\":\"#000000\",\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":\"3baa7c98-0534-4c58-97b1-0b346a8de652\"},{\"id\":\"f1a17f3f-a338-47bd-a672-7648fdd5843f\",\"type\":\"general\",\"name\":\"button\",\"visibility\":true,\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Contact us\",\"aria_label\":\"\",\"type\":\"primary\",\"appearance\":\"\",\"shape\":\"round\",\"button_padding\":\"\",\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"icon_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_style_state\":\"normal\",\"color\":\"#FFFFFF\",\"color_hover\":\"#FFFFFF\",\"background_color\":\"#3366FF\",\"background_color_hover\":\"#0037DD\",\"background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"button_link_style_state\":\"normal\",\"link_button_color\":\"#3366FF\",\"link_button_border_width\":1,\"link_border_color\":\"#3366FF\",\"link_button_hover_color\":\"#0037DD\",\"link_button_border_hover_color\":\"#0037DD\",\"instFormId\":1739261596829,\"url\":{\"url\":\"\",\"type\":\"menu\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":2,\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=3&Itemid=113\"},\"size\":\"\",\"typography\":{\"font\":\"\",\"weight\":\"500\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 8a4 4 0 014-4h24a4 4 0 014 4v9a4 4 0 01-4 4h-.5a1 1 0 110-2h.5a2 2 0 002-2V8a2 2 0 00-2-2H4a2 2 0 00-2 2v9a2 2 0 002 2h9a1 1 0 110 2H4a4 4 0 01-4-4V8z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M16.004 12.669l1.526 9.46c.05.408.508.611.864.408l2.645-1.882 3.612 5.137c.508.661 2.034-.407 1.577-1.068l-3.612-5.188 2.696-1.832c.305-.254.305-.762-.05-.966l-8.393-4.68a.604.604 0 00-.865.611z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Button\",\"parent\":\"3baa7c98-0534-4c58-97b1-0b346a8de652\"},{\"id\":\"ejHNurduAlwcgcfVqjb4R\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"0px 0px 0px 18px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 30px -1px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 25px -1px\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":true,\"global_border_width\":{\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonWrapper #addonId {\\n\\tborder-top: 0px;\\n\\tborder-bottom: 0px;\\n\\tborder-right: 0px;\\n  opacity: .4;\\n  transition: all .3s;\\n}\\n#addonWrapper #addonId:hover {\\n\\topacity: 1;\\n  border-color:#000000;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"We are a team of tech enthusiasts and experts dedicated to curating the best electronics from top brands. \",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h4\",\"instFormId\":\"ejHNurduAlwcgcfVqjb4R\",\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Who We Are\",\"title_text_color\":\"#000000\",\"title_margin_bottom\":{\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_typography\":{\"font\":\"\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"global_boder_style\":\"solid\",\"global_border_color\":\"rgba(0, 0, 0, 0)\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":1739267661419},{\"id\":\"nAx3SpioenbMSCEZwwFxI\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"0px 0px 0px 18px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 30px -1px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 25px -1px\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":true,\"global_border_width\":{\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonWrapper #addonId {\\n\\tborder-top: 0px;\\n\\tborder-bottom: 0px;\\n\\tborder-right: 0px;\\n  opacity: .4;\\n  transition: all .3s;\\n}\\n#addonWrapper #addonId:hover {\\n\\topacity: 1;\\n  border-color:#000000;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"Discover the latest tech, unbeatable deals, and top-quality gadgets at Megadeal ii.\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h4\",\"instFormId\":\"nAx3SpioenbMSCEZwwFxI\",\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Why Shop With Us?\",\"title_text_color\":\"#000000\",\"title_margin_bottom\":{\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_typography\":{\"font\":\"\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"global_boder_style\":\"solid\",\"global_border_color\":\"rgba(0, 0, 0, 0)\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":1739267661419},{\"id\":\"ads2J-Q_40jCxqfAw0Lge\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"0px 0px 0px 18px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 0px -1px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":true,\"global_border_width\":{\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonWrapper #addonId {\\n\\tborder-top: 0px;\\n\\tborder-bottom: 0px;\\n\\tborder-right: 0px;\\n  opacity: .4;\\n  transition: all .3s;\\n}\\n#addonWrapper #addonId:hover {\\n\\topacity: 1;\\n  border-color:#000000;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"We believe that technology should be accessible to everyone. Our goal is to make shopping for electronics easy, affordable, and enjoyable\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h4\",\"instFormId\":\"ads2J-Q_40jCxqfAw0Lge\",\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"title\":\"Our Mission\",\"title_text_color\":\"#000000\",\"title_margin_bottom\":{\"xl\":\"5\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_typography\":{\"font\":\"\",\"weight\":\"\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"global_boder_style\":\"solid\",\"global_border_color\":\"rgba(0, 0, 0, 0)\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":1739267661419},{\"id\":1739261345931,\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 50px 0px\",\"lg\":\"0px 0px 30px 0px\",\"md\":\"\",\"sm\":\"0px 0px 25px 0px\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Our Story\",\"heading_selector\":\"h3\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"instFormId\":1739261345931,\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":2},\"global_text_color\":\"#000000\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"heading_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Heading\",\"parent\":1739261334486},{\"id\":1739267661419,\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":true,\"global_border_width\":{\"xl\":\"1\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonWrapper #addonId {\\n\\tborder-top: 0px;\\n\\tborder-bottom: 0px;\\n\\tborder-right: 0px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":1739267661419,\"global_boder_style\":\"solid\",\"global_border_color\":\"rgba(0, 0, 0, 0.4)\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":1739261334486,\"children\":[\"ejHNurduAlwcgcfVqjb4R\",\"nAx3SpioenbMSCEZwwFxI\",\"ads2J-Q_40jCxqfAw0Lge\"]}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"rLGztJpArzmhLZFqMikck\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"71.8%\",\"lg\":\"66.666667%\",\"md\":\"66.666667%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"pE_yBl_a47XVgAHHvs7bU\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default-img\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/2025\\/02\\/11\\/about-img2.webp\",\"height\":1136,\"width\":1812},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":\"4\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":2},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"instFormId\":\"pE_yBl_a47XVgAHHvs7bU\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Image\",\"parent\":false},{\"type\":\"nested_row\",\"id\":1739256065988,\"name\":\"row\"},{\"id\":\"RpPhQF0--0ooOpWrf4UlD\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"0px 0px 20px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/2025\\/02\\/11\\/about-img3.webp\",\"height\":616,\"width\":1812},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":\"4\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":2},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"instFormId\":\"RpPhQF0--0ooOpWrf4UlD\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"title\":\"\"},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Image\",\"parent\":false},{\"id\":\"8ZJ__lYd_DJV9apaF7gOi\",\"type\":\"content\",\"name\":\"image\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default-img\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"image\":{\"src\":\"images\\/2025\\/02\\/11\\/about-img4.webp\",\"height\":630,\"width\":1812},\"image_2x\":{\"src\":\"\",\"height\":\"\",\"width\":\"\"},\"alt_text\":\"Image\",\"image_title\":\"\",\"is_image_shape_enabled\":0,\"image_shape\":\"\",\"image_shape_scale\":1.2,\"is_effects_enabled\":0,\"border_radius\":\"4\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"is_zoom_enabled\":0,\"zoom_scale\":\"1.2\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":2},\"heading_selector\":\"h3\",\"title_position\":\"top\",\"instFormId\":\"8ZJ__lYd_DJV9apaF7gOi\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"},\"title\":\"\"},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M31.288 17.393l-9.718 5.9a5 5 0 01-5.8-.435l-3.622-3.024a3 3 0 00-3.583-.197l-6.781 4.504-1.106-1.666 6.78-4.504a5 5 0 015.971.327l3.623 3.025a3 3 0 003.48.261l9.718-5.9 1.038 1.71z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M19.077 10.154a2.077 2.077 0 100 4.154 2.077 2.077 0 000-4.154zM15 12.23a4.077 4.077 0 118.154 0 4.077 4.077 0 01-8.154 0z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M29 4H3a1 1 0 00-1 1v22.308a1 1 0 001 1h26a1 1 0 001-1V5a1 1 0 00-1-1zM3 2a3 3 0 00-3 3v22.308a3 3 0 003 3h26a3 3 0 003-3V5a3 3 0 00-3-3H3z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Image\",\"parent\":false}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":false},{\"id\":1739256065988,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"40px 40px 20px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 20px 30px\",\"sm\":\"25px 25px 15px 25px\",\"xs\":\"\"},\"margin\":{\"xl\":\"0px 0px 40px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 30px 0px\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":1,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1739256065988,\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"background_color\":\"#ffffff\",\"class\":\"shadow-default\",\"row_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\"},\"layout\":\"12.0+12.0\",\"columns\":[{\"id\":1739256065986,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1739261446435,\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 30px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Powered by Innovation, Driven by You\",\"heading_selector\":\"h3\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"instFormId\":1739261446435,\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":2},\"global_text_color\":\"#000000\",\"heading_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Heading\",\"parent\":false}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1739256065987,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"50%\",\"lg\":\"100%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1739261457339,\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 22px 0px\",\"lg\":\"\",\"md\":\"0px 0px 15px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId .sppb-addon-content strong {\\n\\tfont-weight: 500;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>\\ud83d\\udd39 <strong>Passionate About Technology<\\/strong> \\u2013 We stay ahead of trends to bring you the latest gadgets.<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"instFormId\":1739261457339,\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":false},{\"id\":\"UENvB_ZodfAB3FTpgJ9oQ\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 22px 0px\",\"lg\":\"\",\"md\":\"0px 0px 15px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId .sppb-addon-content strong {\\n\\tfont-weight: 500;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>\\ud83d\\udd39 <strong>Committed to Quality<\\/strong> \\u2013 Every product is carefully selected for performance and reliability.<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"instFormId\":\"UENvB_ZodfAB3FTpgJ9oQ\",\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":false},{\"id\":\"x1vnMhyNrytuAGUAE7Xdv\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 22px 0px\",\"lg\":\"\",\"md\":\"0px 0px 15px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId .sppb-addon-content strong {\\n\\tfont-weight: 500;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>\\ud83d\\udd39 <strong>Customer-Centric Approach<\\/strong> \\u2013 Your satisfaction is our top priority, from shopping to support.<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"instFormId\":\"x1vnMhyNrytuAGUAE7Xdv\",\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":false},{\"id\":\"nGwFq-VAQCatA36KZ7y1y\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 22px 0px\",\"lg\":\"\",\"md\":\"0px 0px 15px 0px\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId .sppb-addon-content strong {\\n\\tfont-weight: 500;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>\\ud83d\\udd39 <strong>Trusted by Thousands<\\/strong> \\u2013 Serving tech lovers worldwide with excellence and integrity.<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"instFormId\":\"nGwFq-VAQCatA36KZ7y1y\",\"title_text_shadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false},\"text_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":false,\"italic\":false,\"underline\":false,\"weight\":\"\",\"type\":\"google\"},\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":false}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":{\"rowId\":\"gINOoNMQp9GHtupzNcSVz\",\"columnId\":\"rLGztJpArzmhLZFqMikck\"}}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2018-02-22 09:31:20', 871, '2025-02-19 12:54:39', 752, 0, '0000-00-00 00:00:00', '{\"meta_description\":\"\",\"meta_keywords\":\"\",\"robots\":\"\",\"seo_spacer\":\"\",\"author\":\"\",\"og_type\":\"website\"}', '', '', '', '*', 394, '', '5.5.2'),
(3, 67, 'Contact', '[]', '[{\"id\":\"9EkS3xIwZAB4EY86hbxsj\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"40px 0px 20px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"40px 0px 20px 0px\",\"xs\":\"   \"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":\"9EkS3xIwZAB4EY86hbxsj\"},\"layout\":\"12.0+12.0\",\"columns\":[{\"id\":1739274622482,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"63%\",\"lg\":\"71.666667%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1739274871203,\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"   \"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":1739274871203,\"global_background_color\":\"#ffffff\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[1739274954154,1739274963188]},{\"id\":1739274954154,\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 38px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":true,\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>We\'d love to hear from you. Our team is here to help.\\u2028Let your customers get in touch with you by filling out the email form below.<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h3\",\"instFormId\":1739274954154,\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"title\":\"Contact us\",\"title_margin_bottom\":{\"xl\":\"15\",\"lg\":\"\",\"md\":\"\",\"sm\":\"10\",\"xs\":\"\"},\"global_width\":{\"xl\":\"75\",\"lg\":\"97\",\"md\":\"100\",\"sm\":\"\",\"xs\":\"\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":1739274871203},{\"id\":1739274963188,\"type\":\"repeatable\",\"name\":\"form_builder\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonWrapper #addonId .sppb-addon-form-builder-form {\\n    margin-left: -15px;\\n    margin-right: -15px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"sp_form_builder_item\":[{\"title\":\"\",\"field_name\":\"Full name\",\"field_placeholder\":\"Full name\",\"field_type\":\"text\",\"field_width\":{\"xl\":50,\"lg\":50,\"md\":50,\"sm\":100,\"xs\":100},\"admin_label\":\"Item 1\"},{\"title\":\"\",\"field_name\":\"Email address\",\"field_placeholder\":\"Email address\",\"field_type\":\"email\",\"field_is_required\":1,\"field_required_star\":1,\"field_width\":{\"xl\":50,\"lg\":50,\"md\":50,\"sm\":100,\"xs\":100},\"admin_label\":\"Item 2\"},{\"title\":\"\",\"field_name\":\"Phone number\",\"field_placeholder\":\"Phone number\",\"field_type\":\"tel\",\"field_is_required\":false,\"field_required_star\":false,\"field_width\":{\"xl\":50,\"lg\":50,\"md\":50,\"sm\":100,\"xs\":100},\"admin_label\":\"Item 3\"},{\"title\":\"\",\"field_name\":\"Subject\",\"field_placeholder\":\"Subject\",\"field_type\":\"select\",\"field_width\":{\"xl\":50,\"lg\":50,\"md\":50,\"sm\":100,\"xs\":100},\"sp_form_builder_inner_item_select\":[{\"admin_label\":\"New Item\",\"title\":\"Computer & Laptop\"},{\"admin_label\":\"New Item\",\"title\":\"Watches\"},{\"admin_label\":\"New Item\",\"title\":\"Special Items\"},{\"admin_label\":\"New Item\",\"title\":\"Electronics\"}],\"admin_label\":\"Item 4\"},{\"title\":\"\",\"field_name\":\"message\",\"field_placeholder\":\"Message\",\"field_type\":\"textarea\",\"field_is_required\":false,\"field_required_star\":false,\"field_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"is_resize\":true,\"admin_label\":\"Item 5\"}],\"required_field_message\":\"Please fill the required field.\",\"success_message\":\"Email successfully sent!\",\"failed_message\":\"Email sent failed, fill required field and try again!\",\"hide_label\":0,\"enable_redirect\":0,\"enable_captcha\":false,\"captcha_type\":\"default\",\"captcha_question\":\"3 + 4 = ?\",\"captcha_answer\":\"7\",\"enable_policy\":0,\"policy_text\":\"I agree with the <a href=\\\"#\\\">Terms of Use<\\/a> and <a href=\\\"#\\\">Privacy Policy<\\/a> and I declare that I have read the information that is required in accordance with <a href=\\\"http:\\/\\/eur-lex.europa.eu\\/legal-content\\/EN\\/TXT\\/?uri=uriserv:OJ.L_.2016.119.01.0001.01.ENG&amp;toc=OJ:L:2016:119:TOC\\\" target=\\\"_blank\\\">Article 13 of GDPR.<\\/a>\",\"field_gutter\":{\"xl\":15},\"additional_header\":\"Reply-To: {{email}}\\nReply-name: {{first-name}} {{last-name}}\\nCc: {{email}}\",\"email_subject\":\"{{subject}} | {{site-name}}\",\"email_template\":\"<p><strong>From:<\\/strong>{{first-name}} {{last-name}}<\\/p>\\n<p><strong>Email:<\\/strong>{{email}}<\\/p>\\n<p><strong>Subject:<\\/strong>{{subject}}<\\/p>\\n<p><strong>Message:<\\/strong>{{message}}<\\/p>\",\"btn_text\":\"Send Message\",\"btn_type\":\"primary\",\"btn_shape\":\"round\",\"btn_padding\":{\"xl\":\"8px 22px 10px 22px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_icon_position\":\"left\",\"btn_style_tab\":\"normal\",\"btn_color\":\"#FFFFFF\",\"btn_background_color\":\"#3366FF\",\"btn_background_gradient\":{\"color\":\"#3366FF\",\"color2\":\"#0037DD\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"btn_background_color_hover\":\"#0037DD\",\"btn_background_gradient_hover\":{\"color\":\"#0037DD\",\"color2\":\"#3366FF\",\"deg\":\"45\",\"type\":\"linear\"},\"link_button_style_tab\":\"normal\",\"instFormId\":1739274963188,\"field_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"field_border_width\":\"1px 1px 1px 1px\",\"label_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_margin\":{\"xl\":\"15px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_typography\":{\"font\":\"\",\"weight\":\"500\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"field_horizontal_space\":{\"xl\":\"25\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"field_bg_color\":\"#f8f8f8\",\"field_border_color\":\"#eeeeee\",\"field_focus_border_color\":\"var(--link-color)\",\"input_height\":{\"xl\":\"48\",\"lg\":\"\",\"md\":\"42\",\"sm\":\"\",\"xs\":\"\"},\"textarea_height\":{\"xl\":\"122\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2 4a4 4 0 014-4h17a4 4 0 014 4v13a1 1 0 11-2 0V4a2 2 0 00-2-2H6a2 2 0 00-2 2v22a2 2 0 002 2h8.5a1 1 0 110 2H6a4 4 0 01-4-4V4z\\\" fill=\\\"currentColor\\\"\\/><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M21 8a1 1 0 01-1 1H9a1 1 0 110-2h11a1 1 0 011 1zM21 13a1 1 0 01-1 1H9a1 1 0 110-2h11a1 1 0 011 1zM15 18a1 1 0 01-1 1H9a1 1 0 110-2h5a1 1 0 011 1z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M29.38 26.843l-1.166-.673a5.272 5.272 0 000-1.921l1.166-.674a.33.33 0 00.15-.383 6.816 6.816 0 00-1.497-2.589.33.33 0 00-.405-.063l-1.166.673a5.166 5.166 0 00-1.664-.96v-1.344a.328.328 0 00-.257-.32 6.881 6.881 0 00-2.989 0 .328.328 0 00-.257.32v1.346a5.328 5.328 0 00-1.664.961l-1.163-.673a.325.325 0 00-.405.063 6.775 6.775 0 00-1.498 2.589.327.327 0 00.15.383l1.167.673a5.276 5.276 0 000 1.922l-1.166.673a.33.33 0 00-.15.383 6.817 6.817 0 001.497 2.59.33.33 0 00.405.063l1.166-.674c.49.422 1.053.747 1.664.96v1.348c0 .153.106.287.257.32a6.88 6.88 0 002.989 0 .328.328 0 00.257-.32v-1.347a5.328 5.328 0 001.664-.96l1.166.672a.325.325 0 00.405-.062 6.776 6.776 0 001.497-2.59.338.338 0 00-.153-.386zm-6.333.556a2.193 2.193 0 01-2.19-2.19c0-1.207.983-2.19 2.19-2.19 1.207 0 2.19.983 2.19 2.19 0 1.207-.983 2.19-2.19 2.19z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Form Builder\",\"parent\":1739274871203}],\"width\":{\"xl\":\"71.666667%\",\"lg\":\"71.666667%\",\"md\":\"71.666667%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1739274622483,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"37%\",\"lg\":\"28.333333%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1739338868620,\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":1739338868620,\"global_background_color\":\"#ffffff\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[1739274862484]},{\"id\":1739274862484,\"type\":\"content\",\"name\":\"openstreetmap\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"height\":{\"xl\":\"565\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"map_style\":\"CartoDB.DarkMatter\",\"multi_location_items\":[{\"title\":\"Manhattan Island\",\"location_item\":\"40.7970,-73.9491\",\"location_popup_text\":\"Manhattan Island\"}],\"zoom\":13,\"mousescroll\":0,\"dragging\":0,\"zoomcontrol\":0,\"attribution\":1,\"instFormId\":1739274862484},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M12.3 12.125c-.232-2.793.475-5.33 2.202-7.567.327-.43.691-.823 1.077-1.195.503-.485 1.042-.935 1.582-1.387l.087-.072c-.297-.172-.61-.285-.919-.397-.378-.137-.749-.271-1.074-.507h-.348c-.756.3-1.546.493-2.336.686-.432.105-.864.21-1.29.334-.98.28-1.97.53-2.96.78-.404.102-.809.205-1.213.31l-.024.005c-.175.044-.332.084-.532.017a649.995 649.995 0 00-4.106-1.341l-.089-.029-2.097-.68c-.026 0-.039-.026-.053-.052A.339.339 0 00.19 1H.074l.021.063.087.258.008.027.07.208.07.213.538 1.613c.422 1.262.847 2.525 1.28 3.783.128.36.14.684.012 1.054-.313.91-.617 1.82-.921 2.73-.304.91-.608 1.819-.921 2.729-.116.37-.116.695 0 1.066.231.73.457 1.46.684 2.193.363 1.174.726 2.349 1.112 3.52.127.405.116.764 0 1.17a776.683 776.683 0 00-2.005 6.918c-.011.035-.027.07-.044.105-.048.106-.098.214-.037.335.209.44 1.298.719 1.68.406a8.165 8.165 0 00.319-.278c.233-.213.455-.436.678-.66l.139-.14c1.17-1.176 2.344-2.349 3.517-3.522 1.173-1.174 2.347-2.347 3.517-3.523.417-.417.88-.73 1.483-.556.533.15.939-.012 1.321-.337.117-.095.23-.195.344-.295.203-.18.407-.36.63-.516.278-.197.278-.37.127-.66-.355-.693-.704-1.395-1.053-2.099-.3-.603-.6-1.207-.905-1.806-.174-.348-.29-.73.023-1.009.569-.512.515-1.132.459-1.787a18.783 18.783 0 01-.007-.078zm-1.963.549a5.334 5.334 0 00-.01-.138l-.012-.153-.008-.09v-.003c-.258-3.108.487-6.005 2.316-8.558-.268.067-.525.133-.788.21h-.005c-1.01.29-2.048.552-3.049.805-.398.1-.79.2-1.172.298l-.008.002-.007.002-.03.008c-.174.048-.857.234-1.643-.027-.896-.297-1.79-.59-2.686-.88.265.787.532 1.572.802 2.356.264.75.299 1.538.015 2.364-.31.9-.612 1.802-.916 2.713l-.002.004c-.29.87-.584 1.748-.886 2.627.232.734.454 1.452.674 2.162.358 1.157.71 2.296 1.092 3.455l.004.013.004.013c.261.832.222 1.595.015 2.32l-.003.009-.003.01c-.292.987-.581 1.976-.868 2.965l1.782-1.783.002-.002a2033.18 2033.18 0 003.513-3.519l.004-.003c.465-.466 1.498-1.366 2.968-1.167l-.51-1.025c-.305-.614-.605-1.218-.88-1.756l-.003-.007-.003-.006c-.116-.231-.339-.707-.378-1.292a2.555 2.555 0 01.679-1.927zM30.494 23.273v-.002l-.158-1.294c-.067-.548-.134-1.1-.205-1.662l-.002-.02-.064-.51-.06.026a.914.914 0 00-.172.09c-.536.384-1.083.723-1.643 1.012-2.067 1.069-4.3 1.468-6.735 1.085a.859.859 0 00-.823.324c-.394.487-.834.464-1.333.209-.564-.286-1.128-.561-1.692-.837l-.845-.415-.029-.014c-1.432-.704-1.439-.707-2.475.536l-.046.055c-.287.34-.572.678-.44 1.173.197.742-.14 1.252-.626 1.738A2414.87 2414.87 0 007.9 29.97l-.607.606-.008.007v.001l-.095.095-.29.29c-.037.036-.084.071-.133.108-.137.102-.28.21-.203.355.085.17.237.118.394.065.078-.027.158-.054.232-.054a.342.342 0 00.156-.028l.057-.023c.036-.015.073-.03.111-.041l1.006-.287 1.362-.386.198-.056c1.34-.38 2.68-.76 4.016-1.149a1.838 1.838 0 011.17.035c1.088.394 2.18.784 3.272 1.174.806.287 1.612.575 2.418.866.302.115.58.127.881.011l1.602-.618c1.274-.493 2.55-.986 3.833-1.468.313-.116.51-.301.649-.602.483-1.03.971-2.055 1.458-3.078.33-.694.66-1.386.987-2.08l.025-.049c.063-.12.123-.238.103-.39zM13.024 27.7l.513-.15.01-.002a3.836 3.836 0 012.385.072l.008.003.007.002c1.088.394 2.169.78 3.256 1.168.73.26 1.462.522 2.2.788l1.306-.504c1.173-.454 2.357-.911 3.543-1.359.439-.931.883-1.866 1.325-2.795l.878-1.848-.008-.066a12.588 12.588 0 01-6.726 1.042 2.802 2.802 0 01-1.508.642c-.773.08-1.417-.174-1.82-.38-.551-.28-1.091-.543-1.646-.814-.285-.14-.573-.28-.87-.427l-.027-.013-.027-.013-.015.018a3.38 3.38 0 01-.254 1.716c-.27.63-.688 1.094-.994 1.4l-.008.008-1.528 1.512z\\\" fill=\\\"currentColor\\\"\\/><circle opacity=\\\".5\\\" cx=\\\"24.5\\\" cy=\\\"10.5\\\" r=\\\"7.5\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Open Street Map\",\"parent\":1739338868620}],\"width\":{\"xl\":\"28.333333%\",\"lg\":\"28.333333%\",\"md\":\"28.333333%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":false},{\"id\":\"2Bbm518ecsmM8djMufa_r\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"20px 0px 80px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"10px 0px 20px 0px\",\"xs\":\"   \"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"unit\":\"px\"},\"row_max_width\":{\"unit\":\"px\"},\"row_min_width\":{\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":\"2Bbm518ecsmM8djMufa_r\"},\"layout\":\"6.0+6.0+6.0+6.0\",\"columns\":[{\"id\":1739274622484,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"jGU4bXOt9gNdgkbdlxkbB\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"0px 0px 30px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":\"jGU4bXOt9gNdgkbdlxkbB\",\"global_background_color\":\"#ffffff\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[\"M8RHxd2AguO9dIC7dXVis\"]},{\"id\":\"M8RHxd2AguO9dIC7dXVis\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId p {\\n\\tmargin-bottom: 0px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"230 W Superior, Suite 500 Chicago, Illinois 60654\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h6\",\"instFormId\":\"M8RHxd2AguO9dIC7dXVis\",\"title\":\"ADDRESS\",\"title_typography\":{\"font\":\"\",\"weight\":\"400\",\"uppercase\":true,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"title_text_color\":\"#959595\",\"title_margin_bottom\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":\"jGU4bXOt9gNdgkbdlxkbB\"}],\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"25%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1739274622485,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"c9mDAzRldIviNtifeRjyn\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"0px 0px 30px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":\"c9mDAzRldIviNtifeRjyn\",\"global_background_color\":\"#ffffff\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[\"nxlevSRXd1rnDzEZDdxQR\"]},{\"id\":\"nxlevSRXd1rnDzEZDdxQR\",\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId p {\\n\\tmargin-bottom: 0px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>dennis416@gmail.com<\\/p><p>iva838@outlook.com<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h6\",\"instFormId\":\"nxlevSRXd1rnDzEZDdxQR\",\"title\":\"EMAIL\",\"title_typography\":{\"font\":\"\",\"weight\":\"400\",\"uppercase\":true,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"title_text_color\":\"#959595\",\"title_margin_bottom\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":\"c9mDAzRldIviNtifeRjyn\"}],\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"25%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1739274622486,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":1739275169655,\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"0px 0px 30px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":1739275169655,\"global_background_color\":\"#ffffff\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[1739274983415]},{\"id\":1739274983415,\"type\":\"content\",\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonId p {\\n\\tmargin-bottom: 0px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"text\":\"<p>(830) 556-6651 <\\/p><p>(267) 739-6240<\\/p>\",\"content_truncation\":0,\"content_truncation_max_word\":30,\"content_truncation_action_text\":\"Show More\",\"content_truncation_action_text_color\":\"#3366FF\",\"dropcap\":0,\"heading_selector\":\"h6\",\"instFormId\":1739274983415,\"title\":\"PHONE\",\"title_typography\":{\"font\":\"\",\"weight\":\"400\",\"uppercase\":true,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"title_text_color\":\"#959595\",\"title_margin_bottom\":{\"xl\":\"18\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M23.055 10.419c0-.885-.717-1.602-1.602-1.602H10.547a1.602 1.602 0 000 3.204h3.825v10.118a1.628 1.628 0 103.256 0V12.02h3.825c.885 0 1.602-.718 1.602-1.602z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M5.18 3.42c-.95 0-1.721.758-1.721 1.693V8.5c0 .668-.55 1.21-1.23 1.21A1.22 1.22 0 011 8.5V5.113C1 2.84 2.872 1 5.18 1h2.951c.68 0 1.23.542 1.23 1.21 0 .668-.55 1.21-1.23 1.21h-2.95zM26.82 28.58c.95 0 1.721-.758 1.721-1.693V23.5c0-.668.55-1.21 1.23-1.21.678 0 1.229.542 1.229 1.21v3.387C31 29.16 29.128 31 26.82 31h-2.951a1.22 1.22 0 01-1.23-1.21c0-.668.55-1.21 1.23-1.21h2.95zM26.82 3.42c.95 0 1.721.758 1.721 1.693V8.5c0 .668.55 1.21 1.23 1.21A1.22 1.22 0 0031 8.5V5.113C31 2.84 29.128 1 26.82 1h-2.951c-.68 0-1.23.542-1.23 1.21 0 .668.55 1.21 1.23 1.21h2.95zM5.18 28.58c-.95 0-1.721-.758-1.721-1.693V23.5c0-.668-.55-1.21-1.23-1.21A1.22 1.22 0 001 23.5v3.387C1 29.16 2.872 31 5.18 31h2.951a1.22 1.22 0 001.23-1.21c0-.668-.55-1.21-1.23-1.21h-2.95z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Text Block\",\"parent\":1739275169655}],\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"25%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":1739274622487,\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"50%\",\"md\":\"50%\",\"sm\":\"100%\",\"xs\":\"100%\"}},\"addons\":[{\"id\":\"DaqCBiBqPtFZa83ivlBE_\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"40px 40px 40px 40px\",\"lg\":\"35px 35px 35px 35px\",\"md\":\"30px 30px 30px 30px\",\"sm\":\"25px 25px 25px 25px\",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"   \",\"lg\":\"0px 0px 30px 0px\",\"md\":\"0px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"color\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"4\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"shadow-default\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\",\"instFormId\":\"DaqCBiBqPtFZa83ivlBE_\",\"global_background_color\":\"#ffffff\"},\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"title\":\"Div\",\"parent\":false,\"children\":[1739342343426]},{\"id\":1739342343426,\"type\":\"repeatable\",\"name\":\"icons_group\",\"visibility\":true,\"settings\":{\"global_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_margin\":{\"xl\":\"0px 0px 22px 0px\",\"lg\":\"   \",\"md\":\"0px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"#addonWrapper #addonId .sppb-icons-group-list li {\\n    margin: 0px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"sp_icons_group_item\":[{\"icon_name\":\"fab fa-spotify\",\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"height\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":true,\"icon_class\":\"\",\"admin_label\":\"Item 1\",\"icon_link\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":3},\"border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"#919fad\",\"hover_color\":\"var(--link-color)\",\"title\":\"spotify\"},{\"icon_name\":\"fab fa-x-twitter\",\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"height\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":true,\"icon_class\":\"\",\"admin_label\":\"Item 1\",\"icon_link\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":3},\"border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"#919fad\",\"hover_color\":\"var(--link-color)\",\"title\":\"twitter\"},{\"icon_name\":\"fab fa-facebook-f\",\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"height\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":true,\"icon_class\":\"\",\"admin_label\":\"Item 1\",\"icon_link\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":3},\"border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"#919fad\",\"hover_color\":\"var(--link-color)\",\"title\":\"facebook\"},{\"icon_name\":\"fab fa-linkedin-in\",\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"height\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":true,\"icon_class\":\"\",\"admin_label\":\"Item 1\",\"icon_link\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":3},\"border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"#919fad\",\"hover_color\":\"var(--link-color)\",\"title\":\"linkedin\"},{\"icon_name\":\"fab fa-instagram\",\"width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"height\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":true,\"icon_class\":\"\",\"admin_label\":\"Item 1\",\"icon_link\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":3},\"border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"color\":\"#919fad\",\"hover_color\":\"var(--link-color)\",\"title\":\"instagram\"}],\"icon_alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"size\":{\"xl\":\"20\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"margin\":{\"xl\":\"13\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"item_display\":\"inline-block\",\"heading_selector\":\"h6\",\"title_position\":\"top\",\"title_icon_position\":\"before\",\"instFormId\":1739342343426,\"title_margin\":{\"xl\":\"0px 0px 20px 0px\",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"xl\":\"   \",\"lg\":\"   \",\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title\":\"FOLLOW US\",\"title_typography\":{\"font\":\"\",\"weight\":\"400\",\"uppercase\":true,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}},\"title_text_color\":\"#959595\",\"row_boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\"},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M30.992 7.064c0 1.33-.02 2.66.007 3.99.02.931-.351 1.634-1.068 2.186-1.49 1.15-4.02 1.095-5.44-.131-1.276-1.096-1.193-2.82.2-3.777 1.282-.882 2.675-.986 4.137-.538.4.124.413.124.413-.275 0-1.765-.007-3.53.007-5.293 0-.345-.117-.414-.42-.359-1.283.22-2.572.427-3.854.648-1 .165-2 .358-3.006.503-.31.041-.359.172-.359.441.007 2.833 0 5.659.007 8.491 0 .958-.393 1.696-1.165 2.247-1.469 1.047-3.875.992-5.295-.124-1.31-1.034-1.317-2.784.02-3.79 1.283-.966 2.71-1.076 4.213-.628.434.131.434.138.434-.31V4.501c0-1.49.49-2.034 1.945-2.268 2.427-.386 4.853-.792 7.273-1.206 1.014-.172 1.91.496 1.93 1.53.028 1.502.008 3.005.008 4.5 0 .007.006.007.013.007zM17.9 12.22c-.559-.035-1.096.082-1.572.427s-.483.737-.014 1.082c.828.613 2.31.606 3.144-.007.469-.345.476-.696.014-1.054-.455-.359-.986-.483-1.572-.448zm9.5.069a2.325 2.325 0 001.517-.497c.393-.303.4-.606.041-.937-.772-.717-2.53-.717-3.316-.007-.365.33-.358.62.035.937.469.373 1.013.504 1.723.504z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M9.413 30.993h-6.64c-1.15 0-1.757-.585-1.764-1.75-.014-1.882-.007-3.756-.007-5.638 0-1.413-.007-2.819.02-4.225.014-.827.69-1.447 1.524-1.454.8-.007 1.606-.014 2.406.007.331.007.552-.069.648-.407.035-.13.124-.24.18-.372.324-.806.923-1.13 1.785-1.11 1.33.028 2.661.014 3.992.014.627 0 1.144.297 1.33.855.297.875.821 1.137 1.697 1.02.537-.076 1.096-.014 1.647-.014.91.007 1.593.683 1.593 1.585v9.904c0 .896-.69 1.578-1.6 1.578-2.268.007-4.543.007-6.811.007zm.007-1.792c2.089 0 4.17-.006 6.26.007.262 0 .358-.069.358-.344-.006-2.936-.006-5.872 0-8.801 0-.27-.075-.352-.344-.352-1.02.014-2.041 0-3.062.014-.227 0-.358-.076-.454-.276-.207-.448-.442-.882-.649-1.33-.096-.213-.227-.31-.475-.31-1.103.007-2.2.007-3.303 0-.227 0-.358.09-.448.29-.2.434-.434.861-.627 1.295-.11.241-.255.338-.531.331-.986-.014-1.972.007-2.958-.014-.324-.007-.434.083-.434.42.014 2.875.014 5.755 0 8.63 0 .337.09.454.441.454 2.075-.02 4.15-.014 6.226-.014z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M1.016 5.486C.982 2.916 2.988.924 5.498 1.006A4.367 4.367 0 018.152 2c.228.186.38.207.634.007 2.682-2.088 6.474-.758 7.088 2.653.276 1.537-.22 2.867-1.31 3.97A1554.577 1554.577 0 019.8 13.44c-.848.855-1.806.855-2.654.008a620.546 620.546 0 01-4.744-4.783c-.882-.896-1.42-1.95-1.386-3.178zm4.296-2.694c-.559 0-1.014.144-1.448.455-1.365.978-1.476 2.867-.228 4.142 1.538 1.57 3.096 3.128 4.64 4.7.214.214.345.22.552 0 .834-.896 1.689-1.778 2.53-2.667.752-.793 1.537-1.551 2.234-2.385.972-1.165.696-2.929-.524-3.797-.986-.703-2.393-.58-3.358.296-.344.317-.675.655-.993 1-.172.185-.29.234-.482.013-.297-.338-.62-.64-.945-.951-.551-.53-1.206-.813-1.978-.806zM26.566 22.599c1 0 1.993.007 2.992 0 .242 0 .324.034.173.282-1.49 2.53-2.965 5.06-4.447 7.589-.304.517-.807.668-1.248.4-.462-.276-.572-.807-.269-1.317.938-1.585 1.882-3.17 2.82-4.756.214-.358.193-.4-.214-.4H20.7c-.372 0-.372 0-.207-.337 1.22-2.447 2.448-4.893 3.668-7.34.172-.345.38-.634.807-.655.737-.048 1.192.607.861 1.29-.523 1.095-1.075 2.17-1.62 3.259-.275.551-.544 1.11-.834 1.654-.131.248-.103.338.2.338 1-.014 2-.007 2.992-.007z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M5.71 24.46c0-2.054 1.662-3.729 3.71-3.715 1.985.014 3.716 1.53 3.702 3.722-.014 2.219-1.744 3.673-3.695 3.7-2.048.028-3.716-1.654-3.716-3.707zm3.73-1.923c-1.082-.007-1.895.806-1.95 1.84-.063 1.185.965 2.026 1.888 2.013 1.083-.014 1.965-.855 1.965-1.916a1.918 1.918 0 00-1.903-1.937z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Icons Group\",\"parent\":\"DaqCBiBqPtFZa83ivlBE_\"}],\"width\":{\"xl\":\"25%\",\"lg\":\"25%\",\"md\":\"25%\",\"sm\":\"100%\",\"xs\":\"100%\"}}],\"parent\":false}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2018-02-22 09:31:28', 871, '2025-02-12 07:36:32', 752, 0, '0000-00-00 00:00:00', '{\"meta_description\":\"\",\"meta_keywords\":\"\",\"robots\":\"\",\"seo_spacer\":\"\",\"author\":\"\",\"og_type\":\"website\"}', '', '', '', '*', 120, '', '5.5.1'),
(11, 118, 'Bottom Information ', '', '[{\"id\":\"e67832e3-d6ae-49e1-98f8-134a0b97e131\",\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"fit_columns\":{\"xl\":true,\"sm\":false},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"external_background_video\":0,\"background_video_ogv\":{\"src\":\"\"},\"video_loop\":1,\"padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"columns_align_center\":0,\"columns_content_alignment\":\"center\",\"stretch_section\":0,\"fullscreen\":0,\"no_gutter\":0,\"row_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_max_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_min_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"row_border\":0,\"row_border_style\":\"solid\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"xl\":100,\"lg\":100,\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"xl\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"acl\":\"\",\"row_boxshadow\":\"0 0 0 0 #FFFFFF\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"center\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"columns_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\",\"unit\":\"px\"},\"id\":\"\",\"class\":\"\"},\"layout\":\"3+5+4\",\"columns\":[{\"id\":\"21cef2dc-a466-4c11-bfd9-d70cef787d32\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"25%\",\"lg\":\"30%\",\"md\":\"30%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"25%\"},\"class\":\"\"},\"addons\":[{\"id\":\"2a8d3194-6cc5-4eff-800a-c3e9f1cb21c7\",\"type\":\"content\",\"name\":\"raw_html\",\"visibility\":true,\"title\":\"Raw HTML\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path opacity=\\\".5\\\" d=\\\"M31.058 14.944l-6.57-5.946a1.686 1.686 0 10-2.258 2.503l5.572 5.016-5.572 5.017a1.686 1.686 0 102.259 2.503l6.569-5.946a2.16 2.16 0 000-3.19v.043zM.706 18.09l6.57 5.947a1.686 1.686 0 102.258-2.503l-5.572-5.017 5.572-5.016a1.686 1.686 0 10-2.259-2.503L.706 14.944a2.16 2.16 0 000 3.19v-.043z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M19.028 1.031a1.549 1.549 0 00-1.175.234 1.604 1.604 0 00-.673 1.008l-5.426 26.844c-.082.414 0 .844.229 1.197.228.353.584.6.99.686h.314c.356 0 .701-.122.98-.348.278-.226.473-.54.553-.894l5.427-26.844a1.627 1.627 0 00-.23-1.197 1.572 1.572 0 00-.99-.686z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"#addonId svg{\\nwidth:215px;\\n}\\n\\n@media (max-width:991px) and (min-width:768px){\\n    #addonId svg{\\nwidth:165px;\\n}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"html\":\"<svg width=\\\"384\\\" height=\\\"66\\\" viewBox=\\\"0 0 384 66\\\" fill=\\\"none\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\">\\n  <path d=\\\"M45.4463 3.72802L54.2517 45.8874C54.3012 46.1244 54.5101 46.2942 54.7522 46.2942H96.9198C97.1621 46.2942 97.3712 46.1241 97.4204 45.8868L106.04 4.34321C106.106 4.02582 105.864 3.72803 105.54 3.72803L13.0264 3.72803M32.7116 19.0672H102.985M39.103 33.0003H87.0378\\\" stroke=\\\"var(--link-color)\\\" stroke-width=\\\"4.09044\\\" \\/>\\n  <path d=\\\"M0.882812 3.85596H7.91326\\\" stroke=\\\"var(--link-color)\\\" stroke-width=\\\"4.09044\\\" \\/>\\n  <path d=\\\"M20.6958 19.3228H26.9593\\\" stroke=\\\"var(--link-color)\\\" stroke-width=\\\"4.09044\\\" \\/>\\n  <path d=\\\"M18.6504 33.2559H32.5835\\\" stroke=\\\"var(--link-color)\\\" stroke-width=\\\"4.09044\\\" \\/>\\n  <circle cx=\\\"62.5374\\\" cy=\\\"59.4495\\\" r=\\\"6.18878\\\" fill=\\\"var(--link-color)\\\" \\/>\\n  <circle cx=\\\"88.1028\\\" cy=\\\"59.4495\\\" r=\\\"6.18878\\\" fill=\\\"var(--link-color)\\\" \\/>\\n  <path d=\\\"M157.577 17.9721H157.319L154.278 24.0021L145.671 39.6699L137.064 24.0021L134.024 17.9721H133.766V48.2769H129.54V12.3028H135.312L145.62 31.6814H145.877L156.237 12.3028H161.803V48.2769H157.577V17.9721ZM180.951 48.8953C179.13 48.8953 177.48 48.5689 176.003 47.9161C174.56 47.2633 173.306 46.3356 172.241 45.133C171.21 43.8961 170.402 42.4358 169.818 40.7522C169.269 39.0342 168.994 37.1101 168.994 34.9799C168.994 32.884 169.269 30.977 169.818 29.2591C170.402 27.5411 171.21 26.0809 172.241 24.8783C173.306 23.6414 174.56 22.6965 176.003 22.0437C177.48 21.3908 179.13 21.0644 180.951 21.0644C182.737 21.0644 184.335 21.3908 185.744 22.0437C187.153 22.6965 188.355 23.607 189.352 24.7752C190.348 25.9091 191.104 27.2662 191.619 28.8468C192.169 30.4273 192.444 32.1624 192.444 34.0522V36.0106H173.323V37.2476C173.323 38.3814 173.495 39.4466 173.838 40.443C174.216 41.405 174.732 42.2468 175.385 42.9684C176.072 43.6899 176.896 44.2568 177.858 44.6691C178.855 45.0815 179.972 45.2876 181.208 45.2876C182.892 45.2876 184.352 44.8925 185.589 44.1022C186.861 43.312 187.84 42.1781 188.527 40.7007L191.465 42.8138C190.606 44.6348 189.266 46.1122 187.445 47.2461C185.624 48.3456 183.459 48.8953 180.951 48.8953ZM180.951 24.5175C179.817 24.5175 178.786 24.7237 177.858 25.136C176.931 25.5139 176.123 26.0637 175.436 26.7852C174.783 27.5068 174.268 28.3657 173.89 29.3622C173.512 30.3242 173.323 31.3893 173.323 32.5576V32.9183H188.012V32.3514C188.012 29.9806 187.359 28.0909 186.053 26.6821C184.782 25.2391 183.081 24.5175 180.951 24.5175ZM221.657 51.2146C221.657 53.9633 220.575 55.9733 218.411 57.2446C216.28 58.5502 213.068 59.2031 208.773 59.2031C204.615 59.2031 201.626 58.6361 199.805 57.5023C197.984 56.3684 197.073 54.7536 197.073 52.6576C197.073 51.2146 197.451 50.0807 198.207 49.2561C198.963 48.4658 199.994 47.8817 201.3 47.5038V46.9368C199.719 46.1809 198.929 44.944 198.929 43.2261C198.929 41.8861 199.358 40.8725 200.217 40.1853C201.076 39.4637 202.176 38.9312 203.516 38.5876V38.3814C201.935 37.6255 200.698 36.5432 199.805 35.1345C198.946 33.7258 198.517 32.0937 198.517 30.2383C198.517 28.8983 198.757 27.6614 199.238 26.5275C199.719 25.3937 200.389 24.4316 201.248 23.6414C202.141 22.8167 203.189 22.1811 204.392 21.7344C205.629 21.2878 207.003 21.0644 208.515 21.0644C210.405 21.0644 212.088 21.408 213.566 22.0952V21.6313C213.566 20.6006 213.806 19.7588 214.287 19.1059C214.768 18.4188 215.559 18.0752 216.658 18.0752H220.627V21.6829H215.576V23.3837C216.538 24.2083 217.277 25.2047 217.792 26.3729C218.342 27.5068 218.617 28.7952 218.617 30.2383C218.617 31.5783 218.376 32.8152 217.895 33.9491C217.414 35.0829 216.727 36.0622 215.834 36.8868C214.975 37.6771 213.927 38.2955 212.69 38.7422C211.453 39.1889 210.078 39.4122 208.567 39.4122C207.708 39.4122 206.849 39.3263 205.99 39.1545C205.096 39.395 204.289 39.7558 203.567 40.2368C202.846 40.6835 202.485 41.3191 202.485 42.1438C202.485 42.934 202.863 43.4666 203.619 43.7414C204.375 44.0163 205.354 44.1538 206.557 44.1538H212.226C215.524 44.1538 217.912 44.7894 219.39 46.0607C220.902 47.2976 221.657 49.0156 221.657 51.2146ZM217.792 51.5238C217.792 50.4587 217.38 49.5997 216.555 48.9469C215.765 48.3284 214.339 48.0192 212.277 48.0192H203.413C201.764 48.7751 200.939 49.9776 200.939 51.6269C200.939 52.7951 201.368 53.7915 202.227 54.6161C203.121 55.4407 204.615 55.853 206.711 55.853H210.525C212.827 55.853 214.614 55.4923 215.885 54.7707C217.156 54.0492 217.792 52.9669 217.792 51.5238ZM208.567 36.1137C210.319 36.1137 211.71 35.7014 212.741 34.8768C213.772 34.0178 214.287 32.7122 214.287 30.9599V29.5168C214.287 27.7645 213.772 26.476 212.741 25.6514C211.71 24.7924 210.319 24.3629 208.567 24.3629C206.814 24.3629 205.423 24.7924 204.392 25.6514C203.361 26.476 202.846 27.7645 202.846 29.5168V30.9599C202.846 32.7122 203.361 34.0178 204.392 34.8768C205.423 35.7014 206.814 36.1137 208.567 36.1137ZM245.643 48.2769C244.097 48.2769 242.98 47.8645 242.293 47.0399C241.64 46.2153 241.228 45.1845 241.056 43.9476H240.798C240.214 45.5968 239.252 46.8338 237.912 47.6584C236.572 48.483 234.975 48.8953 233.119 48.8953C230.302 48.8953 228.103 48.1738 226.522 46.7307C224.976 45.2876 224.203 43.3291 224.203 40.8553C224.203 38.3471 225.114 36.423 226.935 35.0829C228.79 33.7429 231.659 33.0729 235.542 33.0729H240.798V30.4445C240.798 28.5547 240.283 27.1116 239.252 26.1152C238.222 25.1188 236.641 24.6206 234.511 24.6206C232.896 24.6206 231.539 24.9814 230.439 25.7029C229.374 26.4244 228.481 27.3865 227.759 28.5891L225.285 26.2698C226.007 24.8267 227.158 23.607 228.738 22.6106C230.319 21.5798 232.312 21.0644 234.717 21.0644C237.947 21.0644 240.455 21.8547 242.242 23.4352C244.028 25.0157 244.922 27.2147 244.922 30.0322V44.6691H247.962V48.2769H245.643ZM233.789 45.3907C234.82 45.3907 235.765 45.2704 236.624 45.0299C237.483 44.7894 238.222 44.4458 238.84 43.9991C239.458 43.5525 239.939 43.0371 240.283 42.453C240.627 41.8689 240.798 41.2332 240.798 40.5461V36.1653H235.335C232.965 36.1653 231.229 36.5089 230.13 37.196C229.065 37.8832 228.532 38.8796 228.532 40.1853V41.2676C228.532 42.5732 228.996 43.5868 229.924 44.3084C230.886 45.0299 232.174 45.3907 233.789 45.3907ZM254.259 12.3028H266.319C268.553 12.3028 270.58 12.6808 272.401 13.4367C274.222 14.1926 275.768 15.3264 277.039 16.8382C278.345 18.3157 279.341 20.1883 280.029 22.456C280.716 24.6893 281.059 27.3006 281.059 30.2898C281.059 33.2791 280.716 35.9076 280.029 38.1753C279.341 40.4086 278.345 42.2812 277.039 43.793C275.768 45.2704 274.222 46.3871 272.401 47.143C270.58 47.8989 268.553 48.2769 266.319 48.2769H254.259V12.3028ZM266.319 44.463C267.797 44.463 269.154 44.2225 270.391 43.7414C271.628 43.2261 272.693 42.4873 273.586 41.5253C274.48 40.5632 275.167 39.395 275.648 38.0207C276.163 36.6119 276.421 35.0142 276.421 33.2276V27.3521C276.421 25.5655 276.163 23.9849 275.648 22.6106C275.167 21.2019 274.48 20.0165 273.586 19.0544C272.693 18.0924 271.628 17.3708 270.391 16.8898C269.154 16.3744 267.797 16.1167 266.319 16.1167H258.589V44.463H266.319ZM298.423 48.8953C296.602 48.8953 294.952 48.5689 293.475 47.9161C292.032 47.2633 290.778 46.3356 289.713 45.133C288.682 43.8961 287.874 42.4358 287.29 40.7522C286.741 39.0342 286.466 37.1101 286.466 34.9799C286.466 32.884 286.741 30.977 287.29 29.2591C287.874 27.5411 288.682 26.0809 289.713 24.8783C290.778 23.6414 292.032 22.6965 293.475 22.0437C294.952 21.3908 296.602 21.0644 298.423 21.0644C300.209 21.0644 301.807 21.3908 303.216 22.0437C304.625 22.6965 305.827 23.607 306.824 24.7752C307.82 25.9091 308.576 27.2662 309.091 28.8468C309.641 30.4273 309.916 32.1624 309.916 34.0522V36.0106H290.795V37.2476C290.795 38.3814 290.967 39.4466 291.31 40.443C291.688 41.405 292.204 42.2468 292.857 42.9684C293.544 43.6899 294.368 44.2568 295.33 44.6691C296.327 45.0815 297.444 45.2876 298.68 45.2876C300.364 45.2876 301.824 44.8925 303.061 44.1022C304.333 43.312 305.312 42.1781 305.999 40.7007L308.937 42.8138C308.078 44.6348 306.738 46.1122 304.917 47.2461C303.096 48.3456 300.931 48.8953 298.423 48.8953ZM298.423 24.5175C297.289 24.5175 296.258 24.7237 295.33 25.136C294.403 25.5139 293.595 26.0637 292.908 26.7852C292.255 27.5068 291.74 28.3657 291.362 29.3622C290.984 30.3242 290.795 31.3893 290.795 32.5576V32.9183H305.484V32.3514C305.484 29.9806 304.831 28.0909 303.525 26.6821C302.254 25.2391 300.553 24.5175 298.423 24.5175ZM336.037 48.2769C334.491 48.2769 333.374 47.8645 332.687 47.0399C332.034 46.2153 331.622 45.1845 331.45 43.9476H331.192C330.608 45.5968 329.646 46.8338 328.306 47.6584C326.966 48.483 325.369 48.8953 323.513 48.8953C320.696 48.8953 318.497 48.1738 316.916 46.7307C315.37 45.2876 314.597 43.3291 314.597 40.8553C314.597 38.3471 315.508 36.423 317.329 35.0829C319.184 33.7429 322.053 33.0729 325.936 33.0729H331.192V30.4445C331.192 28.5547 330.677 27.1116 329.646 26.1152C328.616 25.1188 327.035 24.6206 324.905 24.6206C323.29 24.6206 321.933 24.9814 320.833 25.7029C319.768 26.4244 318.875 27.3865 318.153 28.5891L315.679 26.2698C316.401 24.8267 317.552 23.607 319.132 22.6106C320.713 21.5798 322.706 21.0644 325.111 21.0644C328.341 21.0644 330.849 21.8547 332.636 23.4352C334.422 25.0157 335.316 27.2147 335.316 30.0322V44.6691H338.356V48.2769H336.037ZM324.183 45.3907C325.214 45.3907 326.159 45.2704 327.018 45.0299C327.877 44.7894 328.616 44.4458 329.234 43.9991C329.852 43.5525 330.334 43.0371 330.677 42.453C331.021 41.8689 331.192 41.2332 331.192 40.5461V36.1653H325.729C323.359 36.1653 321.623 36.5089 320.524 37.196C319.459 37.8832 318.926 38.8796 318.926 40.1853V41.2676C318.926 42.5732 319.39 43.5868 320.318 44.3084C321.28 45.0299 322.568 45.3907 324.183 45.3907ZM348.622 48.2769C347.179 48.2769 346.079 47.8817 345.323 47.0915C344.602 46.2668 344.241 45.2361 344.241 43.9991V10.1382H348.364V44.6691H352.281V48.2769H348.622Z\\\" fill=\\\"#ffffff\\\" \\/>\\n  <path d=\\\"M363.559 15.4467C362.666 15.4467 362.013 15.2405 361.601 14.8282C361.223 14.3816 361.034 13.8146 361.034 13.1275V12.4575C361.034 11.7703 361.223 11.2205 361.601 10.8082C362.013 10.3616 362.666 10.1382 363.559 10.1382C364.453 10.1382 365.088 10.3616 365.466 10.8082C365.879 11.2205 366.085 11.7703 366.085 12.4575V13.1275C366.085 13.8146 365.879 14.3816 365.466 14.8282C365.088 15.2405 364.453 15.4467 363.559 15.4467ZM361.498 21.6829H365.621V48.2769H361.498V21.6829ZM376.444 15.4467C375.551 15.4467 374.898 15.2405 374.485 14.8282C374.108 14.3816 373.919 13.8146 373.919 13.1275V12.4575C373.919 11.7703 374.108 11.2205 374.485 10.8082C374.898 10.3616 375.551 10.1382 376.444 10.1382C377.337 10.1382 377.973 10.3616 378.351 10.8082C378.763 11.2205 378.969 11.7703 378.969 12.4575V13.1275C378.969 13.8146 378.763 14.3816 378.351 14.8282C377.973 15.2405 377.337 15.4467 376.444 15.4467ZM374.382 21.6829H378.506V48.2769H374.382V21.6829Z\\\" fill=\\\"var(--link-color)\\\" \\/>\\n<\\/svg>\",\"heading_selector\":\"h3\",\"title\":\"\"}},{\"id\":\"aec3d746-16ba-4364-9042-fbf87582dd1e\",\"type\":\"repeatable\",\"name\":\"icons_group\",\"visibility\":true,\"title\":\"Icons Group\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M30.992 7.064c0 1.33-.02 2.66.007 3.99.02.931-.351 1.634-1.068 2.186-1.49 1.15-4.02 1.095-5.44-.131-1.276-1.096-1.193-2.82.2-3.777 1.282-.882 2.675-.986 4.137-.538.4.124.413.124.413-.275 0-1.765-.007-3.53.007-5.293 0-.345-.117-.414-.42-.359-1.283.22-2.572.427-3.854.648-1 .165-2 .358-3.006.503-.31.041-.359.172-.359.441.007 2.833 0 5.659.007 8.491 0 .958-.393 1.696-1.165 2.247-1.469 1.047-3.875.992-5.295-.124-1.31-1.034-1.317-2.784.02-3.79 1.283-.966 2.71-1.076 4.213-.628.434.131.434.138.434-.31V4.501c0-1.49.49-2.034 1.945-2.268 2.427-.386 4.853-.792 7.273-1.206 1.014-.172 1.91.496 1.93 1.53.028 1.502.008 3.005.008 4.5 0 .007.006.007.013.007zM17.9 12.22c-.559-.035-1.096.082-1.572.427s-.483.737-.014 1.082c.828.613 2.31.606 3.144-.007.469-.345.476-.696.014-1.054-.455-.359-.986-.483-1.572-.448zm9.5.069a2.325 2.325 0 001.517-.497c.393-.303.4-.606.041-.937-.772-.717-2.53-.717-3.316-.007-.365.33-.358.62.035.937.469.373 1.013.504 1.723.504z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M9.413 30.993h-6.64c-1.15 0-1.757-.585-1.764-1.75-.014-1.882-.007-3.756-.007-5.638 0-1.413-.007-2.819.02-4.225.014-.827.69-1.447 1.524-1.454.8-.007 1.606-.014 2.406.007.331.007.552-.069.648-.407.035-.13.124-.24.18-.372.324-.806.923-1.13 1.785-1.11 1.33.028 2.661.014 3.992.014.627 0 1.144.297 1.33.855.297.875.821 1.137 1.697 1.02.537-.076 1.096-.014 1.647-.014.91.007 1.593.683 1.593 1.585v9.904c0 .896-.69 1.578-1.6 1.578-2.268.007-4.543.007-6.811.007zm.007-1.792c2.089 0 4.17-.006 6.26.007.262 0 .358-.069.358-.344-.006-2.936-.006-5.872 0-8.801 0-.27-.075-.352-.344-.352-1.02.014-2.041 0-3.062.014-.227 0-.358-.076-.454-.276-.207-.448-.442-.882-.649-1.33-.096-.213-.227-.31-.475-.31-1.103.007-2.2.007-3.303 0-.227 0-.358.09-.448.29-.2.434-.434.861-.627 1.295-.11.241-.255.338-.531.331-.986-.014-1.972.007-2.958-.014-.324-.007-.434.083-.434.42.014 2.875.014 5.755 0 8.63 0 .337.09.454.441.454 2.075-.02 4.15-.014 6.226-.014z\\\" fill=\\\"currentColor\\\"\\/><path d=\\\"M1.016 5.486C.982 2.916 2.988.924 5.498 1.006A4.367 4.367 0 018.152 2c.228.186.38.207.634.007 2.682-2.088 6.474-.758 7.088 2.653.276 1.537-.22 2.867-1.31 3.97A1554.577 1554.577 0 019.8 13.44c-.848.855-1.806.855-2.654.008a620.546 620.546 0 01-4.744-4.783c-.882-.896-1.42-1.95-1.386-3.178zm4.296-2.694c-.559 0-1.014.144-1.448.455-1.365.978-1.476 2.867-.228 4.142 1.538 1.57 3.096 3.128 4.64 4.7.214.214.345.22.552 0 .834-.896 1.689-1.778 2.53-2.667.752-.793 1.537-1.551 2.234-2.385.972-1.165.696-2.929-.524-3.797-.986-.703-2.393-.58-3.358.296-.344.317-.675.655-.993 1-.172.185-.29.234-.482.013-.297-.338-.62-.64-.945-.951-.551-.53-1.206-.813-1.978-.806zM26.566 22.599c1 0 1.993.007 2.992 0 .242 0 .324.034.173.282-1.49 2.53-2.965 5.06-4.447 7.589-.304.517-.807.668-1.248.4-.462-.276-.572-.807-.269-1.317.938-1.585 1.882-3.17 2.82-4.756.214-.358.193-.4-.214-.4H20.7c-.372 0-.372 0-.207-.337 1.22-2.447 2.448-4.893 3.668-7.34.172-.345.38-.634.807-.655.737-.048 1.192.607.861 1.29-.523 1.095-1.075 2.17-1.62 3.259-.275.551-.544 1.11-.834 1.654-.131.248-.103.338.2.338 1-.014 2-.007 2.992-.007z\\\" fill=\\\"currentColor\\\"\\/><path opacity=\\\".5\\\" d=\\\"M5.71 24.46c0-2.054 1.662-3.729 3.71-3.715 1.985.014 3.716 1.53 3.702 3.722-.014 2.219-1.744 3.673-3.695 3.7-2.048.028-3.716-1.654-3.716-3.707zm3.73-1.923c-1.082-.007-1.895.806-1.95 1.84-.063 1.185.965 2.026 1.888 2.013 1.083-.014 1.965-.855 1.965-1.916a1.918 1.918 0 00-1.903-1.937z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"100px 0px 0px 0px\",\"sm\":\"0px 0px 40px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"#addonId .sppb-addon-icons-group ul{\\n    gap: 24px;\\n    display: flex;\\n    justify-content: flex-start;\\n}\\n\\n@media(max-width:991px){\\n#addonId .sppb-addon-icons-group ul {\\n    gap: 16px;\\n}\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"sp_icons_group_item\":[{\"icon_name\":\"fab fa-spotify\",\"width\":{\"xl\":\"\"},\"height\":{\"xl\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":1,\"icon_class\":\"\",\"admin_label\":\"Item 1\",\"title\":\"spotify\",\"icon_link\":{\"type\":\"url\",\"url\":\"#\",\"menu\":\"\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"color\":\"#919FAD\",\"hover_color\":\"#FFFFFF\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"icon_name\":\"fab fa-x-twitter\",\"width\":{\"xl\":\"\"},\"height\":{\"xl\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":1,\"icon_class\":\"\",\"admin_label\":\"Item 1 copy\",\"title\":\"twitter\",\"icon_link\":{\"type\":\"url\",\"url\":\"#\",\"menu\":\"\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"color\":\"#919FAD\",\"hover_color\":\"#FFFFFF\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"icon_name\":\"fab fa-facebook-f\",\"width\":{\"xl\":\"\"},\"height\":{\"xl\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":1,\"icon_class\":\"\",\"admin_label\":\"Item 1 copy copy\",\"title\":\"facebook\",\"icon_link\":{\"type\":\"url\",\"url\":\"#\",\"menu\":\"\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"color\":\"#919FAD\",\"hover_color\":\"#FFFFFF\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"icon_name\":\"fab fa-linkedin-in\",\"width\":{\"xl\":\"\"},\"height\":{\"xl\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":1,\"icon_class\":\"\",\"admin_label\":\"Item 1 copy copy copy\",\"title\":\"linkedin\",\"icon_link\":{\"type\":\"url\",\"url\":\"#\",\"menu\":\"\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"color\":\"#919FAD\",\"hover_color\":\"#FFFFFF\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}},{\"icon_name\":\"fab fa-instagram\",\"width\":{\"xl\":\"\"},\"height\":{\"xl\":\"\"},\"border_style\":\"none\",\"padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"show_label\":0,\"label_position\":\"top\",\"use_hover\":1,\"icon_class\":\"\",\"admin_label\":\"Item 1 copy copy copy copy\",\"title\":\"instagram\",\"icon_link\":{\"type\":\"url\",\"url\":\"#\",\"menu\":\"\",\"page\":0,\"popup\":0,\"action\":\"\",\"is_no_repeat\":0,\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"color\":\"#919FAD\",\"hover_color\":\"#FFFFFF\",\"label_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}}],\"icon_alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"size\":{\"xl\":\"18\",\"sm\":\"16\"},\"margin\":{\"xl\":\"0\"},\"item_display\":\"inline-block\",\"heading_selector\":\"h3\",\"title_position\":\"top\",\"title_icon_position\":\"before\",\"title\":\"\",\"title_typography\":{\"font\":\"\",\"size\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":\"\",\"italic\":\"\",\"underline\":\"\",\"weight\":\"\",\"type\":\"google\"}}}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"a55468da-bcf4-40e2-9e7a-2621b043316d\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",\"hidden_xs\":\"\",\"enable_animation\":\"1\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"width\":{\"xl\":\"41.666667%\",\"lg\":\"70%\",\"md\":\"70%\",\"sm\":\"100%\",\"xs\":\"100%\",\"unit\":\"41.666667%\"},\"class\":\"\"},\"addons\":[{\"id\":\"4bb026bd-d939-4487-8758-2376124a09e8\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"304e8e27-148a-42b4-8675-5f4d81d44c40\",\"3f045ef3-0e3f-4ec9-b5b7-5b0925fcfddd\"],\"parent\":\"83f5726f-3b58-42ca-a145-a99b2028c96f\"},{\"id\":\"7355f439-c5cf-44e7-b9b8-46edfa419b12\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"2f408bf2-c9f5-4686-b2da-a30f9005c817\",\"4bb19d15-7684-44a5-ba30-7489ce785937\"],\"parent\":\"83f5726f-3b58-42ca-a145-a99b2028c96f\"},{\"id\":\"2c83eac1-7aeb-43c0-9ea8-c303ff044a1d\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"block\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"align_items\":{\"xl\":\"center\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"overflow\":\"visible\"},\"children\":[\"3cda2330-8e91-4f35-8282-ba034bb2ebb9\",\"b9f33a76-d848-478b-9b98-9801544473e1\"],\"parent\":\"83f5726f-3b58-42ca-a145-a99b2028c96f\"},{\"id\":\"3cda2330-8e91-4f35-8282-ba034bb2ebb9\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 20px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"SHOP\",\"heading_selector\":\"h3\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"instFormId\":\"304e8e27-148a-42b4-8675-5f4d81d44c40\",\"style_tab\":\"normal\",\"responsive_menu_tab\":\"normal\",\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"title_color\":{\"color\":\"#FFFFFF\",\"type\":\"solid\"},\"heading_typography\":{\"font\":\"Poppins\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":true,\"italic\":\"\",\"underline\":\"\",\"weight\":\"500\",\"type\":\"google\"}},\"parent\":\"2c83eac1-7aeb-43c0-9ea8-c303ff044a1d\"},{\"id\":\"b9f33a76-d848-478b-9b98-9801544473e1\",\"type\":\"general\",\"name\":\"navigation\",\"visibility\":true,\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"#addonId ul{\\n    display: flex;\\n    flex-direction: column;\\n    gap: 10px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"sp_link_list_item\":[{\"title\":\"All products\",\"active\":0,\"url\":{\"url\":\"\",\"type\":\"menu\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11,\"menu\":\"index.php?option=com_easystore&view=products&catid=0&Itemid=358\"},\"class\":\"\"},{\"title\":\"Categories\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\"},{\"title\":\"Component\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\"},{\"title\":\"Accessories\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\",\"admin_label\":\"Terms Of Use copy\"}],\"scroll_to\":0,\"sticky_menu\":0,\"type\":\"list\",\"align\":\"left\",\"style_tab\":\"active\",\"link_color\":\"var(--footer-link-color)\",\"link_bg\":\"rgba(0, 0, 0, 0)\",\"link_color_hover\":\"#FFFFFF\",\"link_bg_hover\":\"\",\"link_color_active\":\"#919FAD\",\"link_bg_active\":\"\",\"link_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link_border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"responsive_menu\":false,\"responsive_menu_tab\":\"normal\",\"responsive_bar_color\":\"#3366FF\",\"responsive_bar_bg_active\":\"#3366FF\",\"responsive_bar_bg\":\"#F5F5F5\",\"responsive_bar_color_active\":\"#FFFFFF\",\"responsive_bar_aria_label\":\"\",\"instFormId\":1736751773579,\"link_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"link_typography\":{\"font\":\"Poppins\",\"weight\":\"400\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 5.5A1.5 1.5 0 014.5 4h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 5.5zM3 15.5A1.5 1.5 0 014.5 14h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 15.5zM3 25.5A1.5 1.5 0 014.5 24h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 25.5z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Navigation\",\"parent\":\"2c83eac1-7aeb-43c0-9ea8-c303ff044a1d\"},{\"id\":\"2f408bf2-c9f5-4686-b2da-a30f9005c817\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 20px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Why choose us\",\"heading_selector\":\"h3\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"instFormId\":\"304e8e27-148a-42b4-8675-5f4d81d44c40\",\"style_tab\":\"normal\",\"responsive_menu_tab\":\"normal\",\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"title_color\":{\"color\":\"#FFFFFF\",\"type\":\"solid\"},\"heading_typography\":{\"font\":\"Poppins\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":true,\"italic\":\"\",\"underline\":\"\",\"weight\":\"500\",\"type\":\"google\"}},\"parent\":\"7355f439-c5cf-44e7-b9b8-46edfa419b12\"},{\"id\":\"4bb19d15-7684-44a5-ba30-7489ce785937\",\"type\":\"general\",\"name\":\"navigation\",\"visibility\":true,\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"#addonId ul{\\n    display: flex;\\n    flex-direction: column;\\n    gap: 10px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"sp_link_list_item\":[{\"title\":\"Product recall\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\"},{\"title\":\"Gift vouchers\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\"},{\"title\":\"Returns and exchange\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\"},{\"title\":\"Shipping options\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\",\"admin_label\":\"Terms Of Use copy\"}],\"scroll_to\":0,\"sticky_menu\":0,\"type\":\"list\",\"align\":\"left\",\"style_tab\":\"active\",\"link_color\":\"var(--footer-link-color)\",\"link_bg\":\"rgba(0, 0, 0, 0)\",\"link_color_hover\":\"#FFFFFF\",\"link_bg_hover\":\"\",\"link_color_active\":\"#919FAD\",\"link_bg_active\":\"\",\"link_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link_border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"responsive_menu\":false,\"responsive_menu_tab\":\"normal\",\"responsive_bar_color\":\"#3366FF\",\"responsive_bar_bg_active\":\"#3366FF\",\"responsive_bar_bg\":\"#F5F5F5\",\"responsive_bar_color_active\":\"#FFFFFF\",\"responsive_bar_aria_label\":\"\",\"instFormId\":1736751773579,\"link_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"link_typography\":{\"font\":\"Poppins\",\"weight\":\"400\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 5.5A1.5 1.5 0 014.5 4h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 5.5zM3 15.5A1.5 1.5 0 014.5 14h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 15.5zM3 25.5A1.5 1.5 0 014.5 24h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 25.5z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Navigation\",\"parent\":\"7355f439-c5cf-44e7-b9b8-46edfa419b12\"},{\"id\":\"83f5726f-3b58-42ca-a145-a99b2028c96f\",\"type\":\"structure\",\"name\":\"div\",\"visibility\":true,\"title\":\"Div\",\"icon\":\"<svg xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\" viewBox=\\\"0 0 32 32\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M0 5.1h2.9V2.9h2.2V0H0v5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 0h-7.3v2.9h7.3V0z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M26.9 0v2.9h2.2v2.2H32V0h-5.1z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M2.9 12.4H0v7.3h2.9v-7.3zM32 12.4h-2.9v7.3H32v-7.3z\\\" fill=\\\"currentColor\\\"><\\/path><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M2.9 26.9H0V32h5.1v-2.9H2.9v-2.2zM29.1 29.1h-2.2V32H32v-5.1h-2.9v2.2z\\\" fill=\\\"currentColor\\\"><\\/path><path d=\\\"M19.7 29.1h-7.3V32h7.3v-2.9z\\\" fill=\\\"currentColor\\\"><\\/path><\\/svg>\",\"settings\":{\"global_padding\":\"\",\"global_margin\":{\"xl\":\"\",\"sm\":\"0px 0px 40px 0px\",\"lg\":\"0px 0px 40px 0px\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"display\":\"flex\",\"flex_direction\":{\"xl\":\"row\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"column\"},\"reverse_direction\":{\"xl\":0,\"lg\":0,\"md\":0,\"sm\":0,\"xs\":0},\"justify_content\":{\"xl\":\"space-between\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"flex-start\"},\"align_items\":{\"xl\":\"flex-start\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"flex-start\"},\"flex_wrap\":{\"xl\":\"nowrap\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"flex_gap\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"20px\"},\"overflow\":\"visible\"},\"children\":[\"4bb026bd-d939-4487-8758-2376124a09e8\",\"7355f439-c5cf-44e7-b9b8-46edfa419b12\",\"2c83eac1-7aeb-43c0-9ea8-c303ff044a1d\"]},{\"id\":\"304e8e27-148a-42b4-8675-5f4d81d44c40\",\"type\":\"content\",\"name\":\"heading\",\"visibility\":true,\"title\":\"Heading\",\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path d=\\\"M18.631 30v-1.648h.517c.445 0 .86-.032 1.248-.094.39-.065.727-.197 1.012-.394.286-.196.516-.482.688-.851.172-.37.257-.862.257-1.477v-9.19H9.65v9.19c0 .614.085 1.105.256 1.477.172.369.401.655.688.851.286.199.625.328 1.02.394.395.063.807.095 1.24.095h.517V30H2v-1.647h.497c.444 0 .86-.032 1.249-.095a2.524 2.524 0 001.021-.394c.292-.198.52-.482.688-.85.165-.37.246-.864.246-1.478V6.31c0-.574-.086-1.036-.257-1.388a2.007 2.007 0 00-.698-.814 2.506 2.506 0 00-1.022-.374 8.227 8.227 0 00-1.228-.086H2V2h11.37v1.647h-.517a7.68 7.68 0 00-1.24.096 2.456 2.456 0 00-1.02.393c-.286.197-.515.481-.688.852-.171.37-.256.862-.256 1.475v7.927H22.35V6.463c0-.614-.085-1.105-.256-1.476-.171-.37-.401-.655-.688-.851a2.452 2.452 0 00-1.012-.393 7.601 7.601 0 00-1.249-.096h-.516V2H30v1.647h-.496c-.445 0-.86.031-1.249.096a2.529 2.529 0 00-1.021.393c-.292.197-.52.481-.687.851-.167.37-.248.862-.248 1.476v19.265c0 .575.087 1.037.257 1.388.171.352.405.617.697.794.291.18.63.297 1.02.356.39.058.799.086 1.23.086H30V30H18.631z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"settings\":{\"global_padding\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_margin\":{\"xl\":\"0px 0px 20px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":\"\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#FFFFFF\",\"inset\":false,\"enabled\":false},\"class\":\"\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"title\":\"Information\",\"heading_selector\":\"h3\",\"title_text_shadow\":{\"ho\":0,\"vo\":0,\"blur\":0,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"alignment\":{\"xl\":\"left\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_icon_position\":\"before\",\"title_margin\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"instFormId\":\"304e8e27-148a-42b4-8675-5f4d81d44c40\",\"style_tab\":\"normal\",\"responsive_menu_tab\":\"normal\",\"title_link\":{\"url\":\"\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"title_color\":{\"color\":\"#FFFFFF\",\"type\":\"solid\"},\"heading_typography\":{\"font\":\"Poppins\",\"size\":{\"xl\":{\"value\":\"14\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"18\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"uppercase\":true,\"italic\":\"\",\"underline\":\"\",\"weight\":\"500\",\"type\":\"google\"}},\"parent\":\"4bb026bd-d939-4487-8758-2376124a09e8\"},{\"id\":\"3f045ef3-0e3f-4ec9-b5b7-5b0925fcfddd\",\"type\":\"general\",\"name\":\"navigation\",\"visibility\":true,\"settings\":{\"global_padding\":\"\",\"global_margin\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_image\":{\"src\":\"\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":{\"src\":\"\"},\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"transform\":{\"move\":{\"x\":{\"value\":\"\",\"unit\":\"px\"},\"y\":{\"value\":\"\",\"unit\":\"px\"}},\"rotate\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"},\"z\":{\"value\":\"\",\"unit\":\"deg\"}},\"scale\":{\"x\":\"\",\"y\":\"\"},\"skew\":{\"x\":{\"value\":\"\",\"unit\":\"deg\"},\"y\":{\"value\":\"\",\"unit\":\"deg\"}},\"transform_origin\":{\"top\":{\"value\":\"50\",\"unit\":\"%\"},\"left\":{\"value\":\"50\",\"unit\":\"%\"}}},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_border_radius\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"global_boxshadow\":\"0 0 0 0 #FFFFFF\",\"class\":\"\",\"global_custom_css\":\"#addonId ul{\\n    display: flex;\\n    flex-direction: column;\\n    gap: 10px;\\n}\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_xl\":\"0\",\"hidden_lg\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"admin_label\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"scrolling_options\":\"fullpage\",\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"sp_link_list_item\":[{\"title\":\"About Us\",\"active\":0,\"url\":{\"url\":\"\",\"type\":\"menu\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11,\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=2&Itemid=107\"},\"class\":\"\"},{\"title\":\"Contact US\",\"active\":0,\"url\":{\"url\":\"\",\"type\":\"menu\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11,\"menu\":\"index.php?option=com_sppagebuilder&view=page&id=3&Itemid=113\"},\"class\":\"\"},{\"title\":\"Terms Of Use\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\"},{\"title\":\"Privacy Policy\",\"active\":0,\"url\":{\"url\":\"#\",\"type\":\"url\",\"new_tab\":false,\"nofollow\":false,\"noreferrer\":false,\"noopener\":false,\"close_popup\":11},\"class\":\"\",\"admin_label\":\"Terms Of Use copy\"}],\"scroll_to\":0,\"sticky_menu\":0,\"type\":\"list\",\"align\":\"left\",\"style_tab\":\"active\",\"link_color\":\"var(--footer-link-color)\",\"link_bg\":\"rgba(0, 0, 0, 0)\",\"link_color_hover\":\"#FFFFFF\",\"link_bg_hover\":\"\",\"link_color_active\":\"#919FAD\",\"link_bg_active\":\"\",\"link_padding\":{\"xl\":\"0px 0px 0px 0px\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"link_border_radius\":{\"xl\":\"0\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_position\":\"left\",\"responsive_menu\":false,\"responsive_menu_tab\":\"normal\",\"responsive_bar_color\":\"#3366FF\",\"responsive_bar_bg_active\":\"#3366FF\",\"responsive_bar_bg\":\"#F5F5F5\",\"responsive_bar_color_active\":\"#FFFFFF\",\"responsive_bar_aria_label\":\"\",\"instFormId\":1736751773579,\"link_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"icon_margin\":{\"xl\":\"\",\"lg\":\"\",\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"boxshadow\":{\"ho\":null,\"vo\":null,\"blur\":null,\"spread\":null,\"color\":\"\",\"inset\":false,\"enabled\":false},\"background_type\":\"none\",\"link_typography\":{\"font\":\"Poppins\",\"weight\":\"400\",\"uppercase\":false,\"underline\":false,\"italic\":false,\"type\":\"google\",\"size\":{\"xl\":{\"value\":\"16\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"line_height\":{\"xl\":{\"value\":\"24\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}},\"letter_spacing\":{\"xl\":{\"value\":\"\",\"unit\":\"px\"},\"lg\":{\"value\":\"\",\"unit\":\"px\"},\"md\":{\"value\":\"\",\"unit\":\"px\"},\"sm\":{\"value\":\"\",\"unit\":\"px\"},\"xs\":{\"value\":\"\",\"unit\":\"px\"}}}},\"icon\":\"<svg viewBox=\\\"0 0 32 32\\\" xmlns=\\\"http:\\/\\/www.w3.org\\/2000\\/svg\\\"><path fill-rule=\\\"evenodd\\\" clip-rule=\\\"evenodd\\\" d=\\\"M3 5.5A1.5 1.5 0 014.5 4h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 5.5zM3 15.5A1.5 1.5 0 014.5 14h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 15.5zM3 25.5A1.5 1.5 0 014.5 24h23a1.5 1.5 0 010 3h-23A1.5 1.5 0 013 25.5z\\\" fill=\\\"currentColor\\\"\\/><\\/svg>\",\"title\":\"Navigation\",\"parent\":\"4bb026bd-d939-4487-8758-2376124a09e8\"}],\"width\":{\"xl\":\"0%\",\"lg\":\"0%\",\"md\":\"100%\",\"sm\":\"100%\",\"xs\":\"100%\"}},{\"id\":\"9816dcb9-b9be-4a49-b676-9783605fb9ac\",\"class_name\":\"row-column\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":{\"src\":\"\"},\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_size_custom\":{\"unit\":\"px\"},\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"background_position_custom_x\":{\"unit\":\"px\"},\"background_position_custom_y\":{\"unit\":\"px\"},\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":{\"src\":\"\"},\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"use_border\":0,\"border_width\":\"\",\"boxshadow\":\"0 0 0 0 #FFFFFF\",\"items_align_center\":0,\"items_content_alignment\":\"center\",\"tablet_order_landscape\":\"\",\"tablet_order\":\"\",\"mobile_order_landscape\":\"\",\"mobile_order\":\"\",\"hidden_xl\":\"\",\"hidden_lg\":\"\",\"hidden_md\":\"\",\"hidden_sm\":\"\",